/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsTaskHandler<R extends Repository>
extends VcsTaskHandler {
    @NotNull
    private final AbstractRepositoryManager<R> myRepositoryManager;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myBranchType;

    protected DvcsTaskHandler(@NotNull AbstractRepositoryManager<R> repositoryManager, @NotNull Project project2, @NotNull String branchType) {
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "com/intellij/dvcs/branch/DvcsTaskHandler", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/branch/DvcsTaskHandler", "<init>"));
        }
        if (branchType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchType", "com/intellij/dvcs/branch/DvcsTaskHandler", "<init>"));
        }
        this.myRepositoryManager = repositoryManager;
        this.myProject = project2;
        this.myBranchType = branchType;
    }

    public boolean isEnabled() {
        return !this.myRepositoryManager.getRepositories().isEmpty();
    }

    public VcsTaskHandler.TaskInfo startNewTask(@NotNull String taskName) {
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/dvcs/branch/DvcsTaskHandler", "startNewTask"));
        }
        List<R> repositories = this.myRepositoryManager.getRepositories();
        List problems = ContainerUtil.filter(repositories, repository -> {
            if (taskName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/dvcs/branch/DvcsTaskHandler", "lambda$startNewTask$0"));
            }
            return this.hasBranch(repository, new VcsTaskHandler.TaskInfo(taskName, Collections.emptyList()));
        });
        ArrayList<R> map2 = new ArrayList<R>();
        if (!problems.isEmpty() && (ApplicationManager.getApplication().isUnitTestMode() || Messages.showDialog((Project)this.myProject, (String)("<html>The following repositories already have specified " + this.myBranchType + "<b>" + taskName + "</b>:<br>" + StringUtil.join((Iterable)problems, (String)"<br>") + ".<br>Do you want to checkout existing " + this.myBranchType + "?"), (String)(StringUtil.capitalize((String)this.myBranchType) + " Already Exists"), (String[])new String[]{Messages.YES_BUTTON, Messages.NO_BUTTON}, (int)0, (Icon)Messages.getWarningIcon()) == 0)) {
            this.checkout(taskName, problems, null);
            map2.addAll(problems);
        }
        repositories.removeAll(problems);
        if (!repositories.isEmpty()) {
            this.checkoutAsNewBranch(taskName, repositories);
        }
        map2.addAll(repositories);
        return new VcsTaskHandler.TaskInfo(taskName, (Collection)ContainerUtil.map(map2, r -> r.getPresentableUrl()));
    }

    public void switchToTask(@NotNull VcsTaskHandler.TaskInfo taskInfo, @Nullable Runnable invokeAfter) {
        if (taskInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskInfo", "com/intellij/dvcs/branch/DvcsTaskHandler", "switchToTask"));
        }
        String branchName = taskInfo.getName();
        List<R> repositories = this.getRepositories(taskInfo.getRepositories());
        List notFound = ContainerUtil.filter(repositories, repository -> {
            if (taskInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskInfo", "com/intellij/dvcs/branch/DvcsTaskHandler", "lambda$switchToTask$2"));
            }
            return !this.hasBranch(repository, taskInfo);
        });
        if (!notFound.isEmpty()) {
            this.checkoutAsNewBranch(branchName, notFound);
        }
        repositories.removeAll(notFound);
        if (!repositories.isEmpty()) {
            this.checkout(branchName, repositories, invokeAfter);
        }
    }

    public void closeTask(@NotNull VcsTaskHandler.TaskInfo taskInfo, @NotNull VcsTaskHandler.TaskInfo original) {
        if (taskInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskInfo", "com/intellij/dvcs/branch/DvcsTaskHandler", "closeTask"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/dvcs/branch/DvcsTaskHandler", "closeTask"));
        }
        this.checkout(original.getName(), this.getRepositories(original.getRepositories()), () -> {
            if (taskInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskInfo", "com/intellij/dvcs/branch/DvcsTaskHandler", "lambda$closeTask$3"));
            }
            this.mergeAndClose(taskInfo.getName(), this.getRepositories(taskInfo.getRepositories()));
        });
    }

    public boolean isSyncEnabled() {
        return this.myRepositoryManager.isSyncEnabled();
    }

    @NotNull
    public VcsTaskHandler.TaskInfo[] getCurrentTasks() {
        List<R> repositories = this.myRepositoryManager.getRepositories();
        FactoryMap<String, VcsTaskHandler.TaskInfo> tasks = new FactoryMap<String, VcsTaskHandler.TaskInfo>(){

            @Nullable
            protected VcsTaskHandler.TaskInfo create(String key2) {
                return new VcsTaskHandler.TaskInfo(key2, new ArrayList());
            }
        };
        for (Repository repository : repositories) {
            String branch = this.getActiveBranch(repository);
            if (branch == null) continue;
            ((VcsTaskHandler.TaskInfo)tasks.get((Object)branch)).getRepositories().add(repository.getPresentableUrl());
        }
        if (tasks.size() == 0) {
            VcsTaskHandler.TaskInfo[] taskInfoArray = new VcsTaskHandler.TaskInfo[]{};
            if (taskInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/branch/DvcsTaskHandler", "getCurrentTasks"));
            }
            return taskInfoArray;
        }
        if (this.isSyncEnabled()) {
            VcsTaskHandler.TaskInfo[] taskInfoArray = new VcsTaskHandler.TaskInfo[]{(VcsTaskHandler.TaskInfo)tasks.values().iterator().next()};
            if (taskInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/branch/DvcsTaskHandler", "getCurrentTasks"));
            }
            return taskInfoArray;
        }
        VcsTaskHandler.TaskInfo[] taskInfoArray = tasks.values().toArray(new VcsTaskHandler.TaskInfo[tasks.values().size()]);
        if (taskInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/branch/DvcsTaskHandler", "getCurrentTasks"));
        }
        return taskInfoArray;
    }

    public VcsTaskHandler.TaskInfo[] getAllExistingTasks() {
        List<R> repositories = this.myRepositoryManager.getRepositories();
        MultiMap tasks = new MultiMap();
        for (Repository repository : repositories) {
            for (VcsTaskHandler.TaskInfo branch : this.getAllBranches(repository)) {
                tasks.putValue((Object)branch.getName(), (Object)branch);
            }
        }
        return (VcsTaskHandler.TaskInfo[])ContainerUtil.map2Array((Collection)tasks.entrySet(), VcsTaskHandler.TaskInfo.class, entry -> {
            HashSet repositories1 = new HashSet();
            boolean remote = false;
            for (VcsTaskHandler.TaskInfo info : (Collection)entry.getValue()) {
                remote |= info.isRemote();
                repositories1.addAll(info.getRepositories());
            }
            return new VcsTaskHandler.TaskInfo((String)entry.getKey(), (Collection)repositories1, remote);
        });
    }

    @NotNull
    private List<R> getRepositories(@NotNull Collection<String> urls) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/dvcs/branch/DvcsTaskHandler", "getRepositories"));
        }
        List repositories = this.myRepositoryManager.getRepositories();
        List list2 = ContainerUtil.mapNotNull(urls, (Function)((NullableFunction)s -> (Repository)ContainerUtil.find((Iterable)repositories, repository -> s.equals(repository.getPresentableUrl()))));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/branch/DvcsTaskHandler", "getRepositories"));
        }
        return list2;
    }

    protected abstract void checkout(@NotNull String var1, @NotNull List<R> var2, @Nullable Runnable var3);

    protected abstract void checkoutAsNewBranch(@NotNull String var1, @NotNull List<R> var2);

    @Nullable
    protected abstract String getActiveBranch(R var1);

    @NotNull
    protected abstract Iterable<VcsTaskHandler.TaskInfo> getAllBranches(@NotNull R var1);

    protected abstract void mergeAndClose(@NotNull String var1, @NotNull List<R> var2);

    protected abstract boolean hasBranch(@NotNull R var1, @NotNull VcsTaskHandler.TaskInfo var2);
}

