/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootAction<T extends Repository>
extends ActionGroup
implements PopupElementWithAdditionalInfo {
    @NotNull
    protected final T myRepository;
    @NotNull
    private final ActionGroup myGroup;
    @Nullable
    private final String myBranchText;

    public RootAction(@NotNull T repository, @NotNull ActionGroup actionsGroup, @Nullable String branchText) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/ui/RootAction", "<init>"));
        }
        if (actionsGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionsGroup", "com/intellij/dvcs/ui/RootAction", "<init>"));
        }
        super("", true);
        this.myRepository = repository;
        this.myGroup = actionsGroup;
        this.myBranchText = branchText;
        this.getTemplatePresentation().setText(DvcsUtil.getShortRepositoryName(repository), false);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = this.myGroup.getChildren(e);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/ui/RootAction", "getChildren"));
        }
        return anActionArray;
    }

    @Override
    @Nullable
    public String getInfoText() {
        return this.myBranchText;
    }
}

