/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.util.messages.Topic;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RunManagerListener
extends EventListener {
    public static final Topic<RunManagerListener> TOPIC = new Topic("RunManager", RunManagerListener.class);

    default public void runConfigurationSelected() {
    }

    default public void beforeRunTasksChanged() {
    }

    default public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/RunManagerListener", "runConfigurationAdded"));
        }
    }

    default public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/RunManagerListener", "runConfigurationRemoved"));
        }
    }

    default public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings, @Nullable String existingId) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/RunManagerListener", "runConfigurationChanged"));
        }
        this.runConfigurationChanged(settings);
    }

    default public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/RunManagerListener", "runConfigurationChanged"));
        }
    }

    default public void beginUpdate() {
    }

    default public void endUpdate() {
    }
}

