/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRunConfigurationAction
extends ActionGroup {
    protected static final Logger LOG = Logger.getInstance(BaseRunConfigurationAction.class);

    protected BaseRunConfigurationAction(String text2, String description, Icon icon) {
        super(text2, description, icon);
        this.setPopup(true);
        this.setEnabledInModalContext(true);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = e != null ? this.getChildren(e.getDataContext()) : EMPTY_ARRAY;
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/BaseRunConfigurationAction", "getChildren"));
        }
        return anActionArray;
    }

    private AnAction[] getChildren(DataContext dataContext) {
        List<ConfigurationFromContext> producers;
        final ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        RunnerAndConfigurationSettings existing = context.findExisting();
        if (existing == null && (producers = this.getConfigurationsFromContext(context)).size() > 1) {
            AnAction[] children2 = new AnAction[producers.size()];
            int childIdx = 0;
            for (final ConfigurationFromContext fromContext : producers) {
                ConfigurationType configurationType = fromContext.getConfigurationType();
                RunConfiguration configuration = fromContext.getConfiguration();
                String actionName = BaseRunConfigurationAction.childActionName(configurationType, configuration);
                AnAction anAction = new AnAction(actionName, configurationType.getDisplayName(), configuration.getIcon()){

                    public void actionPerformed(AnActionEvent e) {
                        BaseRunConfigurationAction.this.perform(fromContext, context);
                    }
                };
                anAction.getTemplatePresentation().setText(actionName, false);
                children2[childIdx++] = anAction;
            }
            return children2;
        }
        return EMPTY_ARRAY;
    }

    @NotNull
    private List<ConfigurationFromContext> getConfigurationsFromContext(ConfigurationContext context) {
        List fromContext = context.getConfigurationsFromContext();
        if (fromContext == null) {
            List<ConfigurationFromContext> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/BaseRunConfigurationAction", "getConfigurationsFromContext"));
            }
            return list2;
        }
        ArrayList<ConfigurationFromContext> enabledConfigurations = new ArrayList<ConfigurationFromContext>();
        for (ConfigurationFromContext configurationFromContext : fromContext) {
            if (!this.isEnabledFor(configurationFromContext.getConfiguration())) continue;
            enabledConfigurations.add(configurationFromContext);
        }
        ArrayList<ConfigurationFromContext> arrayList = enabledConfigurations;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/BaseRunConfigurationAction", "getConfigurationsFromContext"));
        }
        return arrayList;
    }

    protected boolean isEnabledFor(RunConfiguration configuration) {
        return true;
    }

    public boolean canBePerformed(DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 != null && DumbService.isDumb((Project)project2)) {
            return false;
        }
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        RunnerAndConfigurationSettings existing = context.findExisting();
        if (existing == null) {
            List<ConfigurationFromContext> fromContext = this.getConfigurationsFromContext(context);
            return fromContext.size() <= 1;
        }
        return true;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        final ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        RunnerAndConfigurationSettings existing = context.findExisting();
        if (existing == null) {
            List<ConfigurationFromContext> producers = this.getConfigurationsFromContext(context);
            if (producers.isEmpty()) {
                return;
            }
            if (producers.size() > 1) {
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                Collections.sort(producers, ConfigurationFromContext.NAME_COMPARATOR);
                ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ConfigurationFromContext>(ExecutionBundle.message((String)"configuration.action.chooser.title", (Object[])new Object[0]), producers){

                    @NotNull
                    public String getTextFor(ConfigurationFromContext producer) {
                        String string = BaseRunConfigurationAction.childActionName(producer.getConfigurationType(), producer.getConfiguration());
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/BaseRunConfigurationAction$2", "getTextFor"));
                        }
                        return string;
                    }

                    public Icon getIconFor(ConfigurationFromContext producer) {
                        return producer.getConfigurationType().getIcon();
                    }

                    public PopupStep onChosen(ConfigurationFromContext producer, boolean finalChoice) {
                        BaseRunConfigurationAction.this.perform(producer, context);
                        return FINAL_CHOICE;
                    }
                });
                InputEvent event = e.getInputEvent();
                if (event instanceof MouseEvent) {
                    popup.show(new RelativePoint((MouseEvent)event));
                } else if (editor != null) {
                    popup.showInBestPositionFor(editor);
                } else {
                    popup.showInBestPositionFor(dataContext);
                }
            } else {
                this.perform(producers.get(0), context);
            }
            return;
        }
        this.perform(context);
    }

    private void perform(ConfigurationFromContext configurationFromContext, ConfigurationContext context) {
        RunnerAndConfigurationSettings configurationSettings = configurationFromContext.getConfigurationSettings();
        context.setConfiguration(configurationSettings);
        configurationFromContext.onFirstRun(context, () -> this.perform(context));
    }

    protected abstract void perform(ConfigurationContext var1);

    public void update(AnActionEvent event) {
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)event.getDataContext());
        Presentation presentation = event.getPresentation();
        RunnerAndConfigurationSettings existing = context.findExisting();
        RunnerAndConfigurationSettings configuration = existing;
        if (configuration == null) {
            configuration = context.getConfiguration();
        }
        if (configuration == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
        } else {
            presentation.setEnabled(true);
            presentation.setVisible(true);
            List<ConfigurationFromContext> fromContext = this.getConfigurationsFromContext(context);
            if (existing == null && !fromContext.isEmpty()) {
                context.setConfiguration(fromContext.get(0).getConfigurationSettings());
            }
            String name2 = BaseRunConfigurationAction.suggestRunActionName((LocatableConfiguration)configuration.getConfiguration());
            this.updatePresentation(presentation, existing != null || fromContext.size() <= 1 ? name2 : "", context);
        }
    }

    public boolean isDumbAware() {
        return false;
    }

    public static String suggestRunActionName(LocatableConfiguration configuration) {
        String actionName;
        if (configuration instanceof LocatableConfigurationBase && configuration.isGeneratedName() && (actionName = ((LocatableConfigurationBase)configuration).getActionName()) != null) {
            return actionName;
        }
        return ProgramRunnerUtil.shortenName(configuration.getName(), 0);
    }

    @NotNull
    private static String childActionName(ConfigurationType configurationType, RunConfiguration configuration) {
        String string = configuration instanceof LocatableConfiguration ? StringUtil.unquoteString((String)BaseRunConfigurationAction.suggestRunActionName((LocatableConfiguration)configuration)) : configurationType.getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/BaseRunConfigurationAction", "childActionName"));
        }
        return string;
    }

    protected abstract void updatePresentation(Presentation var1, @NotNull String var2, ConfigurationContext var3);
}

