/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;

public class EditRunConfigurationsAction
extends DumbAwareAction {
    public EditRunConfigurationsAction() {
        this.getTemplatePresentation().setIcon(AllIcons.Actions.EditSource);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 != null && project2.isDisposed()) {
            return;
        }
        if (project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        EditConfigurationsDialog dialog2 = new EditConfigurationsDialog(project2);
        dialog2.show();
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project2 = e.getProject();
        presentation.setEnabled(project2 == null || !DumbService.isDumb((Project)project2));
        if ("RunConfigurationsCombobox".equals(e.getPlace())) {
            presentation.setText(ExecutionBundle.message((String)"edit.configuration.action", (Object[])new Object[0]));
            presentation.setDescription(presentation.getText());
        }
    }
}

