/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiMethodUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationConfigurationType
implements ConfigurationType {
    private final ConfigurationFactory myFactory = new ConfigurationFactoryEx(this){

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/application/ApplicationConfigurationType$1", "createTemplateConfiguration"));
            }
            ApplicationConfiguration applicationConfiguration = new ApplicationConfiguration("", project2, ApplicationConfigurationType.this);
            if (applicationConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/application/ApplicationConfigurationType$1", "createTemplateConfiguration"));
            }
            return applicationConfiguration;
        }

        public void onNewConfigurationCreated(@NotNull RunConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/application/ApplicationConfigurationType$1", "onNewConfigurationCreated"));
            }
            ((ModuleBasedConfiguration)configuration).onNewConfigurationCreated();
        }
    };

    public String getDisplayName() {
        return ExecutionBundle.message((String)"application.configuration.name", (Object[])new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return ExecutionBundle.message((String)"application.configuration.description", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return AllIcons.RunConfigurations.Application;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    @Nullable
    public static PsiClass getMainClass(PsiElement element) {
        while (element != null) {
            if (element instanceof PsiClass) {
                PsiClass aClass = (PsiClass)element;
                if (PsiMethodUtil.findMainInClass((PsiClass)aClass) != null) {
                    return aClass;
                }
            } else if (element instanceof PsiJavaFile) {
                PsiClass[] classes2;
                for (PsiClass aClass : classes2 = ((PsiJavaFile)element).getClasses()) {
                    if (PsiMethodUtil.findMainInClass((PsiClass)aClass) == null) continue;
                    return aClass;
                }
            }
            element = element.getParent();
        }
        return null;
    }

    @NotNull
    public String getId() {
        if ("Application" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/application/ApplicationConfigurationType", "getId"));
        }
        return "Application";
    }

    @NotNull
    public static ApplicationConfigurationType getInstance() {
        ApplicationConfigurationType applicationConfigurationType = (ApplicationConfigurationType)ConfigurationTypeUtil.findConfigurationType(ApplicationConfigurationType.class);
        if (applicationConfigurationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/application/ApplicationConfigurationType", "getInstance"));
        }
        return applicationConfigurationType;
    }
}

