/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.util.Condition;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class ProcessBackedConsoleExecuteActionHandler
extends BaseConsoleExecuteActionHandler
implements Condition<LanguageConsoleView> {
    private volatile ProcessHandler myProcessHandler;

    public ProcessBackedConsoleExecuteActionHandler(ProcessHandler processHandler2, boolean preserveMarkup) {
        super(preserveMarkup);
        this.myProcessHandler = processHandler2;
    }

    public void setProcessHandler(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/console/ProcessBackedConsoleExecuteActionHandler", "setProcessHandler"));
        }
        this.myProcessHandler = processHandler2;
    }

    @Override
    protected void execute(@NotNull String text2, @NotNull LanguageConsoleView console) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/console/ProcessBackedConsoleExecuteActionHandler", "execute"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/console/ProcessBackedConsoleExecuteActionHandler", "execute"));
        }
        this.processLine(text2);
    }

    public void processLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/execution/console/ProcessBackedConsoleExecuteActionHandler", "processLine"));
        }
        this.sendText(line + "\n");
    }

    public void sendText(String line) {
        Charset charset = this.myProcessHandler instanceof BaseOSProcessHandler ? ((BaseOSProcessHandler)this.myProcessHandler).getCharset() : null;
        OutputStream outputStream = this.myProcessHandler.getProcessInput();
        assert (outputStream != null) : "output stream is null";
        try {
            byte[] bytes = charset != null ? line.getBytes(charset) : line.getBytes();
            outputStream.write(bytes);
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final boolean isProcessTerminated() {
        ProcessHandler handler2 = this.myProcessHandler;
        return handler2 == null || handler2.isProcessTerminated();
    }

    public boolean value(LanguageConsoleView console) {
        return !this.isProcessTerminated();
    }
}

