/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.DashboardGroupingRule;
import com.intellij.execution.dashboard.DashboardListener;
import com.intellij.execution.dashboard.PanelContentUI;
import com.intellij.execution.dashboard.RunDashboardContent;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.tree.DashboardGrouper;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="RunDashboard", storages={@Storage(value="$WORKSPACE_FILE$")})
public class RunDashboardManagerImpl
implements RunDashboardManager,
PersistentStateComponent<State> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ContentManager myContentManager;
    @NotNull
    private final List<DashboardGrouper> myGroupers;
    private boolean myShowConfigurations;
    private RunDashboardContent myDashboardContent;
    private Content myToolWindowContent;

    public RunDashboardManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/dashboard/RunDashboardManagerImpl", "<init>"));
        }
        this.myShowConfigurations = true;
        this.myProject = project2;
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        PanelContentUI contentUI = new PanelContentUI();
        this.myContentManager = contentFactory.createContentManager((ContentUI)contentUI, false, project2);
        this.myGroupers = Arrays.stream(DashboardGroupingRule.EP_NAME.getExtensions()).sorted(DashboardGroupingRule.PRIORITY_COMPARATOR).map(DashboardGrouper::new).collect(Collectors.toList());
        if (RunDashboardManagerImpl.isDashboardEnabled()) {
            this.initToolWindowListeners();
        }
    }

    private static boolean isDashboardEnabled() {
        return Registry.is((String)"ide.run.dashboard") && ((RunDashboardContributor[])RunDashboardContributor.EP_NAME.getExtensions()).length > 0;
    }

    private void initToolWindowListeners() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/dashboard/RunDashboardManagerImpl$1", "runConfigurationAdded"));
                }
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
            }

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/dashboard/RunDashboardManagerImpl$1", "runConfigurationRemoved"));
                }
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/dashboard/RunDashboardManagerImpl$1", "runConfigurationChanged"));
                }
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
            }
        });
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                if (executorId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/dashboard/RunDashboardManagerImpl$2", "processStarted"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/dashboard/RunDashboardManagerImpl$2", "processStarted"));
                }
                if (handler2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/dashboard/RunDashboardManagerImpl$2", "processStarted"));
                }
                RunDashboardManagerImpl.this.updateToolWindowContent();
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2, int exitCode) {
                if (executorId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/dashboard/RunDashboardManagerImpl$2", "processTerminated"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/dashboard/RunDashboardManagerImpl$2", "processTerminated"));
                }
                if (handler2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/dashboard/RunDashboardManagerImpl$2", "processTerminated"));
                }
                RunDashboardManagerImpl.this.updateToolWindowContent();
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }
        });
        connection.subscribe(RunDashboardManager.DASHBOARD_TOPIC, (Object)new DashboardListener(){

            public void contentChanged(boolean withStructure) {
                RunDashboardManagerImpl.this.updateDashboard(withStructure);
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
            }

            public void exitDumbMode() {
                RunDashboardManagerImpl.this.updateDashboard(false);
            }
        });
        this.myContentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                RunDashboardManagerImpl.this.updateToolWindowContent();
                RunDashboardManagerImpl.this.updateDashboard(true);
            }
        });
    }

    public ContentManager getDashboardContentManager() {
        return this.myContentManager;
    }

    public String getToolWindowId() {
        return ToolWindowId.RUN_DASHBOARD;
    }

    public Icon getToolWindowIcon() {
        return AllIcons.Toolwindows.ToolWindowRun;
    }

    public boolean isToolWindowAvailable() {
        return RunDashboardManagerImpl.isDashboardEnabled() && this.hasContent();
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/execution/dashboard/RunDashboardManagerImpl", "createToolWindowContent"));
        }
        this.myDashboardContent = new RunDashboardContent(this.myProject, this.myContentManager, this.myGroupers);
        this.myToolWindowContent = new RunDashboardTabbedContent(this.myContentManager, this.myDashboardContent, null, false);
        this.myToolWindowContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        Disposer.register((Disposable)this.myToolWindowContent, (Disposable)this.myDashboardContent);
        Disposer.register((Disposable)this.myToolWindowContent, () -> {
            this.myDashboardContent = null;
        });
        toolWindow.getContentManager().addContent(this.myToolWindowContent);
        toolWindow.setDefaultContentUiType(ToolWindowContentUiType.COMBO);
        toolWindow.setContentUiType(ToolWindowContentUiType.COMBO, null);
    }

    public List<Pair<RunnerAndConfigurationSettings, RunContentDescriptor>> getRunConfigurations() {
        ArrayList<Pair<RunnerAndConfigurationSettings, RunContentDescriptor>> result2 = new ArrayList<Pair<RunnerAndConfigurationSettings, RunContentDescriptor>>();
        List<RunnerAndConfigurationSettings> configurations = RunManager.getInstance((Project)this.myProject).getAllSettings().stream().filter(runConfiguration -> RunDashboardContributor.getContributor((ConfigurationType)runConfiguration.getType()) != null).collect(Collectors.toList());
        ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(this.myProject);
        configurations.forEach(configurationSettings -> {
            List<RunContentDescriptor> descriptors = this.filterByContent(executionManager.getDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)settings -> Comparing.equal((Object)settings.getConfiguration(), (Object)configurationSettings.getConfiguration()))));
            RunDashboardContributor contributor = RunDashboardContributor.getContributor((ConfigurationType)configurationSettings.getType());
            if (descriptors.isEmpty() && contributor != null && contributor.isShowInDashboard(configurationSettings.getConfiguration())) {
                result2.add(Pair.create((Object)configurationSettings, null));
            } else {
                descriptors.forEach(descriptor -> result2.add(Pair.create((Object)configurationSettings, (Object)descriptor)));
            }
        });
        List storedConfigurations = configurations.stream().map(RunnerAndConfigurationSettings::getConfiguration).collect(Collectors.toList());
        List<RunContentDescriptor> notStoredDescriptors = this.filterByContent(executionManager.getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)settings -> RunDashboardContributor.getContributor((ConfigurationType)settings.getType()) != null && !storedConfigurations.contains(settings.getConfiguration()))));
        notStoredDescriptors.forEach(descriptor -> {
            Set<RunnerAndConfigurationSettings> settings = executionManager.getConfigurations((RunContentDescriptor)descriptor);
            settings.forEach(setting -> result2.add(Pair.create((Object)setting, (Object)descriptor)));
        });
        return result2;
    }

    private List<RunContentDescriptor> filterByContent(List<RunContentDescriptor> descriptors) {
        return descriptors.stream().filter(descriptor -> {
            Content content = descriptor.getAttachedContent();
            return content != null && content.getManager() == this.myContentManager;
        }).collect(Collectors.toList());
    }

    public boolean isShowConfigurations() {
        return this.myShowConfigurations;
    }

    public void setShowConfigurations(boolean value2) {
        this.myShowConfigurations = value2;
        this.updateToolWindowContent();
    }

    private void updateDashboardIfNeeded(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings != null && RunDashboardContributor.getContributor((ConfigurationType)settings.getType()) != null) {
            this.updateDashboard(true);
        }
    }

    private void updateDashboard(boolean withStructure) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        toolWindowManager.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (withStructure) {
                boolean available = this.hasContent();
                ToolWindow toolWindow = toolWindowManager.getToolWindow(this.getToolWindowId());
                if (toolWindow == null) {
                    if (available) {
                        this.createToolWindow();
                    }
                    return;
                }
                boolean doShow = !toolWindow.isAvailable() && available;
                toolWindow.setAvailable(available, null);
                if (doShow) {
                    toolWindow.show(null);
                }
            }
            if (this.myDashboardContent != null) {
                this.myDashboardContent.updateContent(withStructure);
            }
        });
    }

    private void createToolWindow() {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(this.getToolWindowId(), false, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject, true);
        toolWindow.setIcon(this.getToolWindowIcon());
        this.createToolWindowContent(toolWindow);
    }

    private boolean hasContent() {
        return !this.getRunConfigurations().isEmpty();
    }

    private void updateToolWindowContent() {
        AppUIUtil.invokeLaterIfProjectAlive(this.myProject, () -> {
            Content content;
            if (this.myToolWindowContent == null) {
                return;
            }
            String tabName = null;
            Icon tabIcon = null;
            if (!this.myShowConfigurations && (content = this.myContentManager.getSelectedContent()) != null) {
                tabName = content.getTabName();
                tabIcon = content.getIcon();
            }
            this.myToolWindowContent.setDisplayName(tabName);
            this.myToolWindowContent.setIcon(tabIcon);
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(this.getToolWindowId());
            if (toolWindow instanceof ToolWindowImpl) {
                ToolWindowContentUi contentUi = ((ToolWindowImpl)toolWindow).getContentUI();
                contentUi.revalidate();
                contentUi.repaint();
            }
        });
    }

    @Nullable
    public State getState() {
        State state = new State();
        state.ruleStates = this.myGroupers.stream().filter(grouper -> !grouper.getRule().isAlwaysEnabled()).map(grouper -> new RuleState(grouper.getRule().getName(), grouper.isEnabled())).collect(Collectors.toList());
        return state;
    }

    public void loadState(State state) {
        state.ruleStates.forEach(ruleState -> {
            for (DashboardGrouper grouper : this.myGroupers) {
                if (!grouper.getRule().getName().equals(ruleState.name) || grouper.getRule().isAlwaysEnabled()) continue;
                grouper.setEnabled(ruleState.enabled);
                return;
            }
        });
    }

    private static class RunDashboardTabbedContent
    extends ContentImpl
    implements TabbedContent {
        private ContentManager myDashboardContentManager;
        private String myTitlePrefix = "Running Configurations:";

        RunDashboardTabbedContent(ContentManager dashboardContentManager, JComponent component, String displayName, boolean isPinnable) {
            super(component, displayName, isPinnable);
            this.myDashboardContentManager = dashboardContentManager;
        }

        public void addContent(@NotNull JComponent content, @NotNull String name2, boolean selectTab) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/dashboard/RunDashboardManagerImpl$RunDashboardTabbedContent", "addContent"));
            }
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/execution/dashboard/RunDashboardManagerImpl$RunDashboardTabbedContent", "addContent"));
            }
        }

        public void removeContent(@NotNull JComponent content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/dashboard/RunDashboardManagerImpl$RunDashboardTabbedContent", "removeContent"));
            }
        }

        public void selectContent(int index) {
            Content content = this.myDashboardContentManager.getContent(index);
            if (content != null) {
                this.myDashboardContentManager.setSelectedContent(content);
            }
        }

        public List<Pair<String, JComponent>> getTabs() {
            return Arrays.stream(this.myDashboardContentManager.getContents()).map(content -> Pair.create((Object)content.getDisplayName(), (Object)content.getComponent())).collect(Collectors.toList());
        }

        public String getTitlePrefix() {
            return this.myTitlePrefix;
        }

        public void setTitlePrefix(String titlePrefix) {
            this.myTitlePrefix = titlePrefix;
        }

        public void split() {
        }

        @Override
        public void dispose() {
            this.myDashboardContentManager = null;
            super.dispose();
        }
    }

    private static class RuleState {
        public String name;
        public boolean enabled = true;

        RuleState() {
        }

        RuleState(String name2, boolean enabled) {
            this.name = name2;
            this.enabled = enabled;
        }
    }

    static class State {
        public List<RuleState> ruleStates = new ArrayList<RuleState>();

        State() {
        }
    }
}

