/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.dashboard.DashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.actions.RunDashboardTreeLeafAction;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.ui.content.Content;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ExecutorAction
extends RunDashboardTreeLeafAction<DashboardRunConfigurationNode> {
    protected ExecutorAction(String text2, String description, Icon icon) {
        super(text2, description, icon);
    }

    protected boolean isEnabled4(DashboardRunConfigurationNode node) {
        String executorId = this.getExecutor().getId();
        ProgramRunner runner = ProgramRunnerUtil.getRunner(executorId, node.getConfigurationSettings());
        return runner != null && runner.canRun(executorId, (RunProfile)node.getConfigurationSettings().getConfiguration());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/dashboard/actions/ExecutorAction", "update"));
        }
        super.update(e);
        Project project2 = e.getProject();
        if (project2 == null) {
            this.update(e, false);
            return;
        }
        List targetNodes = this.getTargetNodes(e);
        if (RunDashboardManager.getInstance((Project)project2).isShowConfigurations()) {
            boolean running = targetNodes.stream().anyMatch(node -> {
                Content content = node.getContent();
                return content != null && !RunContentManagerImpl.isTerminated(content);
            });
            this.update(e, running);
            e.getPresentation().setEnabled(targetNodes.stream().anyMatch(this::isValid));
        } else {
            Content content = RunDashboardManager.getInstance((Project)project2).getDashboardContentManager().getSelectedContent();
            this.update(e, content != null && !RunContentManagerImpl.isTerminated(content));
            e.getPresentation().setEnabled(content != null);
        }
    }

    private boolean isValid(DashboardRunConfigurationNode node) {
        try {
            node.getConfigurationSettings().checkSettings(this.getExecutor());
            return true;
        }
        catch (IndexNotReadyException ex) {
            return true;
        }
        catch (RuntimeConfigurationError ex) {
            return false;
        }
        catch (RuntimeConfigurationException ex) {
            return true;
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/dashboard/actions/ExecutorAction", "actionPerformed"));
        }
        Project project2 = e.getProject();
        if (project2 == null || RunDashboardManager.getInstance((Project)project2).isShowConfigurations()) {
            super.actionPerformed(e);
        } else {
            Content content = RunDashboardManager.getInstance((Project)project2).getDashboardContentManager().getSelectedContent();
            if (content != null) {
                RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
                JComponent component = content.getComponent();
                if (component == null) {
                    return;
                }
                ExecutionEnvironment environment = (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext((Component)component));
                if (environment == null) {
                    return;
                }
                ExecutionManager.getInstance((Project)project2).restartRunProfile(project2, this.getExecutor(), ExecutionTargetManager.getActiveTarget((Project)project2), environment.getRunnerAndConfigurationSettings(), descriptor == null ? null : descriptor.getProcessHandler());
            }
        }
    }

    protected void doActionPerformed(DashboardRunConfigurationNode node) {
        if (!this.isValid(node)) {
            return;
        }
        RunContentDescriptor descriptor = node.getDescriptor();
        ExecutionManager.getInstance((Project)node.getProject()).restartRunProfile(node.getProject(), this.getExecutor(), ExecutionTargetManager.getActiveTarget((Project)node.getProject()), node.getConfigurationSettings(), descriptor == null ? null : descriptor.getProcessHandler());
    }

    protected Class<DashboardRunConfigurationNode> getTargetNodeClass() {
        return DashboardRunConfigurationNode.class;
    }

    protected abstract Executor getExecutor();

    protected abstract void update(@NotNull AnActionEvent var1, boolean var2);
}

