/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.ui.components.JBList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YourkitFilter
implements Filter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.filters.YourkitFilter");
    private final Project myProject;
    private static final Pattern PATTERN = Pattern.compile("\\s*(\\w*)\\(\\):(-?\\d*), (\\w*\\.java)\\n");

    public YourkitFilter(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/YourkitFilter", "<init>"));
        }
        this.myProject = project2;
    }

    public Filter.Result applyFilter(String line, int entireLength) {
        if (!line.endsWith(".java\n")) {
            return null;
        }
        try {
            Matcher matcher = PATTERN.matcher(line);
            if (matcher.matches()) {
                String method = matcher.group(1);
                int lineNumber = Integer.parseInt(matcher.group(2));
                String fileName = matcher.group(3);
                int textStartOffset = entireLength - line.length();
                PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)this.myProject);
                PsiFile[] psiFiles = cache.getFilesByName(fileName);
                if (psiFiles.length == 0) {
                    return null;
                }
                Object info = psiFiles.length == 1 ? new OpenFileHyperlinkInfo(this.myProject, psiFiles[0].getVirtualFile(), lineNumber - 1) : new MyHyperlinkInfo(psiFiles);
                return new Filter.Result(textStartOffset + matcher.start(2), textStartOffset + matcher.end(3), (HyperlinkInfo)info);
            }
        }
        catch (NumberFormatException e) {
            LOG.debug((Throwable)e);
        }
        return null;
    }

    private static class DefaultPsiElementListCellRenderer
    extends PsiElementListCellRenderer {
        private DefaultPsiElementListCellRenderer() {
        }

        public String getElementText(PsiElement element) {
            return element.getContainingFile().getName();
        }

        @Nullable
        protected String getContainerText(PsiElement element, String name2) {
            PsiDirectory parent = ((PsiFile)element).getParent();
            if (parent == null) {
                return null;
            }
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(parent);
            if (psiPackage == null) {
                return null;
            }
            return "(" + psiPackage.getQualifiedName() + ")";
        }

        @Override
        protected int getIconFlags() {
            return 0;
        }
    }

    private static class MyHyperlinkInfo
    implements HyperlinkInfo {
        private final PsiFile[] myPsiFiles;

        public MyHyperlinkInfo(PsiFile[] psiFiles) {
            this.myPsiFiles = psiFiles;
        }

        public void navigate(Project project2) {
            DefaultPsiElementListCellRenderer renderer = new DefaultPsiElementListCellRenderer();
            JBList list2 = new JBList((Object[])this.myPsiFiles);
            list2.setCellRenderer(renderer);
            PopupChooserBuilder builder = new PopupChooserBuilder((JList)list2);
            renderer.installSpeedSearch(builder);
            Runnable runnable2 = () -> MyHyperlinkInfo.lambda$navigate$0((JList)list2);
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext());
            builder.setTitle("Choose file").setItemChoosenCallback(runnable2).createPopup().showInBestPositionFor(editor);
        }

        private static /* synthetic */ void lambda$navigate$0(JList list2) {
            Object[] selectedElements;
            int[] ids = list2.getSelectedIndices();
            if (ids == null || ids.length == 0) {
                return;
            }
            for (Object element : selectedElements = list2.getSelectedValues()) {
                Navigatable descriptor = EditSourceUtil.getDescriptor((PsiElement)((PsiElement)element));
                if (descriptor == null || !descriptor.canNavigate()) continue;
                descriptor.navigate(true);
            }
        }
    }
}

