/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.Nullable;

class BeforeRunStepsPanel
extends JPanel {
    private final JCheckBox myShowSettingsBeforeRunCheckBox;
    private final JCheckBox myActivateToolWindowBeforeRunCheckBox;
    private final JBList myList;
    private final CollectionListModel<BeforeRunTask> myModel;
    private RunConfiguration myRunConfiguration;
    private final List<BeforeRunTask> originalTasks = new ArrayList<BeforeRunTask>();
    private final StepsBeforeRunListener myListener;
    private final JPanel myPanel;

    BeforeRunStepsPanel(StepsBeforeRunListener listener2) {
        this.myListener = listener2;
        this.myModel = new CollectionListModel((Object[])new BeforeRunTask[0]);
        this.myList = new JBList(this.myModel);
        this.myList.getEmptyText().setText(ExecutionBundle.message((String)"before.launch.panel.empty", (Object[])new Object[0]));
        this.myList.setSelectionMode(0);
        this.myList.setCellRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
        this.myModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.adjustVisibleRowCount();
                BeforeRunStepsPanel.this.updateText();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.adjustVisibleRowCount();
                BeforeRunStepsPanel.this.updateText();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }

            private void adjustVisibleRowCount() {
                BeforeRunStepsPanel.this.myList.setVisibleRowCount(Math.max(4, Math.min(8, BeforeRunStepsPanel.this.myModel.getSize())));
            }
        });
        ToolbarDecorator myDecorator = ToolbarDecorator.createDecorator((JList)this.myList);
        if (!SystemInfo.isMac) {
            myDecorator.setAsUsualTopToolbar();
        }
        myDecorator.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int index = BeforeRunStepsPanel.this.myList.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                Pair selection = BeforeRunStepsPanel.this.getSelection();
                if (selection == null) {
                    return;
                }
                BeforeRunTask task = (BeforeRunTask)selection.getFirst();
                BeforeRunTaskProvider provider = (BeforeRunTaskProvider)selection.getSecond();
                if (provider.configureTask(BeforeRunStepsPanel.this.myRunConfiguration, task)) {
                    BeforeRunStepsPanel.this.myModel.setElementAt((Object)task, index);
                    BeforeRunStepsPanel.this.updateText();
                }
            }
        });
        myDecorator.setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                Pair selection = BeforeRunStepsPanel.this.getSelection();
                return selection != null && ((BeforeRunTaskProvider)selection.getSecond()).isConfigurable();
            }
        });
        myDecorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                BeforeRunStepsPanel.this.doAddAction(button);
            }
        });
        myDecorator.setAddActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return BeforeRunStepsPanel.this.checkBeforeRunTasksAbility(true);
            }
        });
        this.myShowSettingsBeforeRunCheckBox = new JCheckBox(ExecutionBundle.message((String)"configuration.edit.before.run", (Object[])new Object[0]));
        this.myShowSettingsBeforeRunCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeforeRunStepsPanel.this.updateText();
            }
        });
        this.myActivateToolWindowBeforeRunCheckBox = new JCheckBox(ExecutionBundle.message((String)"configuration.activate.toolwindow.before.run", (Object[])new Object[0]));
        this.myActivateToolWindowBeforeRunCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeforeRunStepsPanel.this.updateText();
            }
        });
        this.myPanel = myDecorator.createPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.myPanel, "Center");
        JPanel checkboxPanel = new JPanel(new FlowLayout(3, JBUI.scale((int)5), JBUI.scale((int)5)));
        checkboxPanel.add(this.myShowSettingsBeforeRunCheckBox);
        checkboxPanel.add(this.myActivateToolWindowBeforeRunCheckBox);
        this.add((Component)checkboxPanel, "South");
    }

    @Nullable
    private Pair<BeforeRunTask, BeforeRunTaskProvider<BeforeRunTask>> getSelection() {
        int index = this.myList.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        BeforeRunTask task = (BeforeRunTask)this.myModel.getElementAt(index);
        Key providerId = task.getProviderId();
        BeforeRunTaskProvider provider = BeforeRunTaskProvider.getProvider((Project)this.myRunConfiguration.getProject(), (Key)providerId);
        return provider != null ? Pair.create((Object)task, (Object)provider) : null;
    }

    void doReset(RunnerAndConfigurationSettings settings) {
        this.myRunConfiguration = settings.getConfiguration();
        this.originalTasks.clear();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(this.myRunConfiguration.getProject());
        this.originalTasks.addAll(runManager.getBeforeRunTasks(this.myRunConfiguration));
        this.myModel.replaceAll(this.originalTasks);
        this.myShowSettingsBeforeRunCheckBox.setSelected(settings.isEditBeforeRun());
        this.myShowSettingsBeforeRunCheckBox.setEnabled(!this.isUnknown());
        this.myActivateToolWindowBeforeRunCheckBox.setSelected(settings.isActivateToolWindowBeforeRun());
        this.myActivateToolWindowBeforeRunCheckBox.setEnabled(!this.isUnknown());
        this.myPanel.setVisible(this.checkBeforeRunTasksAbility(false));
        this.updateText();
    }

    private void updateText() {
        List tasks;
        StringBuilder sb = new StringBuilder();
        if (this.myShowSettingsBeforeRunCheckBox.isSelected()) {
            sb.append(ExecutionBundle.message((String)"configuration.edit.before.run", (Object[])new Object[0]));
        }
        if (!(tasks = this.myModel.getItems()).isEmpty()) {
            BeforeRunTaskProvider provider;
            LinkedHashMap<BeforeRunTaskProvider, Integer> counter = new LinkedHashMap<BeforeRunTaskProvider, Integer>();
            for (BeforeRunTask task : tasks) {
                provider = BeforeRunTaskProvider.getProvider((Project)this.myRunConfiguration.getProject(), (Key)task.getProviderId());
                if (provider == null) continue;
                Integer count = (Integer)counter.get(provider);
                count = count == null ? Integer.valueOf(task.getItemsCount()) : Integer.valueOf(count + task.getItemsCount());
                counter.put(provider, count);
            }
            for (Map.Entry entry : counter.entrySet()) {
                provider = (BeforeRunTaskProvider)entry.getKey();
                String name2 = provider.getName();
                name2 = StringUtil.trimStart((String)name2, (String)"Run ");
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(name2);
                if ((Integer)entry.getValue() <= 1) continue;
                sb.append(" (").append((Integer)entry.getValue()).append(")");
            }
        }
        if (this.myActivateToolWindowBeforeRunCheckBox.isSelected()) {
            sb.append(sb.length() > 0 ? ", " : "").append(ExecutionBundle.message((String)"configuration.activate.toolwindow.before.run", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            sb.insert(0, ": ");
        }
        sb.insert(0, ExecutionBundle.message((String)"before.launch.panel.title", (Object[])new Object[0]));
        this.myListener.titleChanged(sb.toString());
    }

    public List<BeforeRunTask> getTasks(boolean applyCurrentState) {
        if (applyCurrentState) {
            this.originalTasks.clear();
            this.originalTasks.addAll(this.myModel.getItems());
        }
        return Collections.unmodifiableList(this.originalTasks);
    }

    public boolean needEditBeforeRun() {
        return this.myShowSettingsBeforeRunCheckBox.isSelected();
    }

    public boolean needActivateToolWindowBeforeRun() {
        return this.myActivateToolWindowBeforeRunCheckBox.isSelected();
    }

    private boolean checkBeforeRunTasksAbility(boolean checkOnlyAddAction) {
        BeforeRunTaskProvider[] providers2;
        if (this.isUnknown()) {
            return false;
        }
        Set<Key> activeProviderKeys = this.getActiveProviderKeys();
        for (BeforeRunTaskProvider provider : providers2 = (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myRunConfiguration.getProject())) {
            if (provider.createTask(this.myRunConfiguration) == null) continue;
            if (!checkOnlyAddAction) {
                return true;
            }
            if (provider.isSingleton() && activeProviderKeys.contains(provider.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isUnknown() {
        return this.myRunConfiguration instanceof UnknownRunConfiguration;
    }

    void doAddAction(AnActionButton button) {
        if (this.isUnknown()) {
            return;
        }
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        BeforeRunTaskProvider[] providers2 = (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myRunConfiguration.getProject());
        Set<Key> activeProviderKeys = this.getActiveProviderKeys();
        DefaultActionGroup actionGroup = new DefaultActionGroup(null, false);
        for (final BeforeRunTaskProvider provider : providers2) {
            if (provider.createTask(this.myRunConfiguration) == null || activeProviderKeys.contains(provider.getId()) && provider.isSingleton()) continue;
            AnAction providerAction = new AnAction(provider.getName(), null, provider.getIcon()){

                public void actionPerformed(AnActionEvent e) {
                    BeforeRunTask task = provider.createTask(BeforeRunStepsPanel.this.myRunConfiguration);
                    if (task != null) {
                        provider.configureTask(BeforeRunStepsPanel.this.myRunConfiguration, task);
                        if (!provider.canExecuteTask(BeforeRunStepsPanel.this.myRunConfiguration, task)) {
                            return;
                        }
                    } else {
                        return;
                    }
                    task.setEnabled(true);
                    HashSet configurationSet = new HashSet();
                    BeforeRunStepsPanel.this.getAllRunBeforeRuns(task, (Set)configurationSet);
                    if (configurationSet.contains(BeforeRunStepsPanel.this.myRunConfiguration)) {
                        JOptionPane.showMessageDialog(BeforeRunStepsPanel.this, ExecutionBundle.message((String)"before.launch.panel.cyclic_dependency_warning", (Object[])new Object[]{BeforeRunStepsPanel.this.myRunConfiguration.getName(), provider.getDescription(task)}), ExecutionBundle.message((String)"warning.common.title", (Object[])new Object[0]), 2);
                        return;
                    }
                    BeforeRunStepsPanel.this.addTask(task);
                    BeforeRunStepsPanel.this.myListener.fireStepsBeforeRunChanged();
                }
            };
            actionGroup.add(providerAction);
        }
        ListPopup popup = popupFactory.createActionGroupPopup(ExecutionBundle.message((String)"add.new.run.configuration.acrtion.name", (Object[])new Object[0]), (ActionGroup)actionGroup, SimpleDataContext.getProjectContext(this.myRunConfiguration.getProject()), false, false, false, null, -1, Conditions.alwaysTrue());
        popup.show(button.getPreferredPopupPoint());
    }

    public void addTask(BeforeRunTask task) {
        this.myModel.add((Object)task);
    }

    private Set<Key> getActiveProviderKeys() {
        HashSet result2 = new HashSet();
        for (BeforeRunTask task : this.myModel.getItems()) {
            result2.add(task.getProviderId());
        }
        return result2;
    }

    private void getAllRunBeforeRuns(BeforeRunTask task, Set<RunConfiguration> configurationSet) {
        if (task instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask) {
            RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask runTask = (RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)task;
            RunConfiguration configuration = runTask.getSettings().getConfiguration();
            List<BeforeRunTask<?>> tasks = RunManagerImpl.getInstanceImpl(configuration.getProject()).getBeforeRunTasks(configuration);
            for (BeforeRunTask<?> beforeRunTask : tasks) {
                if (!(beforeRunTask instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask) || !configurationSet.add(((RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)beforeRunTask).getSettings().getConfiguration())) continue;
                this.getAllRunBeforeRuns(beforeRunTask, configurationSet);
            }
        }
    }

    private class MyListCellRenderer
    extends JBList.StripedListCellRenderer {
        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
            if (value2 instanceof BeforeRunTask) {
                BeforeRunTask task = (BeforeRunTask)value2;
                BeforeRunTaskProvider provider = BeforeRunTaskProvider.getProvider((Project)BeforeRunStepsPanel.this.myRunConfiguration.getProject(), (Key)task.getProviderId());
                if (provider != null) {
                    Icon icon = provider.getTaskIcon(task);
                    this.setIcon(icon != null ? icon : provider.getIcon());
                    this.setText(provider.getDescription(task));
                }
            }
            return this;
        }
    }

    static interface StepsBeforeRunListener {
        public void fireStepsBeforeRunChanged();

        public void titleChanged(String var1);
    }
}

