/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.google.common.base.CharMatcher;
import com.intellij.codeInsight.navigation.IncrementalSearchHandler;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.execution.ConsoleFolding;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.ConsoleActionsPostProcessor;
import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.CompositeInputFilter;
import com.intellij.execution.filters.ConsoleDependentFilterProvider;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.ConsoleFilterProviderEx;
import com.intellij.execution.filters.ConsoleInputFilterProvider;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.filters.HyperlinkWithPopupMenuInfo;
import com.intellij.execution.filters.InputFilter;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.execution.impl.ConsoleState;
import com.intellij.execution.impl.ConsoleViewRunningState;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.impl.DisposedPsiManagerCheck;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.impl.MyDiffContainer;
import com.intellij.execution.impl.TokenBuffer;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.editor.actions.ToggleUseSoftWrapsToolbarAction;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleViewImpl
extends JPanel
implements ConsoleView,
ObservableConsoleView,
DataProvider,
OccurenceNavigator {
    @NonNls
    private static final String CONSOLE_VIEW_POPUP_MENU = "ConsoleView.PopupMenu";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.ConsoleViewImpl");
    private static final int DEFAULT_FLUSH_DELAY = SystemProperties.getIntProperty((String)"console.flush.delay.ms", (int)200);
    public static final Key<ConsoleViewImpl> CONSOLE_VIEW_IN_EDITOR_VIEW = Key.create((String)"CONSOLE_VIEW_IN_EDITOR_VIEW");
    private static final Key<ConsoleViewContentType> CONTENT_TYPE = Key.create((String)"ConsoleViewContentType");
    private static final Key<Boolean> USER_INPUT_SENT = Key.create((String)"USER_INPUT_SENT");
    private static final Key<Boolean> MANUAL_HYPERLINK = Key.create((String)"MANUAL_HYPERLINK");
    private static boolean ourTypedHandlerInitialized;
    private final Alarm myFlushUserInputAlarm;
    private static final CharMatcher NEW_LINE_MATCHER;
    private final CommandLineFolding myCommandLineFolding;
    private final DisposedPsiManagerCheck myPsiDisposedCheck;
    private final boolean myIsViewer;
    @NotNull
    private ConsoleState myState;
    private final Alarm mySpareTimeAlarm;
    @NotNull
    private final Alarm myHeavyAlarm;
    private volatile int myHeavyUpdateTicket;
    private final Collection<ObservableConsoleView.ChangeListener> myListeners;
    private final List<AnAction> customActions;
    private final TokenBuffer myDeferredBuffer;
    private boolean myUpdateFoldingsEnabled;
    private EditorHyperlinkSupport myHyperlinks;
    private MyDiffContainer myJLayeredPane;
    private JPanel myMainPanel;
    private boolean myAllowHeavyFilters;
    private boolean myLastStickingToEnd;
    private boolean myCancelStickToEnd;
    private final Set<FlushRunnable> myCurrentRequests;
    private final Alarm myFlushAlarm;
    private final Project myProject;
    private boolean myOutputPaused;
    private EditorEx myEditor;
    private final Object LOCK;
    private final TIntObjectHashMap<ConsoleFolding> myFolding;
    private String myHelpId;
    protected final CompositeFilter myFilters;
    @Nullable
    private final InputFilter myInputMessageFilter;
    private boolean keepSlashR;
    private final FlushRunnable FLUSH;
    private final ClearRunnable CLEAR;

    private static synchronized void initTypedHandler() {
        if (ourTypedHandlerInitialized) {
            return;
        }
        TypedAction typedAction = EditorActionManager.getInstance().getTypedAction();
        typedAction.setupHandler((TypedActionHandler)new MyTypedHandler(typedAction.getHandler()));
        ourTypedHandlerInitialized = true;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    public EditorHyperlinkSupport getHyperlinks() {
        return this.myHyperlinks;
    }

    public void scrollToEnd() {
        if (this.myEditor == null) {
            return;
        }
        EditorUtil.scrollToTheEnd(this.myEditor);
        this.myCancelStickToEnd = false;
    }

    public void foldImmediately() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myFlushAlarm.isEmpty()) {
            this.cancelAllFlushRequests();
            this.flushDeferredText();
        }
        FoldingModelEx model = this.myEditor.getFoldingModel();
        model.runBatchFoldingOperation(() -> {
            for (FoldRegion region : model.getAllFoldRegions()) {
                model.removeFoldRegion(region);
            }
        });
        this.myFolding.clear();
        this.updateFoldings(0, this.myEditor.getDocument().getLineCount() - 1);
    }

    public ConsoleViewImpl(@NotNull Project project2, boolean viewer) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/impl/ConsoleViewImpl", "<init>"));
        }
        this(project2, GlobalSearchScope.allScope((Project)project2), viewer, true);
    }

    public ConsoleViewImpl(@NotNull Project project2, @NotNull GlobalSearchScope searchScope, boolean viewer, boolean usePredefinedMessageFilter) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/impl/ConsoleViewImpl", "<init>"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/execution/impl/ConsoleViewImpl", "<init>"));
        }
        this(project2, searchScope, viewer, new ConsoleState.NotStartedStated(){

            @Override
            @NotNull
            public ConsoleState attachTo(@NotNull ConsoleViewImpl console, ProcessHandler processHandler2) {
                if (console == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/impl/ConsoleViewImpl$1", "attachTo"));
                }
                ConsoleViewRunningState consoleViewRunningState = new ConsoleViewRunningState(console, processHandler2, this, true, true);
                if (consoleViewRunningState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewImpl$1", "attachTo"));
                }
                return consoleViewRunningState;
            }
        }, usePredefinedMessageFilter);
    }

    protected ConsoleViewImpl(final @NotNull Project project2, @NotNull GlobalSearchScope searchScope, boolean viewer, @NotNull ConsoleState initialState, boolean usePredefinedMessageFilter) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/impl/ConsoleViewImpl", "<init>"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/execution/impl/ConsoleViewImpl", "<init>"));
        }
        if (initialState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialState", "com/intellij/execution/impl/ConsoleViewImpl", "<init>"));
        }
        super(new BorderLayout());
        this.myFlushUserInputAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myCommandLineFolding = new CommandLineFolding();
        this.mySpareTimeAlarm = new Alarm((Disposable)this);
        this.myHeavyAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myListeners = new CopyOnWriteArraySet<ObservableConsoleView.ChangeListener>();
        this.customActions = new ArrayList<AnAction>();
        this.myDeferredBuffer = new TokenBuffer(ConsoleBuffer.useCycleBuffer() ? ConsoleBuffer.getCycleBufferSize() : Integer.MAX_VALUE);
        this.myUpdateFoldingsEnabled = true;
        this.myCurrentRequests = new THashSet();
        this.myFlushAlarm = new Alarm((Disposable)this);
        this.LOCK = new Object();
        this.myFolding = new TIntObjectHashMap();
        this.keepSlashR = true;
        this.FLUSH = new FlushRunnable();
        this.CLEAR = new ClearRunnable();
        ConsoleViewImpl.initTypedHandler();
        this.myIsViewer = viewer;
        this.myState = initialState;
        this.myPsiDisposedCheck = new DisposedPsiManagerCheck(project2);
        this.myProject = project2;
        this.myFilters = new CompositeFilter(project2, (List)(usePredefinedMessageFilter ? this.computeConsoleFilters(project2, searchScope) : new SmartList()));
        this.myFilters.setForceUseAllFilters(true);
        ConsoleInputFilterProvider[] inputFilters = (ConsoleInputFilterProvider[])Extensions.getExtensions((ExtensionPointName)ConsoleInputFilterProvider.INPUT_FILTER_PROVIDERS);
        if (inputFilters.length > 0) {
            CompositeInputFilter compositeInputFilter = new CompositeInputFilter(project2);
            this.myInputMessageFilter = compositeInputFilter;
            for (ConsoleInputFilterProvider eachProvider : inputFilters) {
                InputFilter[] filters;
                for (InputFilter filter : filters = eachProvider.getDefaultFilters(project2)) {
                    compositeInputFilter.addFilter(filter);
                }
            }
        } else {
            this.myInputMessageFilter = null;
        }
        project2.getMessageBus().connect((Disposable)this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){
            private long myLastStamp;

            public void enteredDumbMode() {
                if (ConsoleViewImpl.this.myEditor == null) {
                    return;
                }
                this.myLastStamp = ConsoleViewImpl.this.myEditor.getDocument().getModificationStamp();
            }

            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/impl/ConsoleViewImpl$2", "lambda$exitDumbMode$0"));
                    }
                    if (ConsoleViewImpl.this.myEditor == null || project2.isDisposed() || DumbService.getInstance((Project)project2).isDumb()) {
                        return;
                    }
                    DocumentEx document = ConsoleViewImpl.this.myEditor.getDocument();
                    if (this.myLastStamp != document.getModificationStamp()) {
                        ConsoleViewImpl.this.rehighlightHyperlinksAndFoldings();
                    }
                });
            }
        });
    }

    @NotNull
    private List<Filter> computeConsoleFilters(@NotNull Project project2, @NotNull GlobalSearchScope searchScope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/impl/ConsoleViewImpl", "computeConsoleFilters"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/execution/impl/ConsoleViewImpl", "computeConsoleFilters"));
        }
        ArrayList<Filter> result2 = new ArrayList<Filter>();
        for (ConsoleFilterProvider eachProvider : (ConsoleFilterProvider[])ConsoleFilterProvider.FILTER_PROVIDERS.getExtensions()) {
            Object[] filters = eachProvider instanceof ConsoleDependentFilterProvider ? ((ConsoleDependentFilterProvider)eachProvider).getDefaultFilters((ConsoleView)this, project2, searchScope) : (eachProvider instanceof ConsoleFilterProviderEx ? ((ConsoleFilterProviderEx)eachProvider).getDefaultFilters(project2, searchScope) : eachProvider.getDefaultFilters(project2));
            ContainerUtil.addAll(result2, (Object[])filters);
        }
        ArrayList<Filter> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewImpl", "computeConsoleFilters"));
        }
        return arrayList;
    }

    public void attachToProcess(ProcessHandler processHandler2) {
        this.myState = this.myState.attachTo(this, processHandler2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.myEditor == null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myDeferredBuffer.clear();
            this.myFolding.clear();
        }
        if (!this.myFlushAlarm.isDisposed()) {
            this.cancelAllFlushRequests();
            this.addFlushRequest(this.CLEAR, 0);
            this.cancelHeavyAlarm();
        }
    }

    public void scrollTo(final int offset) {
        if (this.myEditor == null) {
            return;
        }
        class ScrollRunnable
        extends FlushRunnable {
            private final int myOffset;

            ScrollRunnable() {
                this.myOffset = offset;
            }

            @Override
            public void doRun() {
                ConsoleViewImpl.this.flushDeferredText();
                if (ConsoleViewImpl.this.myEditor == null) {
                    return;
                }
                int moveOffset = Math.min(offset, ConsoleViewImpl.this.myEditor.getDocument().getTextLength());
                if (ConsoleBuffer.useCycleBuffer() && moveOffset >= ConsoleViewImpl.this.myEditor.getDocument().getTextLength()) {
                    moveOffset = 0;
                }
                ConsoleViewImpl.this.myEditor.getCaretModel().moveToOffset(moveOffset);
                ConsoleViewImpl.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }

            @Override
            public boolean equals(Object o) {
                return super.equals(o) && this.myOffset == ((ScrollRunnable)o).myOffset;
            }
        }
        this.addFlushRequest(new ScrollRunnable(), 0);
    }

    public void requestScrollingToEnd() {
        if (this.myEditor == null) {
            return;
        }
        this.addFlushRequest(new FlushRunnable(){

            @Override
            public void doRun() {
                ConsoleViewImpl.this.flushDeferredText();
                if (ConsoleViewImpl.this.myEditor != null && !ConsoleViewImpl.this.myFlushAlarm.isDisposed()) {
                    ConsoleViewImpl.this.scrollToEnd();
                }
            }
        }, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFlushRequest(@NotNull FlushRunnable flushRunnable, int millis) {
        if (flushRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flushRunnable", "com/intellij/execution/impl/ConsoleViewImpl", "addFlushRequest"));
        }
        Set<FlushRunnable> set2 = this.myCurrentRequests;
        synchronized (set2) {
            if (!this.myFlushAlarm.isDisposed() && this.myCurrentRequests.add(flushRunnable)) {
                this.myFlushAlarm.addRequest((Runnable)flushRunnable, millis, ConsoleViewImpl.getStateForUpdate());
            }
        }
    }

    public void setOutputPaused(boolean value2) {
        this.myOutputPaused = value2;
        if (!value2) {
            this.requestFlushImmediately();
        }
    }

    public boolean isOutputPaused() {
        return this.myOutputPaused;
    }

    public void setEmulateCarriageReturn(boolean emulate) {
        this.keepSlashR = emulate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDeferredOutput() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myDeferredBuffer.length() > 0;
        }
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/execution/impl/ConsoleViewImpl", "performWhenNoDeferredOutput"));
        }
        if (this.hasDeferredOutput()) {
            this.performLaterWhenNoDeferredOutput(runnable2);
        } else {
            runnable2.run();
        }
    }

    private void performLaterWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/execution/impl/ConsoleViewImpl", "performLaterWhenNoDeferredOutput"));
        }
        if (this.mySpareTimeAlarm.isDisposed()) {
            return;
        }
        this.mySpareTimeAlarm.addRequest(() -> {
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/execution/impl/ConsoleViewImpl", "lambda$performLaterWhenNoDeferredOutput$1"));
            }
            this.performWhenNoDeferredOutput(runnable2);
        }, 100, ModalityState.stateForComponent((Component)((Object)this.myJLayeredPane)));
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myMainPanel == null) {
            this.myMainPanel = new JPanel(new BorderLayout());
            this.myJLayeredPane = new MyDiffContainer(this.myMainPanel, this.myFilters.getUpdateMessage());
            Disposer.register((Disposable)this, (Disposable)this.myJLayeredPane);
            this.add((Component)((Object)this.myJLayeredPane), "Center");
        }
        if (this.myEditor == null) {
            this.initConsoleEditor();
            this.requestFlushImmediately();
            this.myMainPanel.add((Component)this.createCenterComponent(), "Center");
        }
        ConsoleViewImpl consoleViewImpl = this;
        if (consoleViewImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewImpl", "getComponent"));
        }
        return consoleViewImpl;
    }

    public final void addLayerToPane(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/execution/impl/ConsoleViewImpl", "addLayerToPane"));
        }
        this.getComponent();
        component.setOpaque(false);
        component.setVisible(true);
        this.myJLayeredPane.add(component, 0);
    }

    private void initConsoleEditor() {
        this.myEditor = this.createConsoleEditor();
        this.registerConsoleEditorActions();
        this.myEditor.getScrollPane().setBorder(null);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ConsoleViewImpl.this.updateStickToEndState(true);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ConsoleViewImpl.this.updateStickToEndState(false);
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ConsoleViewImpl.this.updateStickToEndState(false);
            }
        };
        this.myEditor.getScrollPane().addMouseWheelListener(mouseListener);
        this.myEditor.getScrollPane().getVerticalScrollBar().addMouseListener(mouseListener);
        this.myEditor.getScrollPane().getVerticalScrollBar().addMouseMotionListener(mouseListener);
        this.myHyperlinks = new EditorHyperlinkSupport(this.myEditor, this.myProject);
        this.myEditor.getScrollingModel().addVisibleAreaListener(e -> {
            Rectangle oldR = e.getOldRectangle();
            if (oldR != null && oldR.height <= 0 && e.getNewRectangle().height > 0 && this.isStickingToEnd()) {
                this.scrollToEnd();
            }
        });
    }

    private void updateStickToEndState(boolean useImmediatePosition) {
        if (this.myEditor == null) {
            return;
        }
        JScrollBar scrollBar = this.myEditor.getScrollPane().getVerticalScrollBar();
        int scrollBarPosition = useImmediatePosition ? scrollBar.getValue() : this.myEditor.getScrollingModel().getVisibleAreaOnScrollingFinished().y;
        boolean vscrollAtBottom = scrollBarPosition == scrollBar.getMaximum() - scrollBar.getVisibleAmount();
        boolean stickingToEnd = this.isStickingToEnd();
        if (!vscrollAtBottom && stickingToEnd) {
            this.myCancelStickToEnd = true;
        } else if (vscrollAtBottom && !stickingToEnd) {
            this.scrollToEnd();
        }
    }

    @NotNull
    protected JComponent createCenterComponent() {
        JComponent jComponent = this.myEditor.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewImpl", "createCenterComponent"));
        }
        return jComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.myState = this.myState.dispose();
        if (this.myEditor != null) {
            this.cancelAllFlushRequests();
            this.mySpareTimeAlarm.cancelAllRequests();
            this.disposeEditor();
            Object object = this.LOCK;
            synchronized (object) {
                this.myDeferredBuffer.clear();
            }
            this.myEditor = null;
            this.myHyperlinks = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllFlushRequests() {
        Set<FlushRunnable> set2 = this.myCurrentRequests;
        synchronized (set2) {
            this.myCurrentRequests.clear();
            this.myFlushAlarm.cancelAllRequests();
        }
    }

    public void waitAllRequests() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            while (true) {
                try {
                    this.myFlushAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
                    this.myFlushUserInputAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
                    this.myFlushAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
                    this.myFlushUserInputAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
                    return;
                }
                catch (CancellationException cancellationException) {
                    continue;
                }
                break;
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        });
        try {
            while (true) {
                try {
                    future2.get(10L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    UIUtil.dispatchAllInvocationEvents();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected void disposeEditor() {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (!this.myEditor.isDisposed()) {
                EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
            }
        });
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/impl/ConsoleViewImpl", "print"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/execution/impl/ConsoleViewImpl", "print"));
        }
        if (this.myInputMessageFilter == null) {
            this.print(text2, contentType, null);
            return;
        }
        List result2 = this.myInputMessageFilter.applyFilter(text2, contentType);
        if (result2 == null) {
            this.print(text2, contentType, null);
        } else {
            for (Pair pair2 : result2) {
                if (pair2.first == null) continue;
                this.print((String)pair2.first, pair2.second == null ? contentType : (ConsoleViewContentType)pair2.second, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType, @Nullable HyperlinkInfo info) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/impl/ConsoleViewImpl", "print"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/execution/impl/ConsoleViewImpl", "print"));
        }
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            char c = text2.charAt(i2);
            if (c != '\n' && c != '\r') continue;
            text2 = StringUtil.convertLineSeparators((String)text2, (boolean)this.keepSlashR);
            break;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myDeferredBuffer.print(text2, contentType, info);
            if (contentType == ConsoleViewContentType.USER_INPUT) {
                this.requestFlushImmediately();
            } else if (this.myEditor != null) {
                boolean shouldFlushNow = this.myDeferredBuffer.length() >= this.myDeferredBuffer.getCycleBufferSize();
                this.addFlushRequest(this.FLUSH, shouldFlushNow ? 0 : DEFAULT_FLUSH_DELAY);
            }
        }
    }

    private void sendUserInput(@NotNull CharSequence typedText) {
        if (typedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typedText", "com/intellij/execution/impl/ConsoleViewImpl", "sendUserInput"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myState.isRunning() && NEW_LINE_MATCHER.indexIn(typedText) >= 0) {
            StringBuilder textToSend = new StringBuilder();
            RangeMarker marker = this.findTokenMarker(this.myEditor.getCaretModel().getOffset() - 1);
            while (marker != null) {
                ConsoleViewContentType tokenType = ConsoleViewImpl.getTokenType(marker);
                if (tokenType != null) {
                    if (tokenType != ConsoleViewContentType.USER_INPUT || marker.getUserData(USER_INPUT_SENT) == Boolean.TRUE) break;
                    marker.putUserData(USER_INPUT_SENT, (Object)true);
                    textToSend.insert(0, marker.getDocument().getText(TextRange.create((Segment)marker)));
                }
                marker = ((RangeMarkerImpl)marker).findRangeMarkerBefore();
            }
            if (textToSend.length() != 0) {
                this.myFlushUserInputAlarm.addRequest(() -> {
                    if (this.myState.isRunning()) {
                        try {
                            this.myState.sendUserInput(textToSend.toString());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }, 0);
            }
        }
    }

    private static ModalityState getStateForUpdate() {
        return null;
    }

    private void requestFlushImmediately() {
        if (this.myEditor != null) {
            this.addFlushRequest(this.FLUSH, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getContentSize() {
        Object object = this.LOCK;
        synchronized (object) {
            return (this.myEditor == null ? 0 : this.myEditor.getDocument().getTextLength()) + this.myDeferredBuffer.length();
        }
    }

    public boolean canPause() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDeferredText() {
        List<TokenBuffer.TokenInfo> deferredTokens;
        StringBuilder addedText;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        boolean shouldStickToEnd = !this.myCancelStickToEnd && this.isStickingToEnd();
        this.myCancelStickToEnd = false;
        DocumentEx document = this.myEditor.getDocument();
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myOutputPaused) {
                return;
            }
            addedText = new StringBuilder(this.myDeferredBuffer.length());
            deferredTokens = this.myDeferredBuffer.drain();
            if (deferredTokens.isEmpty()) {
                return;
            }
            this.cancelHeavyAlarm();
        }
        RangeMarker lastProcessedOutput = document.createRangeMarker(document.getTextLength(), document.getTextLength());
        HashSet contentTypes = new HashSet();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            if (!shouldStickToEnd) {
                this.myEditor.getScrollingModel().accumulateViewportChanges();
            }
            try {
                int startIndex;
                boolean startsWithCR = deferredTokens.get(0) == TokenBuffer.CR_TOKEN;
                for (int i2 = startIndex = startsWithCR ? 1 : 0; i2 < deferredTokens.size(); ++i2) {
                    TokenBuffer.TokenInfo deferredToken = (TokenBuffer.TokenInfo)deferredTokens.get(i2);
                    addedText.append(deferredToken.getText());
                }
                if (startsWithCR && document.getLineCount() != 0) {
                    int lineStartOffset = document.getLineStartOffset(document.getLineCount() - 1);
                    document.deleteString(lineStartOffset, document.getTextLength());
                }
                document.insertString(document.getTextLength(), addedText);
                int offset = document.getTextLength();
                int tokenLength = 0;
                for (int i3 = deferredTokens.size() - 1; i3 >= startIndex; --i3) {
                    TokenBuffer.TokenInfo prevToken;
                    TokenBuffer.TokenInfo token = (TokenBuffer.TokenInfo)deferredTokens.get(i3);
                    contentTypes.add(token.contentType);
                    tokenLength += token.length();
                    TokenBuffer.TokenInfo tokenInfo = prevToken = i3 == startIndex ? null : (TokenBuffer.TokenInfo)deferredTokens.get(i3 - 1);
                    if (prevToken != null && token.contentType == prevToken.contentType && token.getHyperlinkInfo() == prevToken.getHyperlinkInfo()) continue;
                    int start = Math.max(0, offset - tokenLength);
                    if (start == offset) {
                        break;
                    }
                    HyperlinkInfo info = token.getHyperlinkInfo();
                    if (info != null) {
                        this.myHyperlinks.createHyperlink(start, offset, null, info).putUserData(MANUAL_HYPERLINK, (Object)true);
                    }
                    this.createTokenRangeHighlighter(token.contentType, start, offset);
                    offset = start;
                    tokenLength = 0;
                }
            }
            finally {
                if (!shouldStickToEnd) {
                    this.myEditor.getScrollingModel().flushViewportChanges();
                }
            }
        }, null, (Object)DocCommandGroupId.noneGroupId((Document)document));
        if (!contentTypes.isEmpty()) {
            for (ObservableConsoleView.ChangeListener each : this.myListeners) {
                each.contentAdded(contentTypes);
            }
        }
        this.myPsiDisposedCheck.performCheck();
        int startLine = lastProcessedOutput.isValid() ? this.myEditor.getDocument().getLineNumber(lastProcessedOutput.getEndOffset()) : 0;
        lastProcessedOutput.dispose();
        this.highlightHyperlinksAndFoldings(startLine);
        if (shouldStickToEnd) {
            this.scrollToEnd();
        }
        this.sendUserInput(addedText);
    }

    private void createTokenRangeHighlighter(@NotNull ConsoleViewContentType contentType, int startOffset, int endOffset) {
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/execution/impl/ConsoleViewImpl", "createTokenRangeHighlighter"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        TextAttributes attributes = contentType.getAttributes();
        MarkupModel model = DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.getProject(), true);
        int layer = 1001;
        RangeHighlighter tokenMarker = model.addRangeHighlighter(startOffset, endOffset, layer, attributes, HighlighterTargetArea.EXACT_RANGE);
        tokenMarker.putUserData(CONTENT_TYPE, (Object)contentType);
    }

    boolean isDisposed() {
        return this.myProject.isDisposed() || this.myEditor == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClear() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        DocumentEx document = this.myEditor.getDocument();
        Object object = this.LOCK;
        synchronized (object) {
            this.clearHyperlinkAndFoldings();
        }
        int documentTextLength = document.getTextLength();
        if (documentTextLength > 0) {
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> DocumentUtil.executeInBulk(document, true, () -> document.deleteString(0, documentTextLength)), null, (Object)DocCommandGroupId.noneGroupId((Document)document));
        }
        MarkupModel model = DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.getProject(), true);
        model.removeAllHighlighters();
    }

    private boolean isStickingToEnd() {
        int caretOffset;
        if (this.myEditor == null) {
            return this.myLastStickingToEnd;
        }
        DocumentEx document = this.myEditor.getDocument();
        this.myLastStickingToEnd = document.getLineNumber(caretOffset = this.myEditor.getCaretModel().getOffset()) >= document.getLineCount() - 1;
        return this.myLastStickingToEnd;
    }

    private void clearHyperlinkAndFoldings() {
        for (RangeHighlighter highlighter : this.myEditor.getMarkupModel().getAllHighlighters()) {
            if (highlighter.getUserData(MANUAL_HYPERLINK) != null) continue;
            this.myEditor.getMarkupModel().removeHighlighter(highlighter);
        }
        this.myFolding.clear();
        this.myEditor.getFoldingModel().runBatchFoldingOperation(() -> this.myEditor.getFoldingModel().clearFoldRegions());
        this.cancelHeavyAlarm();
    }

    private void cancelHeavyAlarm() {
        if (!this.myHeavyAlarm.isDisposed()) {
            this.myHeavyAlarm.cancelAllRequests();
            ++this.myHeavyUpdateTicket;
        }
    }

    public Object getData(String dataId) {
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            OpenFileDescriptor openFileDescriptor;
            if (this.myEditor == null) {
                return null;
            }
            LogicalPosition pos = this.myEditor.getCaretModel().getLogicalPosition();
            HyperlinkInfo info = this.myHyperlinks.getHyperlinkInfoByLineAndCol(pos.line, pos.column);
            OpenFileDescriptor openFileDescriptor2 = openFileDescriptor = info instanceof FileHyperlinkInfo ? ((FileHyperlinkInfo)info).getDescriptor() : null;
            if (openFileDescriptor == null || !openFileDescriptor.getFile().isValid()) {
                return null;
            }
            return openFileDescriptor;
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return this.myEditor;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
            return this;
        }
        return null;
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpId", "com/intellij/execution/impl/ConsoleViewImpl", "setHelpId"));
        }
        this.myHelpId = helpId;
    }

    public void setUpdateFoldingsEnabled(boolean updateFoldingsEnabled) {
        this.myUpdateFoldingsEnabled = updateFoldingsEnabled;
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/execution/impl/ConsoleViewImpl", "addMessageFilter"));
        }
        this.myFilters.addFilter(filter);
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinkText", "com/intellij/execution/impl/ConsoleViewImpl", "printHyperlink"));
        }
        this.print(hyperlinkText, ConsoleViewContentType.NORMAL_OUTPUT, info);
    }

    @NotNull
    private EditorEx createConsoleEditor() {
        EditorEx editorEx = (EditorEx)ReadAction.compute(() -> {
            EditorEx editor = this.doCreateConsoleEditor();
            LOG.assertTrue(UndoUtil.isUndoDisabledFor((Document)editor.getDocument()));
            editor.setContextMenuGroupId(null);
            editor.addEditorMouseListener((EditorMouseListener)new EditorPopupHandler(){

                @Override
                public void invokePopup(EditorMouseEvent event) {
                    ConsoleViewImpl.this.popupInvoked(event.getMouseEvent());
                }
            });
            int bufferSize = ConsoleBuffer.useCycleBuffer() ? ConsoleBuffer.getCycleBufferSize() : 0;
            editor.getDocument().setCyclicBufferSize(bufferSize);
            editor.putUserData(CONSOLE_VIEW_IN_EDITOR_VIEW, this);
            editor.getSettings().setAllowSingleLogicalLineFolding(true);
            return editor;
        });
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewImpl", "createConsoleEditor"));
        }
        return editorEx;
    }

    @NotNull
    protected EditorEx doCreateConsoleEditor() {
        EditorEx editorEx = ConsoleViewUtil.setupConsoleEditor(this.myProject, true, false);
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewImpl", "doCreateConsoleEditor"));
        }
        return editorEx;
    }

    private void registerConsoleEditorActions() {
        Object[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"GotoDeclaration").getShortcuts();
        CustomShortcutSet shortcutSet = new CustomShortcutSet((Shortcut[])ArrayUtil.mergeArrays((Object[])shortcuts, (Object[])CommonShortcuts.ENTER.getShortcuts()));
        new HyperlinkNavigationAction().registerCustomShortcutSet((ShortcutSet)shortcutSet, this.myEditor.getContentComponent());
        if (!this.myIsViewer) {
            new EnterHandler().registerCustomShortcutSet(CommonShortcuts.ENTER, this.myEditor.getContentComponent());
            ConsoleViewImpl.registerActionHandler(this.myEditor, "EditorPaste", new PasteHandler());
            ConsoleViewImpl.registerActionHandler(this.myEditor, "EditorBackSpace", new BackSpaceHandler());
            ConsoleViewImpl.registerActionHandler(this.myEditor, "EditorDelete", new DeleteHandler());
            ConsoleViewImpl.registerActionHandler(this.myEditor, "SendEOF");
        }
    }

    private static void registerActionHandler(@NotNull Editor editor, @NotNull String actionId) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/impl/ConsoleViewImpl", "registerActionHandler"));
        }
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/execution/impl/ConsoleViewImpl", "registerActionHandler"));
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        action.registerCustomShortcutSet(action.getShortcutSet(), editor.getContentComponent());
    }

    private static void registerActionHandler(@NotNull Editor editor, @NotNull String actionId, @NotNull AnAction action) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/impl/ConsoleViewImpl", "registerActionHandler"));
        }
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/execution/impl/ConsoleViewImpl", "registerActionHandler"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/execution/impl/ConsoleViewImpl", "registerActionHandler"));
        }
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = keymap.getShortcuts(actionId);
        action.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), editor.getContentComponent());
    }

    private void popupInvoked(@NotNull MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mouseEvent", "com/intellij/execution/impl/ConsoleViewImpl", "popupInvoked"));
        }
        ActionManager actionManager = ActionManager.getInstance();
        HyperlinkInfo info = this.myHyperlinks != null ? this.myHyperlinks.getHyperlinkInfoByPoint(mouseEvent.getPoint()) : null;
        ActionGroup group = null;
        if (info instanceof HyperlinkWithPopupMenuInfo) {
            group = ((HyperlinkWithPopupMenuInfo)info).getPopupMenuGroup(mouseEvent);
        }
        if (group == null) {
            group = (ActionGroup)actionManager.getAction(CONSOLE_VIEW_POPUP_MENU);
        }
        ConsoleActionsPostProcessor[] postProcessors = (ConsoleActionsPostProcessor[])Extensions.getExtensions((ExtensionPointName)ConsoleActionsPostProcessor.EP_NAME);
        AnAction[] result2 = group.getChildren(null);
        for (ConsoleActionsPostProcessor postProcessor : postProcessors) {
            result2 = postProcessor.postProcessPopupActions((ConsoleView)this, result2);
        }
        DefaultActionGroup processedGroup = new DefaultActionGroup(result2);
        ActionPopupMenu menu = actionManager.createActionPopupMenu("EditorPopup", (ActionGroup)processedGroup);
        menu.getComponent().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void highlightHyperlinksAndFoldings(int startLine) {
        boolean canHighlightHyperlinks;
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean bl = canHighlightHyperlinks = !this.myFilters.isEmpty();
        if (!canHighlightHyperlinks && this.myUpdateFoldingsEnabled) {
            return;
        }
        DocumentEx document = this.myEditor.getDocument();
        if (document.getTextLength() == 0) {
            return;
        }
        int endLine = Math.max(0, document.getLineCount() - 1);
        if (canHighlightHyperlinks) {
            this.myHyperlinks.highlightHyperlinks((Filter)this.myFilters, startLine, endLine);
        }
        if (this.myAllowHeavyFilters && this.myFilters.isAnyHeavy() && this.myFilters.shouldRunHeavy()) {
            this.runHeavyFilters(startLine, endLine);
        }
        if (this.myUpdateFoldingsEnabled) {
            this.updateFoldings(startLine, endLine);
        }
    }

    public void rehighlightHyperlinksAndFoldings() {
        if (this.myEditor == null || this.myProject.isDisposed()) {
            return;
        }
        this.clearHyperlinkAndFoldings();
        this.highlightHyperlinksAndFoldings(0);
    }

    private void runHeavyFilters(int line1, int endLine) {
        int startLine = Math.max(0, line1);
        DocumentEx document = this.myEditor.getDocument();
        int startOffset = document.getLineStartOffset(startLine);
        String text2 = document.getText(new TextRange(startOffset, document.getLineEndOffset(endLine)));
        DocumentImpl documentCopy = new DocumentImpl(text2, true);
        documentCopy.setReadOnly(true);
        this.myJLayeredPane.startUpdating();
        final int currentValue = this.myHeavyUpdateTicket;
        this.myHeavyAlarm.addRequest(() -> {
            if (!this.myFilters.shouldRunHeavy()) {
                return;
            }
            try {
                this.myFilters.applyHeavyFilter(documentCopy, startOffset, startLine, additionalHighlight -> this.addFlushRequest(new FlushRunnable((FilterMixin.AdditionalHighlight)additionalHighlight){
                    final /* synthetic */ FilterMixin.AdditionalHighlight val$additionalHighlight;
                    {
                        this.val$additionalHighlight = additionalHighlight;
                    }

                    @Override
                    public void doRun() {
                        if (ConsoleViewImpl.this.myHeavyUpdateTicket != currentValue) {
                            return;
                        }
                        TextAttributes additionalAttributes = this.val$additionalHighlight.getTextAttributes(null);
                        if (additionalAttributes != null) {
                            Filter.ResultItem item = (Filter.ResultItem)this.val$additionalHighlight.getResultItems().get(0);
                            ConsoleViewImpl.this.myHyperlinks.addHighlighter(item.getHighlightStartOffset(), item.getHighlightEndOffset(), additionalAttributes);
                        } else {
                            ConsoleViewImpl.this.myHyperlinks.highlightHyperlinks((Filter.Result)this.val$additionalHighlight, 0);
                        }
                    }

                    @Override
                    public boolean equals(Object o) {
                        return this == o;
                    }
                }, 0));
            }
            finally {
                if (this.myHeavyAlarm.getActiveRequestCount() <= 1) {
                    UIUtil.invokeLaterIfNeeded(() -> this.myJLayeredPane.finishUpdating());
                }
            }
        }, 0);
    }

    private void updateFoldings(int line1, int endLine) {
        DocumentEx document = this.myEditor.getDocument();
        CharSequence chars = document.getCharsSequence();
        int startLine = Math.max(0, line1);
        ArrayList<FoldRegion> toAdd = new ArrayList<FoldRegion>();
        for (int line = startLine; line <= endLine; ++line) {
            boolean flushOnly = line == endLine;
            this.addFolding(document, chars, line, toAdd, flushOnly);
        }
        if (!toAdd.isEmpty()) {
            this.doUpdateFolding(toAdd);
        }
    }

    private void doUpdateFolding(@NotNull List<FoldRegion> toAdd) {
        if (toAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toAdd", "com/intellij/execution/impl/ConsoleViewImpl", "doUpdateFolding"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myEditor == null || this.myEditor.isDisposed()) {
            return;
        }
        FoldingModelEx model = this.myEditor.getFoldingModel();
        model.runBatchFoldingOperation(() -> {
            if (toAdd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toAdd", "com/intellij/execution/impl/ConsoleViewImpl", "lambda$doUpdateFolding$14"));
            }
            for (FoldRegion region : toAdd) {
                region.setExpanded(false);
                model.addFoldRegion(region);
            }
        });
    }

    private void addFolding(@NotNull Document document, @NotNull CharSequence chars, int line, @NotNull List<FoldRegion> toAdd, boolean flushOnly) {
        ConsoleFolding prevFolding;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/execution/impl/ConsoleViewImpl", "addFolding"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/execution/impl/ConsoleViewImpl", "addFolding"));
        }
        if (toAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toAdd", "com/intellij/execution/impl/ConsoleViewImpl", "addFolding"));
        }
        ConsoleFolding current = null;
        if (!flushOnly) {
            String commandLinePlaceholder = this.myCommandLineFolding.getPlaceholder(line);
            if (commandLinePlaceholder != null) {
                FoldRegion region = this.myEditor.getFoldingModel().createFoldRegion(document.getLineStartOffset(line), document.getLineEndOffset(line), commandLinePlaceholder, null, false);
                ContainerUtil.addIfNotNull(toAdd, (Object)region);
                return;
            }
            String lineText = EditorHyperlinkSupport.getLineText(document, line, false);
            current = ConsoleViewImpl.foldingForLine(lineText);
            if (current != null) {
                this.myFolding.put(line, (Object)current);
            }
        }
        if ((prevFolding = (ConsoleFolding)this.myFolding.get(line - 1)) != null && !prevFolding.equals(current)) {
            int lEnd;
            int lStart = lEnd = line - 1;
            while (prevFolding.equals(this.myFolding.get(lStart - 1))) {
                --lStart;
            }
            for (int i2 = lStart; i2 <= lEnd; ++i2) {
                this.myFolding.remove(i2);
            }
            ArrayList<String> toFold = new ArrayList<String>(lEnd - lStart + 1);
            for (int i3 = lStart; i3 <= lEnd; ++i3) {
                toFold.add(EditorHyperlinkSupport.getLineText(document, i3, false));
            }
            int oStart = document.getLineStartOffset(lStart);
            if (oStart > 0) {
                --oStart;
            }
            int oEnd = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(document.getLineEndOffset(lEnd) - 1), (String)" \t") + 1;
            String placeholder = prevFolding.getPlaceholderText(toFold);
            FoldRegion region = placeholder == null ? null : this.myEditor.getFoldingModel().createFoldRegion(oStart, oEnd, placeholder, null, false);
            ContainerUtil.addIfNotNull(toAdd, region);
        }
    }

    @Nullable
    private static ConsoleFolding foldingForLine(@NotNull String lineText) {
        ConsoleFolding[] foldings;
        if (lineText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineText", "com/intellij/execution/impl/ConsoleViewImpl", "foldingForLine"));
        }
        for (ConsoleFolding folding : foldings = (ConsoleFolding[])ConsoleFolding.EP_NAME.getExtensions()) {
            if (!folding.shouldFoldLine(lineText)) continue;
            return folding;
        }
        return null;
    }

    private RangeMarker findTokenMarker(int offset) {
        RangeMarker[] marker = new RangeMarker[1];
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.getProject(), true);
        model.processRangeHighlightersOverlappingWith(offset, offset, (Processor<? super RangeHighlighterEx>)((Processor)m -> {
            if (ConsoleViewImpl.getTokenType(m) == null || m.getStartOffset() > offset || offset + 1 > m.getEndOffset()) {
                return true;
            }
            marker[0] = m;
            return false;
        }));
        return marker[0];
    }

    private static ConsoleViewContentType getTokenType(@Nullable RangeMarker m) {
        return m == null ? null : (ConsoleViewContentType)m.getUserData(CONTENT_TYPE);
    }

    private void type(@NotNull Editor editor, @NotNull String text2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/impl/ConsoleViewImpl", "type"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/impl/ConsoleViewImpl", "type"));
        }
        this.flushDeferredText();
        SelectionModel selectionModel = editor.getSelectionModel();
        int lastOffset = selectionModel.hasSelection() ? selectionModel.getSelectionStart() : editor.getCaretModel().getOffset() - 1;
        RangeMarker marker = this.findTokenMarker(lastOffset);
        if (ConsoleViewImpl.getTokenType(marker) != ConsoleViewContentType.USER_INPUT) {
            this.print(text2, ConsoleViewContentType.USER_INPUT);
            ConsoleViewImpl.moveScrollRemoveSelection(editor, editor.getDocument().getTextLength());
            return;
        }
        String textToUse = StringUtil.convertLineSeparators((String)text2);
        if (selectionModel.hasSelection()) {
            this.replaceUserText(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd(), textToUse);
        } else {
            int typeOffset = selectionModel.hasSelection() ? selectionModel.getSelectionStart() : editor.getCaretModel().getOffset();
            this.insertUserText(typeOffset, textToUse);
        }
    }

    public JComponent getPreferredFocusableComponent() {
        this.getComponent();
        return this.myEditor.getContentComponent();
    }

    public boolean hasNextOccurence() {
        return this.calcNextOccurrence(1) != null;
    }

    public boolean hasPreviousOccurence() {
        return this.calcNextOccurrence(-1) != null;
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.calcNextOccurrence(1);
    }

    @Nullable
    protected OccurenceNavigator.OccurenceInfo calcNextOccurrence(int delta) {
        if (this.myHyperlinks == null) {
            return null;
        }
        return EditorHyperlinkSupport.getNextOccurrence(this.myEditor, delta, (Consumer<RangeHighlighter>)((Consumer)next -> {
            int offset = next.getStartOffset();
            this.scrollTo(offset);
            HyperlinkInfo hyperlinkInfo = EditorHyperlinkSupport.getHyperlinkInfo(next);
            if (hyperlinkInfo instanceof BrowserHyperlinkInfo) {
                return;
            }
            if (hyperlinkInfo instanceof HyperlinkInfoBase) {
                VisualPosition position = this.myEditor.offsetToVisualPosition(offset);
                Point point = this.myEditor.visualPositionToXY(new VisualPosition(position.getLine() + 1, position.getColumn()));
                ((HyperlinkInfoBase)hyperlinkInfo).navigate(this.myProject, new RelativePoint((Component)this.myEditor.getContentComponent(), point));
            } else if (hyperlinkInfo != null) {
                hyperlinkInfo.navigate(this.myProject);
            }
        }));
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.calcNextOccurrence(-1);
    }

    public String getNextOccurenceActionName() {
        return ExecutionBundle.message((String)"down.the.stack.trace", (Object[])new Object[0]);
    }

    public String getPreviousOccurenceActionName() {
        return ExecutionBundle.message((String)"up.the.stack.trace", (Object[])new Object[0]);
    }

    public void addCustomConsoleAction(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/execution/impl/ConsoleViewImpl", "addCustomConsoleAction"));
        }
        this.customActions.add(action);
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        AnAction prevAction = actionsManager.createPrevOccurenceAction((OccurenceNavigator)this);
        prevAction.getTemplatePresentation().setText(this.getPreviousOccurenceActionName());
        AnAction nextAction = actionsManager.createNextOccurenceAction((OccurenceNavigator)this);
        nextAction.getTemplatePresentation().setText(this.getNextOccurenceActionName());
        ToggleUseSoftWrapsToolbarAction switchSoftWrapsAction = new ToggleUseSoftWrapsToolbarAction(SoftWrapAppliancePlaces.CONSOLE){

            @Override
            protected Editor getEditor(AnActionEvent e) {
                return ConsoleViewImpl.this.myEditor;
            }

            @Override
            public void setSelected(AnActionEvent e, boolean state) {
                super.setSelected(e, state);
                if (ConsoleViewImpl.this.myEditor == null) {
                    return;
                }
                String placeholder = ConsoleViewImpl.this.myCommandLineFolding.getPlaceholder(0);
                FoldingModelEx foldingModel = ConsoleViewImpl.this.myEditor.getFoldingModel();
                int firstLineEnd = ConsoleViewImpl.this.myEditor.getDocument().getLineEndOffset(0);
                foldingModel.runBatchFoldingOperation(() -> {
                    FoldRegion foldRegion;
                    FoldRegion[] regions = foldingModel.getAllFoldRegions();
                    if (regions.length > 0 && regions[0].getStartOffset() == 0 && regions[0].getEndOffset() == firstLineEnd) {
                        foldingModel.removeFoldRegion(regions[0]);
                    }
                    if (placeholder != null && (foldRegion = foldingModel.addFoldRegion(0, firstLineEnd, placeholder)) != null) {
                        foldRegion.setExpanded(false);
                    }
                });
            }
        };
        ScrollToTheEndToolbarAction autoScrollToTheEndAction = new ScrollToTheEndToolbarAction(this.myEditor);
        AnAction[] consoleActions = new AnAction[6 + this.customActions.size()];
        consoleActions[0] = prevAction;
        consoleActions[1] = nextAction;
        consoleActions[2] = switchSoftWrapsAction;
        consoleActions[3] = autoScrollToTheEndAction;
        consoleActions[4] = ActionManager.getInstance().getAction("Print");
        consoleActions[5] = new ClearAllAction(this);
        for (int i2 = 0; i2 < this.customActions.size(); ++i2) {
            consoleActions[i2 + 6] = this.customActions.get(i2);
        }
        ConsoleActionsPostProcessor[] postProcessors = (ConsoleActionsPostProcessor[])Extensions.getExtensions((ExtensionPointName)ConsoleActionsPostProcessor.EP_NAME);
        AnAction[] result2 = consoleActions;
        for (ConsoleActionsPostProcessor postProcessor : postProcessors) {
            result2 = postProcessor.postProcess((ConsoleView)this, result2);
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewImpl", "createConsoleActions"));
        }
        return result2;
    }

    public void allowHeavyFilters() {
        this.myAllowHeavyFilters = true;
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/impl/ConsoleViewImpl", "addChangeListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/execution/impl/ConsoleViewImpl", "addChangeListener"));
        }
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parent, () -> {
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/impl/ConsoleViewImpl", "lambda$addChangeListener$17"));
            }
            this.myListeners.remove(listener2);
        });
    }

    private void insertUserText(int offset, @NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/impl/ConsoleViewImpl", "insertUserText"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorEx editor = this.myEditor;
        Document document = editor.getDocument();
        int oldDocLength = document.getTextLength();
        document.insertString(offset, (CharSequence)text2);
        int newStartOffset = Math.max(0, document.getTextLength() - oldDocLength + offset - text2.length());
        int newEndOffset = document.getTextLength() - oldDocLength + offset;
        if (this.findTokenMarker(newEndOffset) == null) {
            this.createTokenRangeHighlighter(ConsoleViewContentType.USER_INPUT, newStartOffset, newEndOffset);
        }
        ConsoleViewImpl.moveScrollRemoveSelection(editor, newEndOffset);
        this.sendUserInput(text2);
    }

    private void replaceUserText(int start, int end, @NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/impl/ConsoleViewImpl", "replaceUserText"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorEx editor = this.myEditor;
        Document document = editor.getDocument();
        document.replaceString(start, end, (CharSequence)text2);
        int offset = start + text2.length();
        ConsoleViewImpl.moveScrollRemoveSelection(editor, offset);
        this.sendUserInput(text2);
    }

    private static void moveScrollRemoveSelection(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/impl/ConsoleViewImpl", "moveScrollRemoveSelection"));
        }
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    private void deleteUserText(int startOffset, int length) {
        EditorEx editor = this.myEditor;
        Document document = editor.getDocument();
        RangeMarker marker = this.findTokenMarker(startOffset);
        if (ConsoleViewImpl.getTokenType(marker) != ConsoleViewContentType.USER_INPUT) {
            return;
        }
        int endOffset = startOffset + length;
        if (startOffset >= 0 && endOffset >= 0 && endOffset > startOffset) {
            document.deleteString(startOffset, endOffset);
        }
        ConsoleViewImpl.moveScrollRemoveSelection(editor, startOffset);
    }

    public boolean isRunning() {
        return this.myState.isRunning();
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewImpl", "getProject"));
        }
        return project2;
    }

    @NotNull
    public String getText() {
        String string = this.myEditor.getDocument().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ConsoleViewImpl", "getText"));
        }
        return string;
    }

    static {
        NEW_LINE_MATCHER = CharMatcher.anyOf((CharSequence)"\n\r");
    }

    private class HyperlinkNavigationAction
    extends DumbAwareAction {
        private HyperlinkNavigationAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            Runnable runnable2 = ConsoleViewImpl.this.myHyperlinks.getLinkNavigationRunnable(ConsoleViewImpl.this.myEditor.getCaretModel().getLogicalPosition());
            assert (runnable2 != null);
            runnable2.run();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(ConsoleViewImpl.this.myHyperlinks.getLinkNavigationRunnable(ConsoleViewImpl.this.myEditor.getCaretModel().getLogicalPosition()) != null);
        }
    }

    private final class ClearRunnable
    extends FlushRunnable {
        private ClearRunnable() {
        }

        @Override
        public void doRun() {
            ConsoleViewImpl.this.doClear();
        }
    }

    private class FlushRunnable
    implements Runnable {
        private FlushRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Set set2 = ConsoleViewImpl.this.myCurrentRequests;
            synchronized (set2) {
                ConsoleViewImpl.this.myCurrentRequests.remove(this);
            }
            this.doRun();
        }

        protected void doRun() {
            ConsoleViewImpl.this.flushDeferredText();
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private class CommandLineFolding
    extends ConsoleFolding {
        private CommandLineFolding() {
        }

        @Nullable
        private String getPlaceholder(int line) {
            if (ConsoleViewImpl.this.myEditor == null || line != 0) {
                return null;
            }
            String text2 = EditorHyperlinkSupport.getLineText(ConsoleViewImpl.this.myEditor.getDocument(), 0, false);
            if (text2.length() < 1000) {
                return null;
            }
            int index = 0;
            if (text2.charAt(0) == '\"') {
                index = text2.indexOf(34, 1) + 1;
            }
            if (index == 0) {
                boolean nonWhiteSpaceFound = false;
                while (index < text2.length()) {
                    char c = text2.charAt(index);
                    if (c != ' ' && c != '\t') {
                        nonWhiteSpaceFound = true;
                    } else if (nonWhiteSpaceFound) break;
                    ++index;
                }
            }
            assert (index <= text2.length());
            return text2.substring(0, index) + " ...";
        }

        @Override
        public boolean shouldFoldLine(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/execution/impl/ConsoleViewImpl$CommandLineFolding", "shouldFoldLine"));
            }
            return false;
        }

        @Override
        public String getPlaceholderText(@NotNull List<String> lines) {
            if (lines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/execution/impl/ConsoleViewImpl$CommandLineFolding", "getPlaceholderText"));
            }
            return "<...>";
        }
    }

    private static class DeleteHandler
    extends ConsoleAction {
        private DeleteHandler() {
        }

        @Override
        public void execute(@NotNull ConsoleViewImpl consoleView, @NotNull DataContext context) {
            if (consoleView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/execution/impl/ConsoleViewImpl$DeleteHandler", "execute"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/impl/ConsoleViewImpl$DeleteHandler", "execute"));
            }
            EditorEx editor = consoleView.myEditor;
            if (IncrementalSearchHandler.isHintVisible(editor)) {
                DeleteHandler.getDefaultActionHandler().execute((Editor)editor, context);
                return;
            }
            consoleView.flushDeferredText();
            Document document = editor.getDocument();
            int length = document.getTextLength();
            if (length == 0) {
                return;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                consoleView.deleteUserText(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd() - selectionModel.getSelectionStart());
            } else {
                consoleView.deleteUserText(editor.getCaretModel().getOffset(), 1);
            }
        }

        private static EditorActionHandler getDefaultActionHandler() {
            return EditorActionManager.getInstance().getActionHandler("EditorBackSpace");
        }
    }

    private static class BackSpaceHandler
    extends ConsoleAction {
        private BackSpaceHandler() {
        }

        @Override
        public void execute(@NotNull ConsoleViewImpl consoleView, @NotNull DataContext context) {
            if (consoleView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/execution/impl/ConsoleViewImpl$BackSpaceHandler", "execute"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/impl/ConsoleViewImpl$BackSpaceHandler", "execute"));
            }
            EditorEx editor = consoleView.myEditor;
            if (IncrementalSearchHandler.isHintVisible(editor)) {
                BackSpaceHandler.getDefaultActionHandler().execute((Editor)editor, context);
                return;
            }
            Document document = editor.getDocument();
            int length = document.getTextLength();
            if (length == 0) {
                return;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                consoleView.deleteUserText(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd() - selectionModel.getSelectionStart());
            } else if (editor.getCaretModel().getOffset() > 0) {
                consoleView.deleteUserText(editor.getCaretModel().getOffset() - 1, 1);
            }
        }

        private static EditorActionHandler getDefaultActionHandler() {
            return EditorActionManager.getInstance().getActionHandler("EditorBackSpace");
        }
    }

    private static class PasteHandler
    extends ConsoleAction {
        private PasteHandler() {
        }

        @Override
        public void execute(@NotNull ConsoleViewImpl consoleView, @NotNull DataContext context) {
            if (consoleView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/execution/impl/ConsoleViewImpl$PasteHandler", "execute"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/impl/ConsoleViewImpl$PasteHandler", "execute"));
            }
            String text2 = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
            if (text2 == null) {
                return;
            }
            EditorEx editor = consoleView.myEditor;
            consoleView.type(editor, text2);
        }
    }

    private static class EnterHandler
    extends ConsoleAction {
        private EnterHandler() {
        }

        @Override
        public void execute(@NotNull ConsoleViewImpl consoleView, @NotNull DataContext context) {
            if (consoleView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/execution/impl/ConsoleViewImpl$EnterHandler", "execute"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/impl/ConsoleViewImpl$EnterHandler", "execute"));
            }
            consoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            consoleView.flushDeferredText();
            EditorEx editor = consoleView.myEditor;
            ConsoleViewImpl.moveScrollRemoveSelection(editor, editor.getDocument().getTextLength());
        }
    }

    private static abstract class ConsoleAction
    extends AnAction
    implements DumbAware {
        private ConsoleAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            DataContext context = e.getDataContext();
            ConsoleViewImpl console = ConsoleAction.getRunningConsole(context);
            if (console != null) {
                this.execute(console, context);
            }
        }

        protected abstract void execute(@NotNull ConsoleViewImpl var1, @NotNull DataContext var2);

        public void update(AnActionEvent e) {
            ConsoleViewImpl console = ConsoleAction.getRunningConsole(e.getDataContext());
            e.getPresentation().setEnabled(console != null);
        }

        @Nullable
        private static ConsoleViewImpl getRunningConsole(@NotNull DataContext context) {
            ConsoleViewImpl console;
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/impl/ConsoleViewImpl$ConsoleAction", "getRunningConsole"));
            }
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
            if (editor != null && (console = (ConsoleViewImpl)editor.getUserData(CONSOLE_VIEW_IN_EDITOR_VIEW)) != null && console.myState.isRunning()) {
                return console;
            }
            return null;
        }
    }

    private static class MyTypedHandler
    extends TypedActionHandlerBase {
        private MyTypedHandler(TypedActionHandler originalAction) {
            super(originalAction);
        }

        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/impl/ConsoleViewImpl$MyTypedHandler", "execute"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/execution/impl/ConsoleViewImpl$MyTypedHandler", "execute"));
            }
            ConsoleViewImpl consoleView = (ConsoleViewImpl)editor.getUserData(CONSOLE_VIEW_IN_EDITOR_VIEW);
            if (consoleView == null || !consoleView.myState.isRunning() || consoleView.myIsViewer) {
                if (this.myOriginalHandler != null) {
                    this.myOriginalHandler.execute(editor, charTyped, dataContext);
                }
                return;
            }
            String text2 = String.valueOf(charTyped);
            consoleView.type(editor, text2);
        }
    }

    public static class ClearAllAction
    extends DumbAwareAction {
        private final ConsoleView myConsoleView;

        public ClearAllAction() {
            this(null);
        }

        ClearAllAction(ConsoleView consoleView) {
            super(ExecutionBundle.message((String)"clear.all.from.console.action.name", (Object[])new Object[0]), "Clear the contents of the console", AllIcons.Actions.GC);
            this.myConsoleView = consoleView;
        }

        public void update(AnActionEvent e) {
            boolean enabled;
            boolean bl = enabled = this.myConsoleView != null && this.myConsoleView.getContentSize() > 0;
            if (!enabled) {
                enabled = e.getData(LangDataKeys.CONSOLE_VIEW) != null;
                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                if (editor != null && editor.getDocument().getTextLength() == 0) {
                    enabled = false;
                }
            }
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            ConsoleView consoleView;
            ConsoleView consoleView2 = consoleView = this.myConsoleView != null ? this.myConsoleView : (ConsoleView)e.getData(LangDataKeys.CONSOLE_VIEW);
            if (consoleView != null) {
                consoleView.clear();
            }
        }
    }
}

