/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectRunConfigurationManager", storages={@Storage(value="runConfigurations", stateSplitter=RunConfigurationStateSplitter.class)})
@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/impl/ProjectRunConfigurationManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "manager", "Lcom/intellij/execution/RunManager;", "(Lcom/intellij/execution/RunManager;)V", "Lcom/intellij/execution/impl/RunManagerImpl;", "getState", "loadState", "", "state", "RunConfigurationStateSplitter", "lang-impl"})
public final class ProjectRunConfigurationManager
implements PersistentStateComponent<Element> {
    private final RunManagerImpl manager;

    @Nullable
    public Element getState() {
        if (Registry.is((String)"runManager.use.schemeManager", (boolean)false)) {
            return null;
        }
        Element state = new Element("state");
        this.manager.writeConfigurations(state, (Collection<? extends RunnerAndConfigurationSettings>)this.manager.getSharedConfigurations());
        return state;
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (Registry.is((String)"runManager.use.schemeManager", (boolean)false)) {
            return;
        }
        THashSet existing = new THashSet();
        Iterator<Object> iterator = state.getChildren(RunManagerImpl.CONFIGURATION).iterator();
        while (iterator.hasNext()) {
            Element child;
            Element element = child = (Element)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"child");
            existing.add((Object)this.manager.loadConfiguration(element, true).getUniqueID());
        }
        this.manager.removeNotExistingSharedConfigurations((Set)existing);
        this.manager.requestSort();
        if (this.manager.getSelectedConfiguration() == null) {
            for (RunnerAndConfigurationSettings settings : this.manager.getAllSettings()) {
                if (settings.getType() instanceof UnknownRunConfiguration) continue;
                this.manager.setSelectedConfiguration(settings);
                break;
            }
        }
    }

    public ProjectRunConfigurationManager(@NotNull RunManager manager) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        this.manager = (RunManagerImpl)manager;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/execution/impl/ProjectRunConfigurationManager$RunConfigurationStateSplitter;", "Lcom/intellij/openapi/components/StateSplitterEx;", "()V", "splitState", "", "Lcom/intellij/openapi/util/Pair;", "Lorg/jdom/Element;", "", "state", "lang-impl"})
    public static final class RunConfigurationStateSplitter
    extends StateSplitterEx {
        @NotNull
        public List<Pair<Element, String>> splitState(@NotNull Element state) {
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            List list2 = RunConfigurationStateSplitter.access$splitState$s2025038123(state, RunManagerImpl.NAME_ATTR);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"StateSplitterEx.splitSta\u2026RunManagerImpl.NAME_ATTR)");
            return list2;
        }

        @NotNull
        public static final /* synthetic */ List access$splitState$s2025038123(@NotNull Element p0, @NotNull String p1) {
            return StateSplitterEx.splitState((Element)p0, (String)p1);
        }
    }
}

