/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl.statistics;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRunConfigurationTypeUsagesCollector
extends AbstractApplicationUsagesCollector {
    protected abstract boolean isApplicable(@NotNull RunManager var1, @NotNull RunnerAndConfigurationSettings var2);

    @Override
    @NotNull
    public final Set<UsageDescriptor> getProjectUsages(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/impl/statistics/AbstractRunConfigurationTypeUsagesCollector", "getProjectUsages"));
        }
        HashSet runConfigurationTypes = new HashSet();
        UIUtil.invokeAndWaitIfNeeded(() -> this.lambda$getProjectUsages$0(project2, (Set)runConfigurationTypes));
        Set set2 = ContainerUtil.map2Set((Collection)runConfigurationTypes, runConfigurationType -> new UsageDescriptor((String)runConfigurationType, 1));
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/statistics/AbstractRunConfigurationTypeUsagesCollector", "getProjectUsages"));
        }
        return set2;
    }

    private /* synthetic */ void lambda$getProjectUsages$0(@NotNull Project project2, Set runConfigurationTypes) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/impl/statistics/AbstractRunConfigurationTypeUsagesCollector", "lambda$getProjectUsages$0"));
        }
        if (project2.isDisposed()) {
            return;
        }
        RunManager runManager = RunManager.getInstance((Project)project2);
        for (RunnerAndConfigurationSettings settings : runManager.getAllSettings()) {
            RunConfiguration runConfiguration = settings.getConfiguration();
            if (runConfiguration == null || !this.isApplicable(runManager, settings)) continue;
            ConfigurationFactory configurationFactory = runConfiguration.getFactory();
            ConfigurationType configurationType = configurationFactory.getType();
            StringBuilder keyBuilder = new StringBuilder();
            keyBuilder.append(configurationType.getId());
            if (configurationType.getConfigurationFactories().length > 1) {
                keyBuilder.append(".").append(configurationFactory.getName());
            }
            runConfigurationTypes.add(keyBuilder.toString());
        }
    }
}

