/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.AbstractJavaTestConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInClassConfigurationProducer<T extends JavaTestConfigurationBase>
extends AbstractJavaTestConfigurationProducer<T> {
    protected AbstractInClassConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    public void onFirstRun(final @NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext fromContext, @NotNull Runnable performRunnable) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/testframework/AbstractInClassConfigurationProducer", "onFirstRun"));
        }
        if (fromContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromContext", "com/intellij/execution/testframework/AbstractInClassConfigurationProducer", "onFirstRun"));
        }
        if (performRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "performRunnable", "com/intellij/execution/testframework/AbstractInClassConfigurationProducer", "onFirstRun"));
        }
        final PsiElement psiElement = configuration.getSourceElement();
        if (psiElement instanceof PsiMethod || psiElement instanceof PsiClass) {
            PsiClass containingClass;
            PsiMethod psiMethod;
            if (psiElement instanceof PsiMethod) {
                psiMethod = (PsiMethod)psiElement;
                containingClass = psiMethod.getContainingClass();
            } else {
                psiMethod = null;
                containingClass = (PsiClass)psiElement;
            }
            InheritorChooser inheritorChooser = new InheritorChooser(){

                @Override
                protected void runForClasses(List<PsiClass> classes2, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                    ((JavaTestConfigurationBase)configuration.getConfiguration()).bePatternConfiguration(classes2, method);
                    super.runForClasses(classes2, method, context, performRunnable);
                }

                @Override
                protected void runForClass(PsiClass aClass, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable) {
                    if (psiElement instanceof PsiMethod) {
                        Project project2 = psiMethod.getProject();
                        MethodLocation methodLocation = new MethodLocation(project2, psiMethod, (Location<PsiClass>)PsiLocation.fromPsiElement((PsiElement)aClass));
                        ((JavaTestConfigurationBase)configuration.getConfiguration()).beMethodConfiguration(methodLocation);
                    } else {
                        ((JavaTestConfigurationBase)configuration.getConfiguration()).beClassConfiguration(aClass);
                    }
                    super.runForClass(aClass, psiMethod, context, performRunnable);
                }
            };
            if (inheritorChooser.runMethodInAbstractClass(fromContext, performRunnable, psiMethod, containingClass, (Condition<PsiClass>)((Condition)aClass -> aClass.hasModifierProperty("abstract") && this.isTestClass((PsiClass)aClass)))) {
                return;
            }
        }
        super.onFirstRun(configuration, fromContext, performRunnable);
    }

    protected boolean setupConfigurationFromContext(T configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (this.isMultipleElementsSelected(context)) {
            return false;
        }
        Location contextLocation = context.getLocation();
        this.setupConfigurationParamName(configuration, contextLocation);
        PsiClass psiClass = null;
        for (PsiElement element = context.getPsiLocation(); element != null; element = element.getParent()) {
            PsiClass[] classes2;
            if (element instanceof PsiClass && this.isTestClass((PsiClass)element)) {
                psiClass = (PsiClass)element;
                break;
            }
            if (element instanceof PsiMember) {
                PsiClass psiClass2 = psiClass = contextLocation instanceof MethodLocation ? ((MethodLocation)contextLocation).getContainingClass() : ((PsiMember)element).getContainingClass();
                if (!this.isTestClass(psiClass)) continue;
                break;
            }
            if (!(element instanceof PsiClassOwner) || (classes2 = ((PsiClassOwner)element).getClasses()).length != 1) continue;
            psiClass = classes2[0];
            break;
        }
        if (!this.isTestClass(psiClass)) {
            return false;
        }
        PsiClass psiElement = psiClass;
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(context);
        this.setupConfigurationModule(context, configuration);
        Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        ((JavaTestConfigurationBase)configuration).beClassConfiguration(psiClass);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context.getPsiLocation(), PsiMethod.class, (boolean)false);
        while (method != null) {
            if (this.isTestMethod(false, method)) {
                ((JavaTestConfigurationBase)configuration).beMethodConfiguration(MethodLocation.elementInClass(method, psiClass));
                psiElement = method;
            }
            method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)method, PsiMethod.class);
        }
        configuration.restoreOriginalModule(originalModule);
        settings.setName(configuration.getName());
        sourceElement.set((Object)psiElement);
        return true;
    }
}

