/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public interface Printer {
    public void print(String var1, ConsoleViewContentType var2);

    public void onNewAvailable(@NotNull Printable var1);

    public void printHyperlink(String var1, HyperlinkInfo var2);

    public void mark();

    default public void printWithAnsiColoring(@NotNull String text2, @NotNull Key processOutputType) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/testframework/Printer", "printWithAnsiColoring"));
        }
        if (processOutputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processOutputType", "com/intellij/execution/testframework/Printer", "printWithAnsiColoring"));
        }
        AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
        decoder.escapeText(text2, ProcessOutputTypes.STDOUT, (text1, attributes) -> {
            if (processOutputType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processOutputType", "com/intellij/execution/testframework/Printer", "lambda$printWithAnsiColoring$0"));
            }
            ConsoleViewContentType contentType = ConsoleViewContentType.getConsoleViewType((Key)attributes);
            if (contentType == null || contentType == ConsoleViewContentType.NORMAL_OUTPUT) {
                contentType = ConsoleViewContentType.getConsoleViewType((Key)processOutputType);
            }
            this.print(text1, contentType);
        });
    }

    default public void printWithAnsiColoring(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/testframework/Printer", "printWithAnsiColoring"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/execution/testframework/Printer", "printWithAnsiColoring"));
        }
        AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
        decoder.escapeText(text2, ProcessOutputTypes.STDOUT, (text1, attributes) -> {
            if (contentType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/execution/testframework/Printer", "lambda$printWithAnsiColoring$1"));
            }
            ConsoleViewContentType viewContentType = ConsoleViewContentType.getConsoleViewType((Key)attributes);
            if (viewContentType == null) {
                viewContentType = contentType;
            }
            this.print(text1, viewContentType);
        });
    }
}

