/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.execution.DelayedDocumentWatcher;
import com.intellij.execution.testframework.autotest.AbstractAutoTestManager;
import com.intellij.execution.testframework.autotest.AutoTestWatcher;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;

@State(name="AutoTestManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class AutoTestManager
extends AbstractAutoTestManager {
    @NotNull
    public static AutoTestManager getInstance(Project project2) {
        AutoTestManager autoTestManager = (AutoTestManager)ServiceManager.getService((Project)project2, AutoTestManager.class);
        if (autoTestManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/autotest/AutoTestManager", "getInstance"));
        }
        return autoTestManager;
    }

    public AutoTestManager(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/autotest/AutoTestManager", "<init>"));
        }
        super(project2);
    }

    @Override
    @NotNull
    protected AutoTestWatcher createWatcher(Project project2) {
        DelayedDocumentWatcher delayedDocumentWatcher = new DelayedDocumentWatcher(project2, this.myDelayMillis, (Consumer<Integer>)((Consumer)this::restartAllAutoTests), (Condition<VirtualFile>)((Condition)file2 -> {
            if (ScratchFileService.getInstance().getRootType((VirtualFile)file2) != null) {
                return false;
            }
            return FileEditorManager.getInstance((Project)project2).isFileOpen(file2);
        }));
        if (delayedDocumentWatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/autotest/AutoTestManager", "createWatcher"));
        }
        return delayedDocumentWatcher;
    }
}

