/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeNodeEvent {
    @NonNls
    public static final String ROOT_NODE_ID = "0";
    private final String myName;
    private final String myId;

    public TreeNodeEvent(@Nullable String name2, @Nullable String id) {
        this.myName = name2;
        this.myId = id;
    }

    protected void fail(@NotNull String message2) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/execution/testframework/sm/runner/events/TreeNodeEvent", "fail"));
        }
        throw new IllegalStateException(message2 + ", " + this.toString());
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getId() {
        return this.myId;
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getSimpleName() + "{");
        TreeNodeEvent.append(buf, "name", this.myName);
        TreeNodeEvent.append(buf, "id", this.myId);
        this.appendToStringInfo(buf);
        buf.setLength(buf.length() - 2);
        buf.append("}");
        return buf.toString();
    }

    protected abstract void appendToStringInfo(@NotNull StringBuilder var1);

    protected static void append(@NotNull StringBuilder buffer, @NotNull String key2, @Nullable Object value2) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/execution/testframework/sm/runner/events/TreeNodeEvent", "append"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/execution/testframework/sm/runner/events/TreeNodeEvent", "append"));
        }
        if (value2 != null) {
            buffer.append(key2).append("=");
            if (value2 instanceof String) {
                buffer.append("'").append(value2).append("'");
            } else {
                buffer.append(String.valueOf(value2));
            }
            buffer.append(", ");
        }
    }

    @Nullable
    public static String getNodeId(@NotNull ServiceMessage message2) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/execution/testframework/sm/runner/events/TreeNodeEvent", "getNodeId"));
        }
        return TreeNodeEvent.getNodeId(message2, "nodeId");
    }

    @Nullable
    public static String getNodeId(@NotNull ServiceMessage message2, String key2) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/execution/testframework/sm/runner/events/TreeNodeEvent", "getNodeId"));
        }
        return (String)message2.getAttributes().get(key2);
    }
}

