/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.Storage;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StoringPropertyContainer
extends AbstractProperty.AbstractPropertyContainer<AbstractProperty<Boolean>> {
    private final Map<AbstractProperty<Boolean>, Boolean> myValues;
    private final Storage myStorage;

    public StoringPropertyContainer(String groupName, PropertiesComponent propertiesComponent) {
        this((Storage)new Storage.PropertiesComponentStorage(groupName, propertiesComponent));
    }

    public StoringPropertyContainer(@NotNull Storage storage2) {
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/execution/util/StoringPropertyContainer", "<init>"));
        }
        this.myValues = new HashMap();
        this.myStorage = storage2;
    }

    public void setIfUndefined(@NotNull AbstractProperty<Boolean> property, boolean value2) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/execution/util/StoringPropertyContainer", "setIfUndefined"));
        }
        if (this.myStorage.get(property.getName()) == null) {
            this.setValueOf(property, value2);
        }
    }

    protected void setValueOf(@NotNull AbstractProperty<Boolean> property, Object value2) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/execution/util/StoringPropertyContainer", "setValueOf"));
        }
        this.myValues.put(property, (Boolean)value2);
        this.onPropertyChanged(property, (Boolean)value2);
        this.myStorage.put(property.getName(), value2.toString());
    }

    public boolean hasProperty(@NotNull AbstractProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/execution/util/StoringPropertyContainer", "hasProperty"));
        }
        return this.myValues.containsKey(property);
    }

    protected Object getValueOf(@NotNull AbstractProperty<Boolean> property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/execution/util/StoringPropertyContainer", "getValueOf"));
        }
        Object value2 = this.myValues.get(property);
        if (value2 == null) {
            String stringValue = this.myStorage.get(property.getName());
            value2 = stringValue != null ? Boolean.valueOf(stringValue) : property.getDefault((AbstractProperty.AbstractPropertyContainer)this);
            this.myValues.put(property, (Boolean)value2);
        }
        return value2;
    }

    protected <T> void onPropertyChanged(@NotNull AbstractProperty<T> property, T value2) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/execution/util/StoringPropertyContainer", "onPropertyChanged"));
        }
    }
}

