/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.facet.FacetModificationTrackingService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class FacetModificationTrackingServiceImpl
extends FacetModificationTrackingService {
    private final ConcurrentMap<Facet, Pair<SimpleModificationTracker, EventDispatcher<ModificationTrackerListener>>> myModificationsTrackers = ContainerUtil.newConcurrentMap();

    public FacetModificationTrackingServiceImpl(Module module2) {
        module2.getMessageBus().connect().subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetModificationTrackingListener());
    }

    @NotNull
    public ModificationTracker getFacetModificationTracker(@NotNull Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/impl/FacetModificationTrackingServiceImpl", "getFacetModificationTracker"));
        }
        ModificationTracker modificationTracker = (ModificationTracker)this.getFacetInfo((Facet)facet).first;
        if (modificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetModificationTrackingServiceImpl", "getFacetModificationTracker"));
        }
        return modificationTracker;
    }

    private Pair<SimpleModificationTracker, EventDispatcher<ModificationTrackerListener>> getFacetInfo(Facet facet) {
        Pair pair2 = (Pair)this.myModificationsTrackers.get(facet);
        if (pair2 != null) {
            return pair2;
        }
        this.myModificationsTrackers.putIfAbsent(facet, (Pair<SimpleModificationTracker, EventDispatcher<ModificationTrackerListener>>)Pair.create((Object)new SimpleModificationTracker(), (Object)EventDispatcher.create(ModificationTrackerListener.class)));
        return (Pair)this.myModificationsTrackers.get(facet);
    }

    public void incFacetModificationTracker(@NotNull Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/impl/FacetModificationTrackingServiceImpl", "incFacetModificationTracker"));
        }
        Pair<SimpleModificationTracker, EventDispatcher<ModificationTrackerListener>> pair2 = this.getFacetInfo(facet);
        ((SimpleModificationTracker)pair2.first).incModificationCount();
        ((ModificationTrackerListener)((EventDispatcher)pair2.second).getMulticaster()).modificationCountChanged((Object)facet);
    }

    public <T extends Facet> void addModificationTrackerListener(T facet, ModificationTrackerListener<? super T> listener2, Disposable parent) {
        ((EventDispatcher)this.getFacetInfo(facet).second).addListener(listener2, parent);
    }

    public void removeModificationTrackerListener(Facet facet, ModificationTrackerListener<?> listener2) {
        ((EventDispatcher)this.getFacetInfo((Facet)facet).second).removeListener(listener2);
    }

    private class FacetModificationTrackingListener
    extends FacetManagerAdapter {
        private FacetModificationTrackingListener() {
        }

        public void facetConfigurationChanged(@NotNull Facet facet) {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/impl/FacetModificationTrackingServiceImpl$FacetModificationTrackingListener", "facetConfigurationChanged"));
            }
            FacetModificationTrackingServiceImpl.this.incFacetModificationTracker(facet);
        }

        public void facetRemoved(@NotNull Facet facet) {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/impl/FacetModificationTrackingServiceImpl$FacetModificationTrackingListener", "facetRemoved"));
            }
            FacetModificationTrackingServiceImpl.this.myModificationsTrackers.remove(facet);
        }
    }
}

