/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.impl.ui.FacetErrorPanel;
import com.intellij.facet.ui.FacetEditor;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.UnnamedConfigurableGroup;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.ui.configuration.ModificationOfImportedModelWarningComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetEditorImpl
extends UnnamedConfigurableGroup
implements UnnamedConfigurable,
FacetEditor {
    private final FacetEditorTab[] myEditorTabs;
    private final FacetErrorPanel myErrorPanel;
    private JComponent myComponent;
    @Nullable
    private TabbedPaneWrapper myTabbedPane;
    private final FacetEditorContext myContext;
    private final Set<FacetEditorTab> myVisitedTabs = new HashSet<FacetEditorTab>();
    private int mySelectedTabIndex = 0;
    private final Disposable myDisposable = Disposer.newDisposable();

    public FacetEditorImpl(FacetEditorContext context, FacetConfiguration configuration) {
        this.myContext = context;
        this.myErrorPanel = new FacetErrorPanel();
        for (FacetEditorTab configurable : this.myEditorTabs = configuration.createEditorTabs(context, this.myErrorPanel.getValidatorsManager())) {
            this.add((UnnamedConfigurable)configurable);
        }
    }

    public void reset() {
        super.reset();
        this.myErrorPanel.getValidatorsManager().validate();
    }

    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myComponent = this.createComponent();
        }
        return this.myComponent;
    }

    public JComponent createComponent() {
        JComponent editorComponent;
        if (this.myEditorTabs.length > 1) {
            final TabbedPaneWrapper tabbedPane = new TabbedPaneWrapper(this.myDisposable);
            for (FacetEditorTab editorTab : this.myEditorTabs) {
                JComponent c = editorTab.createComponent();
                UIUtil.addInsets((JComponent)c, (Insets)UIUtil.PANEL_SMALL_INSETS);
                tabbedPane.addTab(editorTab.getDisplayName(), c);
            }
            tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(@NotNull ChangeEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/facet/impl/ui/FacetEditorImpl$1", "stateChanged"));
                    }
                    FacetEditorImpl.this.myEditorTabs[FacetEditorImpl.this.mySelectedTabIndex].onTabLeaving();
                    FacetEditorImpl.this.mySelectedTabIndex = tabbedPane.getSelectedIndex();
                    FacetEditorImpl.this.onTabSelected(FacetEditorImpl.this.myEditorTabs[FacetEditorImpl.this.mySelectedTabIndex]);
                }
            });
            editorComponent = tabbedPane.getComponent();
            this.myTabbedPane = tabbedPane;
        } else if (this.myEditorTabs.length == 1) {
            editorComponent = this.myEditorTabs[0].createComponent();
            UIUtil.addInsets((JComponent)editorComponent, (Insets)JBUI.insets((int)0, (int)5, (int)0, (int)0));
        } else {
            editorComponent = new JPanel();
        }
        final ProjectModelExternalSource externalSource = this.myContext.getFacet().getExternalSource();
        if (externalSource != null) {
            this.myErrorPanel.getValidatorsManager().registerValidator(new FacetEditorValidator(){

                @NotNull
                public ValidationResult check() {
                    if (FacetEditorImpl.this.isModified()) {
                        String text2 = ModificationOfImportedModelWarningComponent.getWarningText("Facet '" + FacetEditorImpl.this.myContext.getFacetName() + "'", externalSource);
                        ValidationResult validationResult = new ValidationResult(text2);
                        if (validationResult == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/FacetEditorImpl$2", "check"));
                        }
                        return validationResult;
                    }
                    ValidationResult validationResult = ValidationResult.OK;
                    if (validationResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/FacetEditorImpl$2", "check"));
                    }
                    return validationResult;
                }
            }, new JComponent[]{editorComponent});
        }
        JComponent errorComponent = this.myErrorPanel.getComponent();
        UIUtil.addInsets((JComponent)errorComponent, (Insets)JBUI.insets((int)0, (int)5, (int)5, (int)0));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add("Center", editorComponent);
        panel2.add("South", errorComponent);
        return panel2;
    }

    private void onTabSelected(FacetEditorTab selectedTab) {
        JComponent preferredFocusedComponent;
        selectedTab.onTabEntering();
        if (this.myVisitedTabs.add(selectedTab) && (preferredFocusedComponent = selectedTab.getPreferredFocusedComponent()) != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (preferredFocusedComponent.isShowing()) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)preferredFocusedComponent, true));
                }
            });
        }
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
        this.myErrorPanel.disposeUIResources();
        super.disposeUIResources();
    }

    @Nullable
    public String getHelpTopic() {
        return 0 <= this.mySelectedTabIndex && this.mySelectedTabIndex < this.myEditorTabs.length ? this.myEditorTabs[this.mySelectedTabIndex].getHelpTopic() : null;
    }

    public void onFacetAdded(@NotNull Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/impl/ui/FacetEditorImpl", "onFacetAdded"));
        }
        for (FacetEditorTab editorTab : this.myEditorTabs) {
            editorTab.onFacetInitialized(facet);
        }
    }

    public void setSelectedTabName(String tabName) {
        this.getComponent();
        TabbedPaneWrapper tabbedPane = this.myTabbedPane;
        if (tabbedPane == null) {
            return;
        }
        for (int i2 = 0; i2 < tabbedPane.getTabCount(); ++i2) {
            if (!tabName.equals(tabbedPane.getTitleAt(i2))) continue;
            tabbedPane.setSelectedIndex(i2);
            return;
        }
    }

    public FacetEditorContext getContext() {
        return this.myContext;
    }

    public void onFacetSelected() {
        if (this.mySelectedTabIndex < this.myEditorTabs.length) {
            this.onTabSelected(this.myEditorTabs[this.mySelectedTabIndex]);
        }
    }

    public FacetEditorTab[] getEditorTabs() {
        return this.myEditorTabs;
    }

    public <T extends FacetEditorTab> T getEditorTab(@NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/facet/impl/ui/FacetEditorImpl", "getEditorTab"));
        }
        for (FacetEditorTab editorTab : this.myEditorTabs) {
            if (!aClass.isInstance(editorTab)) continue;
            return (T)((FacetEditorTab)aClass.cast(editorTab));
        }
        return null;
    }
}

