/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.FacetInfo;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.BidirectionalMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetTreeModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.ui.FacetTreeModel");
    private static final FacetInfo ROOT = new FacetInfo(null, "", null, null);
    private final List<FacetInfo> myFacetInfos = new ArrayList<FacetInfo>();
    private final BidirectionalMap<FacetInfo, FacetInfo> myParents = new BidirectionalMap();

    public void addFacetInfo(FacetInfo info) {
        this.myFacetInfos.add(info);
        this.myParents.put((Object)info, (Object)FacetTreeModel.null2Root(info.getUnderlyingFacet()));
    }

    @NotNull
    private static FacetInfo null2Root(@Nullable FacetInfo info) {
        FacetInfo facetInfo = info == null ? ROOT : info;
        if (facetInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/FacetTreeModel", "null2Root"));
        }
        return facetInfo;
    }

    @Nullable
    private static FacetInfo root2Null(@NotNull FacetInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/facet/impl/ui/FacetTreeModel", "root2Null"));
        }
        return info == ROOT ? null : info;
    }

    public FacetInfo[] getFacetInfos() {
        return this.myFacetInfos.toArray(new FacetInfo[this.myFacetInfos.size()]);
    }

    public void removeFacetInfo(@NotNull FacetInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/facet/impl/ui/FacetTreeModel", "removeFacetInfo"));
        }
        boolean removed = this.myFacetInfos.remove(info);
        LOG.assertTrue(removed);
        this.myParents.remove((Object)info);
    }

    @Nullable
    public FacetInfo getParent(@NotNull FacetInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/facet/impl/ui/FacetTreeModel", "getParent"));
        }
        return FacetTreeModel.root2Null((FacetInfo)this.myParents.get((Object)info));
    }

    @NotNull
    public List<FacetInfo> getChildren(@Nullable FacetInfo info) {
        List list2 = this.myParents.getKeysByValue((Object)FacetTreeModel.null2Root(info));
        if (list2 == null) {
            List<FacetInfo> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/FacetTreeModel", "getChildren"));
            }
            return list3;
        }
        List<FacetInfo> list4 = Collections.unmodifiableList(list2);
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/ui/FacetTreeModel", "getChildren"));
        }
        return list4;
    }

    public List<FacetInfo> getTopLevelFacets() {
        return this.getChildren(null);
    }

    @Nullable
    public FacetInfo findNearestFacet(@NotNull FacetInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/facet/impl/ui/FacetTreeModel", "findNearestFacet"));
        }
        FacetInfo parent = this.getParent(info);
        List<FacetInfo> children2 = this.getChildren(parent);
        int index = children2.indexOf(info);
        if (index < children2.size() - 1) {
            return children2.get(index + 1);
        }
        if (index > 0) {
            return children2.get(index - 1);
        }
        return parent;
    }

    public boolean hasFacetOfType(@Nullable FacetInfo parent, FacetTypeId typeId) {
        List<FacetInfo> list2 = this.getChildren(parent);
        for (FacetInfo info : list2) {
            if (info.getFacetType().getId() != typeId) continue;
            return true;
        }
        return false;
    }

    public Collection<FacetInfo> getFacetInfos(FacetType<?, ?> type2) {
        FacetInfo[] facetInfos = this.getFacetInfos();
        ArrayList<FacetInfo> infos = new ArrayList<FacetInfo>();
        for (FacetInfo facetInfo : facetInfos) {
            if (!facetInfo.getFacetType().equals(type2)) continue;
            infos.add(facetInfo);
        }
        return infos;
    }
}

