/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class FindAllAction
extends AnAction
implements ShortcutProvider,
DumbAware {
    public FindAllAction() {
        this.getTemplatePresentation().setDescription("Export matches to Find tool window");
        this.getTemplatePresentation().setText("Find All");
    }

    public void update(AnActionEvent e) {
        Project project2 = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        EditorSearchSession search = (EditorSearchSession)e.getData(EditorSearchSession.SESSION_KEY);
        this.updateTemplateIcon(search);
        e.getPresentation().setIcon(this.getTemplatePresentation().getIcon());
        e.getPresentation().setEnabled(editor != null && project2 != null && search != null && !project2.isDisposed() && search.hasMatches() && PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument()) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)e.getRequiredData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        EditorSearchSession search = (EditorSearchSession)e.getRequiredData(EditorSearchSession.SESSION_KEY);
        if (project2.isDisposed()) {
            return;
        }
        FindModel oldModel = FindManager.getInstance((Project)project2).getFindInFileModel();
        FindModel newModel = oldModel.clone();
        String text2 = search.getTextInField();
        if (StringUtil.isEmpty((String)text2)) {
            return;
        }
        newModel.setStringToFind(text2);
        FindUtil.findAllAndShow(project2, editor, newModel);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        AnAction findUsages = ActionManager.getInstance().getAction("FindUsages");
        return findUsages != null ? findUsages.getShortcutSet() : null;
    }

    private void updateTemplateIcon(@Nullable EditorSearchSession session2) {
        if (session2 == null || this.getTemplatePresentation().getIcon() != null) {
            return;
        }
        Icon base = AllIcons.Actions.Find;
        Icon text2 = IconUtil.textToIcon((String)"ALL", (Component)session2.getComponent(), (float)JBUI.scale((float)6.0f));
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(base, 0);
        icon.setIcon(text2, 1, 0, base.getIconHeight() - text2.getIconHeight());
        this.getTemplatePresentation().setIcon((Icon)icon);
    }
}

