/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SwitchToFind
extends AnAction
implements DumbAware {
    public SwitchToFind(@NotNull JComponent shortcutHolder) {
        if (shortcutHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcutHolder", "com/intellij/find/editorHeaderActions/SwitchToFind", "<init>"));
        }
        AnAction findAction = ActionManager.getInstance().getAction("Find");
        if (findAction != null) {
            this.registerCustomShortcutSet(findAction.getShortcutSet(), shortcutHolder);
        }
    }

    public void update(AnActionEvent e) {
        if (KeymapUtil.isEmacsKeymap()) {
            ActionManager.getInstance().getAction("FindNext").update(e);
        } else {
            EditorSearchSession search = (EditorSearchSession)e.getData(EditorSearchSession.SESSION_KEY);
            e.getPresentation().setEnabledAndVisible(search != null);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        if (KeymapUtil.isEmacsKeymap()) {
            ActionManager.getInstance().getAction("FindNext").actionPerformed(e);
            return;
        }
        EditorSearchSession search = (EditorSearchSession)e.getRequiredData(EditorSearchSession.SESSION_KEY);
        FindModel findModel = search.getFindModel();
        FindUtil.configureFindModel(false, (Editor)e.getData(CommonDataKeys.EDITOR), findModel, false);
        search.getComponent().getSearchTextComponent().selectAll();
    }
}

