/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findInProject;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class FindInProjectManager {
    private final Project myProject;
    private volatile boolean myIsFindInProgress;

    public static FindInProjectManager getInstance(Project project2) {
        return (FindInProjectManager)ServiceManager.getService((Project)project2, FindInProjectManager.class);
    }

    public FindInProjectManager(Project project2) {
        this.myProject = project2;
    }

    public void findInProject(@NotNull DataContext dataContext) {
        boolean isOpenInNewTabEnabled;
        boolean toOpenInNewTab;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/find/findInProject/FindInProjectManager", "findInProject"));
        }
        Content selectedContent = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getSelectedContent(true);
        if (selectedContent != null && selectedContent.isPinned()) {
            toOpenInNewTab = true;
            isOpenInNewTabEnabled = false;
        } else {
            toOpenInNewTab = FindSettings.getInstance().isShowResultsInSeparateView();
            isOpenInNewTabEnabled = com.intellij.usageView.UsageViewManager.getInstance((Project)this.myProject).getReusableContentsCount() > 0;
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        FindModel findModel = findManager.getFindInProjectModel().clone();
        findModel.setReplaceState(false);
        findModel.setOpenInNewTabVisible(true);
        findModel.setOpenInNewTabEnabled(isOpenInNewTabEnabled);
        findModel.setOpenInNewTab(toOpenInNewTab);
        this.initModel(findModel, dataContext);
        findManager.showFindDialog(findModel, () -> {
            findModel.setOpenInNewTabVisible(false);
            if (isOpenInNewTabEnabled) {
                FindSettings.getInstance().setShowResultsInSeparateView(findModel.isOpenInNewTab());
            }
            this.startFindInProject(findModel);
            findModel.setOpenInNewTabVisible(false);
        });
    }

    protected void initModel(@NotNull FindModel findModel, @NotNull DataContext dataContext) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/findInProject/FindInProjectManager", "initModel"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/find/findInProject/FindInProjectManager", "initModel"));
        }
        FindInProjectUtil.setDirectoryName(findModel, dataContext);
        String text2 = (String)PlatformDataKeys.PREDEFINED_TEXT.getData(dataContext);
        if (text2 != null) {
            FindModel.initStringToFindNoMultiline((FindModel)findModel, (String)text2);
        } else {
            FindInProjectUtil.initStringToFindFromDataContext(findModel, dataContext);
        }
    }

    public void startFindInProject(@NotNull FindModel findModel) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/findInProject/FindInProjectManager", "startFindInProject"));
        }
        if (findModel.getDirectoryName() != null && FindInProjectUtil.getDirectory(findModel) == null) {
            return;
        }
        UsageViewManager manager = UsageViewManager.getInstance((Project)this.myProject);
        if (manager == null) {
            return;
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        findManager.getFindInProjectModel().copyFrom(findModel);
        FindModel findModelCopy = findModel.clone();
        UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(FindSettings.getInstance().isShowResultsInSeparateView(), findModelCopy);
        boolean showPanelIfOnlyOneUsage = !FindSettings.getInstance().isSkipResultsWithOneUsage();
        FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(this.myProject, showPanelIfOnlyOneUsage, presentation);
        FindInProjectUtil.StringUsageTarget usageTarget = new FindInProjectUtil.StringUsageTarget(this.myProject, findModel);
        ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).getFindUsagesManager().addToHistory(usageTarget);
        manager.searchAndShowUsages(new UsageTarget[]{usageTarget}, () -> processor2 -> {
            this.myIsFindInProgress = true;
            try {
                Processor consumer = info -> {
                    Usage usage = (Usage)UsageInfo2UsageAdapter.CONVERTER.fun(info);
                    usage.getPresentation().getIcon();
                    return processor2.process((Object)usage);
                };
                FindInProjectUtil.findUsages(findModelCopy, this.myProject, (Processor<UsageInfo>)consumer, processPresentation);
            }
            finally {
                this.myIsFindInProgress = false;
            }
        }, processPresentation, presentation, null);
    }

    public boolean isWorkInProgress() {
        return this.myIsFindInProgress;
    }

    public boolean isEnabled() {
        return !this.myIsFindInProgress && !ReplaceInProjectManager.getInstance(this.myProject).isWorkInProgress();
    }
}

