/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindPopupDirectoryChooser;
import com.intellij.find.impl.FindPopupPanel;
import com.intellij.find.impl.FindPopupScopeUI;
import com.intellij.find.impl.FindUIHelper;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindPopupScopeUIImpl
implements FindPopupScopeUI {
    private final FindPopupScopeUI.ScopeType PROJECT;
    private final FindPopupScopeUI.ScopeType MODULE;
    private final FindPopupScopeUI.ScopeType DIRECTORY;
    private final FindPopupScopeUI.ScopeType SCOPE;
    @NotNull
    private final FindUIHelper myHelper;
    @NotNull
    private final Project myProject;
    @NotNull
    private final FindPopupPanel myFindPopupPanel;
    @NotNull
    private final Pair[] myComponents;
    private ComboBox<String> myModuleComboBox;
    private FindPopupDirectoryChooser myDirectoryChooser;
    private ScopeChooserCombo myScopeCombo;

    public FindPopupScopeUIImpl(@NotNull FindPopupPanel panel2) {
        if (panel2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/find/impl/FindPopupScopeUIImpl", "<init>"));
        }
        this.PROJECT = new FindPopupScopeUI.ScopeType("Project", FindBundle.message("find.popup.scope.project", new Object[0]), EmptyIcon.ICON_0);
        this.MODULE = new FindPopupScopeUI.ScopeType("Module", FindBundle.message("find.popup.scope.module", new Object[0]), EmptyIcon.ICON_0);
        this.DIRECTORY = new FindPopupScopeUI.ScopeType("Directory", FindBundle.message("find.popup.scope.directory", new Object[0]), EmptyIcon.ICON_0);
        this.SCOPE = new FindPopupScopeUI.ScopeType("Scope", FindBundle.message("find.popup.scope.scope", new Object[0]), EmptyIcon.ICON_0);
        this.myHelper = panel2.getHelper();
        this.myProject = panel2.getProject();
        this.myFindPopupPanel = panel2;
        this.initComponents();
        this.myComponents = new Pair[]{new Pair((Object)this.PROJECT, (Object)new JLabel()), new Pair((Object)this.MODULE, (Object)FindPopupScopeUIImpl.shrink(this.myModuleComboBox)), new Pair((Object)this.DIRECTORY, (Object)this.myDirectoryChooser), new Pair((Object)this.SCOPE, (Object)FindPopupScopeUIImpl.shrink((JComponent)((Object)this.myScopeCombo)))};
    }

    public void initComponents() {
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        Object[] names = new String[modules.length];
        for (int i2 = 0; i2 < modules.length; ++i2) {
            names[i2] = modules[i2].getName();
        }
        Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
        this.myModuleComboBox = new ComboBox(names);
        SwingHelper.setLongestAsPrototype(this.myModuleComboBox, Arrays.asList(names));
        if (this.myModuleComboBox.getPrototypeDisplayValue() != null) {
            this.myModuleComboBox.setMinLength(((String)this.myModuleComboBox.getPrototypeDisplayValue()).length());
        }
        ActionListener restartSearchListener = e -> this.scheduleResultsUpdate();
        this.myModuleComboBox.addActionListener(restartSearchListener);
        this.myDirectoryChooser = new FindPopupDirectoryChooser(this.myFindPopupPanel);
        this.myScopeCombo = new ScopeChooserCombo();
        this.myScopeCombo.init(this.myProject, true, true, FindSettings.getInstance().getDefaultScopeName(), new Condition<ScopeDescriptor>(){
            final String moduleFilesScopeName;
            {
                String moduleScopeName = PsiBundle.message((String)"search.scope.module", (Object[])new Object[]{""});
                int ind = moduleScopeName.indexOf(32);
                this.moduleFilesScopeName = moduleScopeName.substring(0, ind + 1);
            }

            public boolean value(ScopeDescriptor descriptor) {
                String display = descriptor.getDisplay();
                return !display.startsWith(this.moduleFilesScopeName);
            }
        });
        this.myScopeCombo.setBrowseListener(new ScopeChooserCombo.BrowseListener(){
            private FindModel myModelSnapshot;

            @Override
            public void onBeforeBrowseStarted() {
                this.myModelSnapshot = FindPopupScopeUIImpl.this.myHelper.getModel();
                FindPopupScopeUIImpl.this.myFindPopupPanel.getCanClose().set(false);
            }

            @Override
            public void onAfterBrowseFinished() {
                if (this.myModelSnapshot != null) {
                    SearchScope scope = FindPopupScopeUIImpl.this.myScopeCombo.getSelectedScope();
                    if (scope != null) {
                        this.myModelSnapshot.setCustomScope(scope);
                    }
                    FindPopupScopeUIImpl.this.myFindPopupPanel.getCanClose().set(true);
                }
            }
        });
        this.myScopeCombo.getComboBox().addActionListener(restartSearchListener);
        Disposer.register((Disposable)this.myFindPopupPanel.getDisposable(), (Disposable)this.myScopeCombo);
    }

    @Override
    @NotNull
    public Pair<FindPopupScopeUI.ScopeType, JComponent>[] getComponents() {
        if (this.myComponents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupScopeUIImpl", "getComponents"));
        }
        return this.myComponents;
    }

    @Override
    public void applyTo(@NotNull FindSettings findSettings, @NotNull FindPopupScopeUI.ScopeType selectedScope) {
        if (findSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findSettings", "com/intellij/find/impl/FindPopupScopeUIImpl", "applyTo"));
        }
        if (selectedScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedScope", "com/intellij/find/impl/FindPopupScopeUIImpl", "applyTo"));
        }
        findSettings.setDefaultScopeName(this.myScopeCombo.getSelectedScopeName());
    }

    @Override
    public void applyTo(@NotNull FindModel findModel, @NotNull FindPopupScopeUI.ScopeType selectedScope) {
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindPopupScopeUIImpl", "applyTo"));
        }
        if (selectedScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedScope", "com/intellij/find/impl/FindPopupScopeUIImpl", "applyTo"));
        }
        if (selectedScope == this.PROJECT) {
            findModel.setProjectScope(true);
        } else if (selectedScope == this.DIRECTORY) {
            String directory = this.myDirectoryChooser.getDirectory();
            findModel.setDirectoryName(directory == null ? "" : directory);
        } else if (selectedScope == this.MODULE) {
            findModel.setModuleName((String)this.myModuleComboBox.getSelectedItem());
        } else if (selectedScope == this.SCOPE) {
            SearchScope selectedCustomScope = this.myScopeCombo.getSelectedScope();
            String customScopeName = selectedCustomScope == null ? null : selectedCustomScope.getDisplayName();
            findModel.setCustomScopeName(customScopeName);
            findModel.setCustomScope(selectedCustomScope);
            findModel.setCustomScope(true);
        }
    }

    @Override
    @Nullable
    public ValidationInfo validate(@NotNull FindModel model, FindPopupScopeUI.ScopeType selectedScope) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindPopupScopeUIImpl", "validate"));
        }
        if (selectedScope == this.DIRECTORY) {
            return this.myDirectoryChooser.validate(model);
        }
        return null;
    }

    @Override
    public boolean hideAllPopups() {
        JComboBox[] candidates;
        for (JComboBox candidate : candidates = new JComboBox[]{this.myModuleComboBox, this.myScopeCombo.getComboBox(), this.myDirectoryChooser.getComboBox()}) {
            if (!candidate.isPopupVisible()) continue;
            candidate.hidePopup();
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public FindPopupScopeUI.ScopeType initByModel(@NotNull FindModel findModel) {
        FindPopupScopeUI.ScopeType selectedScope;
        Module module2;
        VirtualFile dir;
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/impl/FindPopupScopeUIImpl", "initByModel"));
        }
        this.myDirectoryChooser.initByModel(findModel);
        String dirName = findModel.getDirectoryName();
        if (!StringUtil.isEmptyOrSpaces((String)dirName) && (dir = LocalFileSystem.getInstance().findFileByPath(dirName)) != null && (module2 = ModuleUtilCore.findModuleForFile((VirtualFile)dir, (Project)this.myProject)) != null) {
            this.myModuleComboBox.setSelectedItem((Object)module2.getName());
        }
        if ((selectedScope = this.getScope(findModel)) == this.MODULE) {
            this.myModuleComboBox.setSelectedItem((Object)findModel.getModuleName());
        }
        FindPopupScopeUI.ScopeType scopeType = selectedScope;
        if (scopeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupScopeUIImpl", "initByModel"));
        }
        return scopeType;
    }

    private static JComponent shrink(JComponent toShrink) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)toShrink, "West");
        wrapper.add(Box.createHorizontalGlue(), "Center");
        return wrapper;
    }

    private void scheduleResultsUpdate() {
        this.myFindPopupPanel.scheduleResultsUpdate();
    }

    private FindPopupScopeUI.ScopeType getScope(FindModel model) {
        if (model.isCustomScope()) {
            return this.SCOPE;
        }
        if (model.isProjectScope()) {
            return this.PROJECT;
        }
        if (model.getDirectoryName() != null) {
            return this.DIRECTORY;
        }
        if (model.getModuleName() != null) {
            return this.MODULE;
        }
        return this.PROJECT;
    }
}

