/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.library.impl;

import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.frameworks.beans.ArtifactItem;
import com.intellij.framework.FrameworkAvailabilityCondition;
import com.intellij.framework.library.DownloadableLibraryDescription;
import com.intellij.framework.library.DownloadableLibraryFileDescription;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.framework.library.impl.DownloadableLibraryFileDescriptionImpl;
import com.intellij.framework.library.impl.FrameworkLibraryVersionImpl;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.download.impl.FileSetVersionsFetcherBase;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibraryVersionsFetcher
extends FileSetVersionsFetcherBase<FrameworkLibraryVersion, DownloadableLibraryFileDescription>
implements DownloadableLibraryDescription {
    public LibraryVersionsFetcher(@NotNull String groupId, @NotNull URL[] localUrls) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/framework/library/impl/LibraryVersionsFetcher", "<init>"));
        }
        if (localUrls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localUrls", "com/intellij/framework/library/impl/LibraryVersionsFetcher", "<init>"));
        }
        super(groupId, localUrls);
    }

    @Override
    protected FrameworkLibraryVersion createVersion(Artifact version, List<DownloadableLibraryFileDescription> files) {
        return new FrameworkLibraryVersionImpl(version.getName(), version.getVersion(), this.createAvailabilityCondition(version), files, this.myGroupId);
    }

    @NotNull
    protected FrameworkAvailabilityCondition createAvailabilityCondition(Artifact version) {
        FrameworkAvailabilityCondition frameworkAvailabilityCondition = FrameworkAvailabilityCondition.ALWAYS_TRUE;
        if (frameworkAvailabilityCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/library/impl/LibraryVersionsFetcher", "createAvailabilityCondition"));
        }
        return frameworkAvailabilityCondition;
    }

    @Override
    protected DownloadableLibraryFileDescription createFileDescription(ArtifactItem item, String url, String prefix) {
        String docUrl;
        String sourceUrl = item.getSourceUrl();
        if (sourceUrl != null) {
            sourceUrl = LibraryVersionsFetcher.prependPrefix(sourceUrl, prefix);
        }
        if ((docUrl = item.getDocUrl()) != null) {
            docUrl = LibraryVersionsFetcher.prependPrefix(docUrl, prefix);
        }
        String name2 = item.getName();
        return new DownloadableLibraryFileDescriptionImpl(url, FileUtil.getNameWithoutExtension((String)name2), FileUtilRt.getExtension((String)name2), sourceUrl, docUrl, item.isOptional());
    }
}

