/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.revisions;

import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Difference {
    private final boolean myIsFile;
    private final Entry myLeft;
    private final Entry myRight;

    public Difference(boolean isFile, Entry left, Entry right) {
        this.myIsFile = isFile;
        this.myLeft = left;
        this.myRight = right;
    }

    public boolean isFile() {
        return this.myIsFile;
    }

    public Entry getLeft() {
        return this.myLeft;
    }

    public Entry getRight() {
        return this.myRight;
    }

    public ContentRevision getLeftContentRevision(IdeaGateway gw) {
        return this.createContentRevision(this.getLeft(), gw);
    }

    public ContentRevision getRightContentRevision(IdeaGateway gw) {
        return this.createContentRevision(this.getRight(), gw);
    }

    private ContentRevision createContentRevision(final Entry e, final IdeaGateway gw) {
        if (e == null) {
            return null;
        }
        return new ByteBackedContentRevision(){

            @Nullable
            public String getContent() throws VcsException {
                if (e.isDirectory()) {
                    return null;
                }
                return e.getContent().getString(e, gw);
            }

            @Nullable
            public byte[] getContentAsBytes() throws VcsException {
                if (e.isDirectory()) {
                    return null;
                }
                return e.getContent().getBytes();
            }

            @NotNull
            public FilePath getFile() {
                FilePath filePath = VcsUtil.getFilePath((File)new File(e.getPath()), (boolean)e.isDirectory());
                if (filePath == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/core/revisions/Difference$1", "getFile"));
                }
                return filePath;
            }

            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                VcsRevisionNumber vcsRevisionNumber = VcsRevisionNumber.NULL;
                if (vcsRevisionNumber == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/history/core/revisions/Difference$1", "getRevisionNumber"));
                }
                return vcsRevisionNumber;
            }
        };
    }
}

