/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLineProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.CommandLineProcessor");

    private CommandLineProcessor() {
    }

    @Nullable
    private static Project doOpenFileOrProject(VirtualFile file2, String path) {
        if (ProjectKt.isValidProjectPath(path) || ProjectOpenProcessor.getImportProvider((VirtualFile)file2) != null) {
            Project project2 = ProjectUtil.openOrImport(path, null, true);
            if (project2 == null) {
                Messages.showErrorDialog((String)("Cannot open project '" + path + "'"), (String)"Cannot Open Project");
            }
            return project2;
        }
        return CommandLineProcessor.doOpenFile(file2, -1, false);
    }

    @Nullable
    private static Project doOpenFile(VirtualFile file2, int line, boolean tempProject) {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        if (projects.length == 0 || tempProject) {
            Project project2;
            EnumSet<PlatformProjectOpenProcessor.Option> options = EnumSet.noneOf(PlatformProjectOpenProcessor.Option.class);
            if (tempProject) {
                options.add(PlatformProjectOpenProcessor.Option.TEMP_PROJECT);
                options.add(PlatformProjectOpenProcessor.Option.FORCE_NEW_FRAME);
            }
            if ((project2 = PlatformProjectOpenProcessor.getInstance().doOpenProject(file2, null, line, options)) == null) {
                Messages.showErrorDialog((String)"No project found to open file in", (String)"Cannot Open File");
            }
            return project2;
        }
        NonProjectFileWritingAccessProvider.allowWriting(file2);
        Project project3 = CommandLineProcessor.findBestProject(file2, projects);
        (line > 0 ? new OpenFileDescriptor(project3, file2, line - 1, 0) : new OpenFileDescriptor(project3, file2)).navigate(true);
        return project3;
    }

    @NotNull
    private static Project findBestProject(VirtualFile file2, Project[] projects) {
        Project project2;
        for (Project project3 : projects) {
            if (!ProjectRootManager.getInstance((Project)project3).getFileIndex().isInContent(file2)) continue;
            Project project4 = project3;
            if (project4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/CommandLineProcessor", "findBestProject"));
            }
            return project4;
        }
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (frame != null && (project2 = frame.getProject()) != null) {
            Project project5 = project2;
            if (project5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/CommandLineProcessor", "findBestProject"));
            }
            return project5;
        }
        Project project6 = projects[0];
        if (project6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/CommandLineProcessor", "findBestProject"));
        }
        return project6;
    }

    @Nullable
    public static Project processExternalCommandLine(List<String> args, @Nullable String currentDirectory) {
        if (args.size() > 0) {
            LOG.info("External command line:");
            LOG.info("Dir: " + currentDirectory);
            for (String string : args) {
                LOG.info(string);
            }
        }
        LOG.info("-----");
        if (args.size() > 0) {
            String command = args.get(0);
            for (ApplicationStarter starter2 : (ApplicationStarter[])Extensions.getExtensions((ExtensionPointName)ApplicationStarter.EP_NAME)) {
                if (!command.equals(starter2.getCommandName()) || !(starter2 instanceof ApplicationStarterEx) || !((ApplicationStarterEx)starter2).canProcessExternalCommandLine()) continue;
                LOG.info("Processing command with " + starter2);
                ((ApplicationStarterEx)starter2).processExternalCommandLine(ArrayUtil.toStringArray(args), currentDirectory);
                return null;
            }
            if (command.startsWith("jetbrains://")) {
                try {
                    String string = URLDecoder.decode(command, "UTF-8");
                    JetBrainsProtocolHandler.processJetBrainsLauncherParameters((String)string);
                    ApplicationManager.getApplication().invokeLater(() -> JBProtocolCommand.handleCurrentCommand());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    LOG.error((Throwable)unsupportedEncodingException);
                }
                return null;
            }
        }
        Project lastOpenedProject = null;
        int n = -1;
        boolean tempProject = false;
        int argsSize = args.size();
        for (int i2 = 0; i2 < argsSize; ++i2) {
            int n2;
            String arg = args.get(i2);
            if (arg.equals("nosplash")) continue;
            if (arg.equals("-l") || arg.equals("--line")) {
                if (++i2 == args.size()) break;
                try {
                    n2 = Integer.parseInt(args.get(i2));
                }
                catch (NumberFormatException e) {
                    n2 = -1;
                }
                continue;
            }
            if (arg.equals("--temp-project")) {
                tempProject = true;
                continue;
            }
            if (StringUtil.isQuotedString((String)arg)) {
                arg = StringUtil.unquoteString((String)arg);
            }
            if (!new File(arg).isAbsolute()) {
                arg = currentDirectory != null ? new File(currentDirectory, arg).getAbsolutePath() : new File(arg).getAbsolutePath();
            }
            VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(arg);
            if (n2 != -1 || tempProject) {
                if (file2 != null && !file2.isDirectory()) {
                    lastOpenedProject = CommandLineProcessor.doOpenFile(file2, n2, tempProject);
                } else {
                    Messages.showErrorDialog((String)("Cannot find file '" + arg + "'"), (String)"Cannot Find File");
                }
            } else if (file2 != null) {
                lastOpenedProject = CommandLineProcessor.doOpenFileOrProject(file2, arg);
            } else {
                Messages.showErrorDialog((String)("Cannot find file '" + arg + "'"), (String)"Cannot Find File");
            }
            n2 = -1;
            tempProject = false;
        }
        return lastOpenedProject;
    }
}

