/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.util.PlatformModuleRendererFactory;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.FilePathSplittingPolicy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.io.File;
import java.util.LinkedList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;

class SearchEverywherePsiRenderer
extends PsiElementListCellRenderer<PsiElement> {
    private final JList myList;

    public SearchEverywherePsiRenderer(JList list2) {
        this.myList = list2;
        this.setFocusBorderEnabled(false);
        this.setLayout(new BorderLayout(){

            @Override
            public void layoutContainer(Container target2) {
                super.layoutContainer(target2);
                Component right = this.getLayoutComponent("East");
                Component left = this.getLayoutComponent("West");
                if (right != null && left != null && left.getBounds().x + left.getBounds().width > right.getBounds().x) {
                    Rectangle bounds = right.getBounds();
                    int newX = left.getBounds().x + left.getBounds().width;
                    right.setBounds(newX, bounds.y, bounds.width - (newX - bounds.x), bounds.height);
                }
            }
        });
    }

    @Override
    public String getElementText(PsiElement element) {
        VirtualFile file2;
        Object object = element instanceof PsiFile ? PsiUtilCore.getVirtualFile((PsiElement)element) : (file2 = element instanceof VirtualFile ? (VirtualFile)element : null);
        if (file2 != null) {
            return EditorTabbedContainer.calcTabTitle(element.getProject(), file2);
        }
        String name2 = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : null;
        return StringUtil.notNullize((String)name2, (String)"<unnamed>");
    }

    @Override
    protected String getContainerText(PsiElement element, String name2) {
        if (element instanceof PsiFileSystemItem) {
            VirtualFile parent;
            VirtualFile file2 = ((PsiFileSystemItem)element).getVirtualFile();
            VirtualFile virtualFile = parent = file2 == null ? null : file2.getParent();
            if (parent == null) {
                if (file2 != null) {
                    String presentableUrl = file2.getPresentableUrl();
                    return FileUtil.getLocationRelativeToUserHome((String)presentableUrl);
                }
                return null;
            }
            String relativePath = GotoFileCellRenderer.getRelativePath(parent, element.getProject());
            if (relativePath == null) {
                return "( " + File.separator + " )";
            }
            int width = this.myList.getWidth();
            if (width == 0) {
                width += 800;
            }
            String path = FilePathSplittingPolicy.SPLIT_BY_SEPARATOR.getOptimalTextForComponent(name2, new File(relativePath), (JComponent)this, width - this.myRightComponentWidth - 16 - 10);
            return "(" + path + ")";
        }
        return this.getSymbolContainerText(name2, element);
    }

    private String getSymbolContainerText(String name2, PsiElement element) {
        boolean in;
        String text2 = SymbolPresentationUtil.getSymbolContainerText(element);
        if (this.myList.getWidth() == 0) {
            return text2;
        }
        if (text2 == null) {
            return null;
        }
        if (text2.startsWith("(") && text2.endsWith(")")) {
            text2 = text2.substring(1, text2.length() - 1);
        }
        if (in = text2.startsWith("in ")) {
            text2 = text2.substring(3);
        }
        FontMetrics fm = this.myList.getFontMetrics(this.myList.getFont());
        int maxWidth = this.myList.getWidth() - fm.stringWidth(name2) - 16 - this.myRightComponentWidth - 20;
        String left = in ? "(in " : "(";
        String right = ")";
        if (fm.stringWidth(left + text2 + right) < maxWidth) {
            return left + text2 + right;
        }
        String separator = text2.contains(File.separator) ? File.separator : ".";
        LinkedList<String> parts = new LinkedList<String>(StringUtil.split((String)text2, (String)separator));
        while (parts.size() > 1) {
            int index = parts.size() / 2 - 1;
            parts.remove(index);
            if (fm.stringWidth(StringUtil.join(parts, (String)separator) + "...") >= maxWidth) continue;
            parts.add(index, "...");
            return left + StringUtil.join(parts, (String)separator) + right;
        }
        return left + "..." + right;
    }

    @Override
    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list2, Object value2, int index, boolean selected, boolean hasFocus) {
        if (!(value2 instanceof NavigationItem)) {
            return false;
        }
        NavigationItem item = (NavigationItem)value2;
        TextAttributes attributes = this.getNavigationItemAttributes(item);
        SimpleTextAttributes nameAttributes = attributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes) : null;
        Color color = list2.getForeground();
        if (nameAttributes == null) {
            nameAttributes = new SimpleTextAttributes(0, color);
        }
        renderer.append(item + " ", nameAttributes);
        ItemPresentation itemPresentation = item.getPresentation();
        assert (itemPresentation != null);
        renderer.setIcon(itemPresentation.getIcon(true));
        String locationString = itemPresentation.getLocationString();
        if (!StringUtil.isEmpty((String)locationString)) {
            renderer.append(locationString, new SimpleTextAttributes(0, (Color)JBColor.GRAY));
        }
        return true;
    }

    @Override
    protected DefaultListCellRenderer getRightCellRenderer(Object value2) {
        DefaultListCellRenderer rightRenderer = super.getRightCellRenderer(value2);
        if (rightRenderer instanceof PlatformModuleRendererFactory.PlatformModuleRenderer) {
            return null;
        }
        return rightRenderer;
    }

    @Override
    protected int getIconFlags() {
        return 2;
    }
}

