/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Trinity;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SpeedSearchComparator;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateKindCombo
extends ComboboxWithBrowseButton {
    public TemplateKindCombo() {
        this.getComboBox().setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list2, Object value2, int index, boolean selected, boolean cellHasFocus) {
                if (value2 instanceof Trinity) {
                    this.setText((String)((Trinity)value2).first);
                    this.setIcon((Icon)((Trinity)value2).second);
                }
            }
        });
        new ComboboxSpeedSearch(this.getComboBox()){

            @Override
            protected String getElementText(Object element) {
                if (element instanceof Trinity) {
                    return (String)((Trinity)element).first;
                }
                return null;
            }
        }.setComparator(new SpeedSearchComparator(true));
        this.setButtonListener(null);
    }

    public void addItem(@NotNull String presentableName, @Nullable Icon icon, @NotNull String templateName) {
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/ide/actions/TemplateKindCombo", "addItem"));
        }
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/ide/actions/TemplateKindCombo", "addItem"));
        }
        this.getComboBox().addItem(new Trinity((Object)presentableName, (Object)icon, (Object)templateName));
    }

    @NotNull
    public String getSelectedName() {
        Trinity trinity = (Trinity)this.getComboBox().getSelectedItem();
        if (trinity == null) {
            if ("yet_unknown" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/TemplateKindCombo", "getSelectedName"));
            }
            return "yet_unknown";
        }
        String string = (String)trinity.third;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/TemplateKindCombo", "getSelectedName"));
        }
        return string;
    }

    public void setSelectedName(@Nullable String name2) {
        if (name2 == null) {
            return;
        }
        ComboBoxModel model = this.getComboBox().getModel();
        int n = model.getSize();
        for (int i2 = 0; i2 < n; ++i2) {
            Trinity trinity = (Trinity)model.getElementAt(i2);
            if (!name2.equals(trinity.third)) continue;
            this.getComboBox().setSelectedItem(trinity);
            return;
        }
    }

    public void registerUpDownHint(JComponent component) {
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                if (e.getInputEvent() instanceof KeyEvent) {
                    int code2 = ((KeyEvent)e.getInputEvent()).getKeyCode();
                    TemplateKindCombo.this.scrollBy(code2 == 40 ? 1 : (code2 == 38 ? -1 : 0));
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Integer[]{38, 40}), component);
    }

    private void scrollBy(int delta) {
        int size = this.getComboBox().getModel().getSize();
        if (delta == 0 || size == 0) {
            return;
        }
        int next = this.getComboBox().getSelectedIndex() + delta;
        if (next < 0 || next >= size) {
            if (!UISettings.getInstance().getCycleScrolling()) {
                return;
            }
            next = (next + size) % size;
        }
        this.getComboBox().setSelectedIndex(next);
    }

    public void setButtonListener(@Nullable ActionListener listener2) {
        this.getButton().setVisible(listener2 != null);
        if (listener2 != null) {
            this.addActionListener(listener2);
        }
    }

    public void clear() {
        this.getComboBox().removeAllItems();
    }
}

