/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.actions.BookmarksAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.SystemInfo;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;

class EditBookmarkDescriptionAction
extends DumbAwareAction {
    private final JList myList;
    private final Project myProject;
    private JBPopup myPopup;

    EditBookmarkDescriptionAction(Project project2, JList list2) {
        super(IdeBundle.message((String)"action.bookmark.edit.description", (Object[])new Object[0]), IdeBundle.message((String)"action.bookmark.edit.description.description", (Object[])new Object[0]), AllIcons.Actions.Edit);
        this.setEnabledInModalContext(true);
        this.myProject = project2;
        this.myList = list2;
        this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(SystemInfo.isMac ? "meta ENTER" : "control ENTER")), list2);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(this.myPopup != null && this.myPopup.isVisible() && BookmarksAction.getSelectedBookmarks(this.myList).size() == 1);
    }

    public void actionPerformed(AnActionEvent e) {
        if (this.myPopup == null || !this.myPopup.isVisible()) {
            return;
        }
        Bookmark bookmark = BookmarksAction.getSelectedBookmarks(this.myList).get(0);
        this.myPopup.setUiVisible(false);
        BookmarkManager.getInstance(this.myProject).editDescription(bookmark);
        if (this.myPopup != null && !this.myPopup.isDisposed()) {
            this.myPopup.setUiVisible(true);
            JComponent content = this.myPopup.getContent();
            if (content != null) {
                this.myPopup.setSize(content.getPreferredSize());
            }
        }
    }

    public void setPopup(JBPopup popup) {
        this.myPopup = popup;
    }
}

