/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.OpenInBrowserRequestKt;
import com.intellij.ide.browsers.WebBrowserUrlProvider;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserAction;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0010\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/browsers/actions/SelectInDefaultBrowserTarget;", "Lcom/intellij/ide/SelectInTarget;", "()V", "canSelect", "", "context", "Lcom/intellij/ide/SelectInContext;", "getWeight", "", "selectIn", "", "requestFocus", "toString", "", "kotlin.jvm.PlatformType", "xml"})
public final class SelectInDefaultBrowserTarget
implements SelectInTarget {
    public boolean canSelect(@NotNull SelectInContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSelectorInFile();
        if (!(object instanceof PsiElement)) {
            object = null;
        }
        PsiElement psiElement = (PsiElement)object;
        if (psiElement == null) {
            return false;
        }
        PsiElement selectorInFile = psiElement;
        OpenInBrowserRequest openInBrowserRequest = OpenInBrowserRequestKt.createOpenInBrowserRequest((PsiElement)selectorInFile);
        if (openInBrowserRequest == null) {
            return false;
        }
        OpenInBrowserRequest request = openInBrowserRequest;
        WebBrowserUrlProvider urlProvider = WebBrowserServiceImpl.Companion.getProvider(request);
        if (urlProvider == null) {
            VirtualFile virtualFile = request.getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            VirtualFile virtualFile2 = virtualFile;
            return virtualFile2 instanceof HttpVirtualFile || HtmlUtil.isHtmlFile((PsiElement)request.getFile()) && !(virtualFile2 instanceof LightVirtualFile);
        }
        return true;
    }

    public String toString() {
        return XmlBundle.message((String)"browser.select.in.default.name", (Object[])new Object[0]);
    }

    public void selectIn(@NotNull SelectInContext context, boolean requestFocus) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getSelectorInFile();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
        }
        BaseOpenInBrowserAction.Companion.open(OpenInBrowserRequestKt.createOpenInBrowserRequest((PsiElement)((PsiElement)object)), false, null);
    }

    public float getWeight() {
        return 9.5f;
    }
}

