/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.CommonBundle;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class CustomizeUIThemeStepPanel
extends AbstractCustomizeWizardStep {
    protected static final ThemeInfo AQUA = new ThemeInfo("Default", "Aqua", "com.apple.laf.AquaLookAndFeel");
    protected static final ThemeInfo DARCULA = new ThemeInfo("Darcula", "Darcula", DarculaLaf.class.getName());
    protected static final ThemeInfo INTELLIJ = new ThemeInfo(LafManagerImpl.useIntelliJInsteadOfAqua() ? "Default" : "IntelliJ", "IntelliJ", IntelliJLaf.class.getName());
    protected static final ThemeInfo ALLOY = new ThemeInfo("Alloy. IDEA Theme", "Alloy", "com.incors.plaf.alloy.AlloyIdea");
    protected static final ThemeInfo GTK = new ThemeInfo("GTK+", "GTK", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
    private boolean myInitial = true;
    private boolean myColumnMode;
    private JLabel myPreviewLabel;
    private Set<ThemeInfo> myThemes = new LinkedHashSet<ThemeInfo>();

    public CustomizeUIThemeStepPanel() {
        this.setLayout(CustomizeUIThemeStepPanel.createSmallBorderLayout());
        IconLoader.activate();
        this.initThemes(this.myThemes);
        this.myColumnMode = this.myThemes.size() > 2;
        JPanel buttonsPanel = new JPanel(new GridLayout(this.myColumnMode ? this.myThemes.size() : 1, this.myColumnMode ? 1 : this.myThemes.size(), 5, 5));
        ButtonGroup group = new ButtonGroup();
        ThemeInfo myDefaultTheme = this.getDefaultTheme();
        for (ThemeInfo theme : this.myThemes) {
            JRadioButton radioButton = new JRadioButton(theme.name, myDefaultTheme == theme);
            radioButton.setOpaque(false);
            JPanel panel2 = CustomizeUIThemeStepPanel.createBigButtonPanel(CustomizeUIThemeStepPanel.createSmallBorderLayout(), radioButton, () -> {
                this.applyLaf(theme, this);
                theme.apply();
            });
            panel2.setBorder(CustomizeUIThemeStepPanel.createSmallEmptyBorder());
            panel2.add((Component)radioButton, this.myColumnMode ? "West" : "North");
            Icon icon = theme.getIcon();
            int maxThumbnailSize = 400 / this.myThemes.size();
            JLabel label = new JLabel(this.myColumnMode ? IconUtil.scale((Icon)IconUtil.cropIcon((Icon)icon, (int)(maxThumbnailSize * 2), (int)(maxThumbnailSize * 2)), (double)0.5) : icon);
            label.setVerticalAlignment(1);
            label.setHorizontalAlignment(4);
            panel2.add((Component)label, "Center");
            group.add(radioButton);
            buttonsPanel.add(panel2);
        }
        this.add((Component)buttonsPanel, "Center");
        this.myPreviewLabel = new JLabel();
        this.myPreviewLabel.setHorizontalAlignment(this.myColumnMode ? 2 : 0);
        this.myPreviewLabel.setVerticalAlignment(0);
        if (this.myColumnMode) {
            this.add((Component)buttonsPanel, "West");
            JPanel wrapperPanel = new JPanel(new FlowLayout(0, 0, 0));
            wrapperPanel.add(this.myPreviewLabel);
            this.add((Component)wrapperPanel, "Center");
        }
        SwingUtilities.invokeLater(() -> this.applyLaf(myDefaultTheme, this));
        this.myInitial = false;
    }

    protected void initThemes(Collection<ThemeInfo> result2) {
        if (SystemInfo.isMac) {
            result2.add(CustomizeUIThemeStepPanel.getDefaultLafOnMac());
            result2.add(DARCULA);
        } else if (SystemInfo.isWindows) {
            result2.add(INTELLIJ);
            result2.add(DARCULA);
        } else {
            result2.add(INTELLIJ);
            result2.add(DARCULA);
            result2.add(GTK);
        }
    }

    @NotNull
    protected static ThemeInfo getDefaultLafOnMac() {
        ThemeInfo themeInfo = LafManagerImpl.useIntelliJInsteadOfAqua() ? INTELLIJ : AQUA;
        if (themeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/customize/CustomizeUIThemeStepPanel", "getDefaultLafOnMac"));
        }
        return themeInfo;
    }

    @NotNull
    private ThemeInfo getDefaultTheme() {
        ThemeInfo result2;
        String lafClassName;
        if (ApplicationManager.getApplication() != null) {
            if (UIUtil.isUnderAquaLookAndFeel()) {
                ThemeInfo themeInfo = AQUA;
                if (themeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/customize/CustomizeUIThemeStepPanel", "getDefaultTheme"));
                }
                return themeInfo;
            }
            if (UIUtil.isUnderDarcula()) {
                ThemeInfo themeInfo = DARCULA;
                if (themeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/customize/CustomizeUIThemeStepPanel", "getDefaultTheme"));
                }
                return themeInfo;
            }
            if (UIUtil.isUnderGTKLookAndFeel()) {
                ThemeInfo themeInfo = GTK;
                if (themeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/customize/CustomizeUIThemeStepPanel", "getDefaultTheme"));
                }
                return themeInfo;
            }
            ThemeInfo themeInfo = INTELLIJ;
            if (themeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/customize/CustomizeUIThemeStepPanel", "getDefaultTheme"));
            }
            return themeInfo;
        }
        CloudConfigProvider provider = CloudConfigProvider.getProvider();
        if (provider != null && (lafClassName = provider.getLafClassName()) != null && (result2 = (ThemeInfo)ContainerUtil.find(this.myThemes, theme -> lafClassName.equals(theme.laf))) != null) {
            ThemeInfo themeInfo = result2;
            if (themeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/customize/CustomizeUIThemeStepPanel", "getDefaultTheme"));
            }
            return themeInfo;
        }
        ThemeInfo themeInfo = this.myThemes.iterator().next();
        if (themeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/customize/CustomizeUIThemeStepPanel", "getDefaultTheme"));
        }
        return themeInfo;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width += 30;
        return size;
    }

    @Override
    public String getTitle() {
        return "UI Themes";
    }

    @Override
    public String getHTMLHeader() {
        return "<html><body><h2>Set UI theme</h2>&nbsp;</body></html>";
    }

    @Override
    public String getHTMLFooter() {
        return "UI theme can be changed later in " + CommonBundle.settingsTitle() + " | " + OptionsBundle.message((String)"configurable.group.appearance.settings.display.name", (Object[])new Object[0]) + " | Appearance";
    }

    private void applyLaf(ThemeInfo theme, Component component) {
        UIManager.LookAndFeelInfo info = new UIManager.LookAndFeelInfo(theme.name, theme.laf);
        try {
            Window window;
            boolean wasUnderDarcula = UIUtil.isUnderDarcula();
            UIManager.setLookAndFeel(info.getClassName());
            String className = info.getClassName();
            if (!this.myInitial) {
                WelcomeWizardUtil.setWizardLAF((String)className);
            }
            if ((window = SwingUtilities.getWindowAncestor(component)) != null) {
                if (SystemInfo.isMac) {
                    window.setBackground(new Color(UIUtil.getPanelBackground().getRGB()));
                }
                SwingUtilities.updateComponentTreeUI(window);
            }
            if (ApplicationManager.getApplication() != null) {
                LafManager lafManager = LafManager.getInstance();
                lafManager.setCurrentLookAndFeel(info);
                if (lafManager instanceof LafManagerImpl) {
                    ((LafManagerImpl)lafManager).updateWizardLAF(wasUnderDarcula);
                } else {
                    lafManager.updateUI();
                }
            }
            if (this.myColumnMode) {
                this.myPreviewLabel.setIcon(theme.getIcon());
                this.myPreviewLabel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Label.disabledForeground")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class ThemeInfo {
        public final String name;
        public final String previewFileName;
        public final String laf;
        private Icon icon;

        public ThemeInfo(String name2, String previewFileName, String laf) {
            this.name = name2;
            this.previewFileName = SystemInfo.isMac && "IntelliJ".equals(previewFileName) ? "Aqua" : previewFileName;
            this.laf = laf;
        }

        private Icon getIcon() {
            if (this.icon == null) {
                String selector2 = SystemInfo.isMac ? "OSX" : (SystemInfo.isWindows ? "Windows" : "Linux");
                this.icon = IconLoader.getIcon((String)("/lafs/" + selector2 + this.previewFileName + ".png"));
            }
            return this.icon;
        }

        public void apply() {
        }
    }
}

