/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.AbstractUrlFavoriteAdapter;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListener;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesViewSettings;
import com.intellij.ide.favoritesTreeView.TaskDefaultFavoriteListProvider;
import com.intellij.ide.favoritesTreeView.actions.AddToFavoritesAction;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.projectView.impl.DirectoryUrl;
import com.intellij.ide.projectView.impl.LibraryModuleGroupUrl;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ModuleGroupUrl;
import com.intellij.ide.projectView.impl.ModuleUrl;
import com.intellij.ide.projectView.impl.NamedLibraryUrl;
import com.intellij.ide.projectView.impl.PsiFileUrl;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesManager
implements ProjectComponent,
JDOMExternalizable {
    private final Map<String, List<TreeItem<Pair<AbstractUrl, String>>>> myName2FavoritesRoots = new TreeMap<String, List<TreeItem<Pair<AbstractUrl, String>>>>();
    private final List<String> myFavoritesRootsOrder = new ArrayList<String>();
    private final Map<String, String> myDescriptions = new HashMap<String, String>();
    private final Project myProject;
    private final List<FavoritesListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final FavoritesViewSettings myViewSettings = new FavoritesViewSettings();
    private Map<String, FavoritesListProvider> myProviders;
    @NonNls
    private static final String CLASS_NAME = "klass";
    @NonNls
    private static final String FAVORITES_ROOT = "favorite_root";
    @NonNls
    private static final String ELEMENT_FAVORITES_LIST = "favorites_list";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    private static final ArrayList<AbstractUrl> ourAbstractUrlProviders = new ArrayList();
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";
    @NonNls
    private static final String ATTRIBUTE_URL = "url";
    @NonNls
    private static final String ATTRIBUTE_MODULE = "module";

    @NotNull
    private Map<String, FavoritesListProvider> getProviders() {
        if (this.myProviders != null) {
            Map<String, FavoritesListProvider> map2 = this.myProviders;
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesManager", "getProviders"));
            }
            return map2;
        }
        this.myProviders = new HashMap<String, FavoritesListProvider>();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            FavoritesListProvider[] providers2;
            for (FavoritesListProvider provider : providers2 = (FavoritesListProvider[])Extensions.getExtensions(FavoritesListProvider.EP_NAME, (AreaInstance)this.myProject)) {
                this.myProviders.put(provider.getListName(this.myProject), provider);
            }
            MyRootsChangeAdapter myPsiTreeChangeAdapter = new MyRootsChangeAdapter();
            PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)myPsiTreeChangeAdapter, (Disposable)this.myProject);
            if (this.myName2FavoritesRoots.isEmpty()) {
                this.myDescriptions.put(this.myProject.getName(), "auto-added");
                this.createNewList(this.myProject.getName());
            }
        }
        Map<String, FavoritesListProvider> map3 = this.myProviders;
        if (map3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesManager", "getProviders"));
        }
        return map3;
    }

    private void rootsChanged() {
        for (FavoritesListener listener2 : this.myListeners) {
            listener2.rootsChanged();
        }
    }

    private void listAdded(String listName) {
        for (FavoritesListener listener2 : this.myListeners) {
            listener2.listAdded(listName);
        }
    }

    private void listRemoved(String listName) {
        for (FavoritesListener listener2 : this.myListeners) {
            listener2.listRemoved(listName);
        }
    }

    public void renameList(final Project project2, @NotNull String listName) {
        if (listName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listName", "com/intellij/ide/favoritesTreeView/FavoritesManager", "renameList"));
        }
        String newName = Messages.showInputDialog((Project)project2, (String)IdeBundle.message((String)"prompt.input.favorites.list.new.name", (Object[])new Object[]{listName}), (String)IdeBundle.message((String)"title.rename.favorites.list", (Object[])new Object[0]), (Icon)Messages.getInformationIcon(), (String)listName, (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return inputString != null && inputString.trim().length() > 0;
            }

            public boolean canClose(String inputString) {
                inputString = inputString.trim();
                if (FavoritesManager.this.myName2FavoritesRoots.keySet().contains(inputString) || FavoritesManager.this.getProviders().keySet().contains(inputString)) {
                    Messages.showErrorDialog((Project)project2, (String)IdeBundle.message((String)"error.favorites.list.already.exists", (Object[])new Object[]{inputString.trim()}), (String)IdeBundle.message((String)"title.unable.to.add.favorites.list", (Object[])new Object[0]));
                    return false;
                }
                return !inputString.isEmpty();
            }
        });
        if (newName != null && this.renameFavoritesList(listName, newName)) {
            this.rootsChanged();
        }
    }

    public void addFavoritesListener(FavoritesListener listener2) {
        this.myListeners.add(listener2);
        listener2.rootsChanged();
    }

    public void addFavoritesListener(final FavoritesListener listener2, @NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ide/favoritesTreeView/FavoritesManager", "addFavoritesListener"));
        }
        this.myListeners.add(listener2);
        listener2.rootsChanged();
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                FavoritesManager.this.removeFavoritesListener(listener2);
            }
        });
    }

    public void removeFavoritesListener(FavoritesListener listener2) {
        this.myListeners.remove(listener2);
    }

    List<AbstractTreeNode> createRootNodes() {
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        for (String listName : this.myFavoritesRootsOrder) {
            result2.add(new FavoritesListNode(this.myProject, listName, this.myDescriptions.get(listName)));
        }
        ArrayList<FavoritesListProvider> providers2 = new ArrayList<FavoritesListProvider>(this.getProviders().values());
        Collections.sort(providers2);
        for (FavoritesListProvider provider : providers2) {
            result2.add(provider.createFavoriteListNode(this.myProject));
        }
        return result2;
    }

    public static FavoritesManager getInstance(Project project2) {
        return (FavoritesManager)project2.getComponent(FavoritesManager.class);
    }

    public FavoritesManager(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public List<String> getAvailableFavoritesListNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.myFavoritesRootsOrder);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesManager", "getAvailableFavoritesListNames"));
        }
        return arrayList;
    }

    public synchronized void createNewList(@NotNull String listName) {
        if (listName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listName", "com/intellij/ide/favoritesTreeView/FavoritesManager", "createNewList"));
        }
        this.myName2FavoritesRoots.put(listName, new ArrayList());
        this.myFavoritesRootsOrder.add(listName);
        this.listAdded(listName);
    }

    public synchronized void fireListeners(@NotNull String listName) {
        if (listName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listName", "com/intellij/ide/favoritesTreeView/FavoritesManager", "fireListeners"));
        }
        this.rootsChanged();
    }

    public FavoritesViewSettings getViewSettings() {
        return this.myViewSettings;
    }

    public synchronized boolean removeFavoritesList(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "removeFavoritesList"));
        }
        boolean result2 = this.myName2FavoritesRoots.remove(name2) != null;
        this.myFavoritesRootsOrder.remove(name2);
        this.myDescriptions.remove(name2);
        this.listRemoved(name2);
        return result2;
    }

    @NotNull
    public List<TreeItem<Pair<AbstractUrl, String>>> getFavoritesListRootUrls(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "getFavoritesListRootUrls"));
        }
        ArrayList<TreeItem<Pair<AbstractUrl, String>>> pairs = this.myName2FavoritesRoots.get(name2);
        ArrayList<TreeItem<Pair<AbstractUrl, String>>> arrayList = pairs == null ? new ArrayList<TreeItem<Pair<AbstractUrl, String>>>() : pairs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesManager", "getFavoritesListRootUrls"));
        }
        return arrayList;
    }

    public synchronized boolean addRoots(@NotNull String name2, Module moduleContext, @NotNull Object elements) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "addRoots"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/favoritesTreeView/FavoritesManager", "addRoots"));
        }
        Collection<AbstractTreeNode> nodes = AddToFavoritesAction.createNodes(this.myProject, moduleContext, elements, true, this.getViewSettings());
        return !nodes.isEmpty() && this.addRoots(name2, nodes);
    }

    public synchronized Comparator<FavoritesTreeNodeDescriptor> getCustomComparator(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "getCustomComparator"));
        }
        return this.getProviders().get(name2);
    }

    private Pair<AbstractUrl, String> createPairForNode(AbstractTreeNode node) {
        String className = node.getClass().getName();
        Object value2 = node.getValue();
        AbstractUrl url = FavoritesManager.createUrlByElement(value2, this.myProject);
        if (url == null) {
            return null;
        }
        return Pair.create((Object)url, (Object)className);
    }

    public boolean addRoots(String name2, Collection<AbstractTreeNode> nodes) {
        List<TreeItem<Pair<AbstractUrl, String>>> list2 = this.getFavoritesListRootUrls(name2);
        HashSet<Object> set2 = new HashSet<Object>(ContainerUtil.map(list2, item -> (AbstractUrl)((Pair)item.getData()).getFirst()));
        for (AbstractTreeNode node : nodes) {
            Pair<AbstractUrl, String> pair2 = this.createPairForNode(node);
            if (pair2 == null || set2.contains(pair2.getFirst())) continue;
            TreeItem treeItem = new TreeItem(pair2);
            list2.add((TreeItem<Pair<AbstractUrl, String>>)treeItem);
            set2.add(pair2.getFirst());
            this.appendChildNodes(node, (TreeItem<Pair<AbstractUrl, String>>)treeItem);
        }
        this.rootsChanged();
        return true;
    }

    public boolean canAddRoots(@NotNull String name2, @NotNull Collection<AbstractTreeNode> nodes) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "canAddRoots"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/ide/favoritesTreeView/FavoritesManager", "canAddRoots"));
        }
        List<TreeItem<Pair<AbstractUrl, String>>> list2 = this.getFavoritesListRootUrls(name2);
        HashSet set2 = new HashSet(ContainerUtil.map(list2, item -> (AbstractUrl)((Pair)item.getData()).getFirst()));
        for (AbstractTreeNode node : nodes) {
            Pair<AbstractUrl, String> pair2 = this.createPairForNode(node);
            if (pair2 == null || set2.contains(pair2.getFirst())) continue;
            return true;
        }
        return false;
    }

    private void appendChildNodes(AbstractTreeNode node, TreeItem<Pair<AbstractUrl, String>> treeItem) {
        Collection children2 = node.getChildren();
        for (AbstractTreeNode child : children2) {
            TreeItem childTreeItem = new TreeItem(this.createPairForNode(child));
            treeItem.addChild(childTreeItem);
            this.appendChildNodes(child, (TreeItem<Pair<AbstractUrl, String>>)childTreeItem);
        }
    }

    private <T> boolean findListToRemoveFrom(@NotNull String name2, @NotNull List<T> elements, Convertor<T, AbstractUrl> convertor) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "findListToRemoveFrom"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/favoritesTreeView/FavoritesManager", "findListToRemoveFrom"));
        }
        List list2 = this.getFavoritesListRootUrls(name2);
        if (elements.size() > 1) {
            List<T> sublist = elements.subList(0, elements.size() - 1);
            for (T obj : sublist) {
                AbstractUrl objUrl = (AbstractUrl)convertor.convert(obj);
                TreeItem<Pair<AbstractUrl, String>> item = FavoritesManager.findNextItem(objUrl, list2);
                if (item == null || item.getChildren() == null) {
                    return false;
                }
                list2 = item.getChildren();
            }
        }
        TreeItem found = null;
        AbstractUrl url = (AbstractUrl)convertor.convert(elements.get(elements.size() - 1));
        if (url == null) {
            return false;
        }
        for (TreeItem pair2 : list2) {
            if (!url.equals(((Pair)pair2.getData()).getFirst())) continue;
            found = pair2;
            break;
        }
        if (found != null) {
            list2.remove(found);
            this.rootsChanged();
            return true;
        }
        return false;
    }

    public synchronized boolean removeRoot(@NotNull String name2, @NotNull List<AbstractTreeNode> elements) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "removeRoot"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/favoritesTreeView/FavoritesManager", "removeRoot"));
        }
        Convertor convertor = obj -> FavoritesManager.createUrlByElement(obj.getValue(), this.myProject);
        boolean result2 = true;
        for (AbstractTreeNode element : elements) {
            List<AbstractTreeNode> path = TaskDefaultFavoriteListProvider.getPathToUsualNode(element);
            result2 &= this.findListToRemoveFrom(name2, path.subList(1, path.size()), convertor);
        }
        return result2;
    }

    private static TreeItem<Pair<AbstractUrl, String>> findNextItem(AbstractUrl url, Collection<TreeItem<Pair<AbstractUrl, String>>> list2) {
        for (TreeItem<Pair<AbstractUrl, String>> pair2 : list2) {
            if (!url.equals(((Pair)pair2.getData()).getFirst())) continue;
            return pair2;
        }
        return null;
    }

    private boolean renameFavoritesList(@NotNull String oldName, @NotNull String newName) {
        if (oldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "com/intellij/ide/favoritesTreeView/FavoritesManager", "renameFavoritesList"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/ide/favoritesTreeView/FavoritesManager", "renameFavoritesList"));
        }
        List<TreeItem<Pair<AbstractUrl, String>>> list2 = this.myName2FavoritesRoots.remove(oldName);
        int index = this.myFavoritesRootsOrder.indexOf(oldName);
        if (index != -1 && newName.length() > 0) {
            this.myFavoritesRootsOrder.remove(oldName);
            this.myFavoritesRootsOrder.remove(newName);
            this.myFavoritesRootsOrder.add(index, newName);
        }
        if (list2 != null && newName.length() > 0) {
            this.myName2FavoritesRoots.put(newName, list2);
            String description = this.myDescriptions.remove(oldName);
            if (description != null) {
                this.myDescriptions.put(newName, description);
            }
            this.rootsChanged();
            return true;
        }
        return false;
    }

    public void setOrder(String nameToOrder, String anchorName, boolean above) {
        if (!this.canReorder(nameToOrder, anchorName, above)) {
            return;
        }
        int index = this.myFavoritesRootsOrder.indexOf(anchorName);
        int toRemove2 = this.myFavoritesRootsOrder.indexOf(nameToOrder);
        this.myFavoritesRootsOrder.add(above ? index : index + 1, nameToOrder);
        this.myFavoritesRootsOrder.remove(toRemove2 > index ? toRemove2 + 1 : toRemove2);
        this.rootsChanged();
    }

    public boolean canReorder(String nameToOrder, String anchorName, boolean above) {
        int index = this.myFavoritesRootsOrder.indexOf(anchorName);
        int toReorder = this.myFavoritesRootsOrder.indexOf(nameToOrder);
        if (index == -1 || toReorder == -1 || index == toReorder) {
            return false;
        }
        if (toReorder == index - 1 && above) {
            return false;
        }
        return toReorder != index + 1 || above;
    }

    @NotNull
    public String getComponentName() {
        if ("FavoritesManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesManager", "getComponentName"));
        }
        return "FavoritesManager";
    }

    @Nullable
    public FavoritesListProvider getListProvider(@Nullable String name2) {
        return this.getProviders().get(name2);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myName2FavoritesRoots.clear();
        for (Element list2 : element.getChildren(ELEMENT_FAVORITES_LIST)) {
            String name2 = list2.getAttributeValue(ATTRIBUTE_NAME);
            List<TreeItem<Pair<AbstractUrl, String>>> roots = FavoritesManager.readRoots(list2, this.myProject);
            this.myName2FavoritesRoots.put(name2, roots);
            this.myFavoritesRootsOrder.add(name2);
        }
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    private static List<TreeItem<Pair<AbstractUrl, String>>> readRoots(Element list2, Project project2) {
        ArrayList<TreeItem<Pair<AbstractUrl, String>>> result2 = new ArrayList<TreeItem<Pair<AbstractUrl, String>>>();
        FavoritesManager.readFavoritesOneLevel(list2, project2, result2);
        return result2;
    }

    private static void readFavoritesOneLevel(Element list2, Project project2, Collection<TreeItem<Pair<AbstractUrl, String>>> result2) {
        for (Element favorite : list2.getChildren(FAVORITES_ROOT)) {
            String className = favorite.getAttributeValue(CLASS_NAME);
            AbstractUrl abstractUrl = FavoritesManager.readUrlFromElement(favorite, project2);
            if (abstractUrl == null) continue;
            TreeItem treeItem = new TreeItem((Object)Pair.create((Object)abstractUrl, (Object)className));
            result2.add((TreeItem<Pair<AbstractUrl, String>>)treeItem);
            FavoritesManager.readFavoritesOneLevel(favorite, project2, treeItem.getChildren());
        }
    }

    @Nullable
    private static AbstractUrl readUrlFromElement(Element element, Project project2) {
        String type2 = element.getAttributeValue(ATTRIBUTE_TYPE);
        String urlValue = element.getAttributeValue(ATTRIBUTE_URL);
        String moduleName = element.getAttributeValue(ATTRIBUTE_MODULE);
        for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)project2)) {
            if (!nodeProvider.getFavoriteTypeId().equals(type2)) continue;
            return new AbstractUrlFavoriteAdapter(urlValue, moduleName, nodeProvider);
        }
        for (AbstractUrl urlProvider : ourAbstractUrlProviders) {
            AbstractUrl url = urlProvider.createUrl(type2, moduleName, urlValue);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (String name2 : this.myFavoritesRootsOrder) {
            Element list2 = new Element(ELEMENT_FAVORITES_LIST);
            list2.setAttribute(ATTRIBUTE_NAME, name2);
            FavoritesManager.writeRoots(list2, (Collection<TreeItem<Pair<AbstractUrl, String>>>)this.myName2FavoritesRoots.get(name2));
            element.addContent(list2);
        }
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    @Nullable
    public static AbstractUrl createUrlByElement(Object element, Project project2) {
        if (element instanceof SmartPsiElementPointer) {
            element = ((SmartPsiElementPointer)element).getElement();
        }
        for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)project2)) {
            String url = nodeProvider.getElementUrl(element);
            if (url == null) continue;
            return new AbstractUrlFavoriteAdapter(url, nodeProvider.getElementModuleName(element), nodeProvider);
        }
        for (AbstractUrl urlProvider : ourAbstractUrlProviders) {
            AbstractUrl url = urlProvider.createUrlByElement(element);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private static void writeRoots(Element element, Collection<TreeItem<Pair<AbstractUrl, String>>> roots) {
        for (TreeItem<Pair<AbstractUrl, String>> root : roots) {
            AbstractUrl url = (AbstractUrl)((Pair)root.getData()).getFirst();
            if (url == null) continue;
            Element list2 = new Element(FAVORITES_ROOT);
            url.write(list2);
            list2.setAttribute(CLASS_NAME, (String)((Pair)root.getData()).getSecond());
            element.addContent(list2);
            List children2 = root.getChildren();
            if (children2 == null || children2.isEmpty()) continue;
            FavoritesManager.writeRoots(list2, children2);
        }
    }

    public String getFavoriteListName(@Nullable String currentSubId, @NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/ide/favoritesTreeView/FavoritesManager", "getFavoriteListName"));
        }
        if (currentSubId != null && this.contains(currentSubId, vFile)) {
            return currentSubId;
        }
        for (String listName : this.myName2FavoritesRoots.keySet()) {
            if (!this.contains(listName, vFile)) continue;
            return listName;
        }
        return null;
    }

    public boolean contains(@NotNull String name2, @NotNull VirtualFile vFile) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_NAME, "com/intellij/ide/favoritesTreeView/FavoritesManager", "contains"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/ide/favoritesTreeView/FavoritesManager", "contains"));
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        HashSet find = new HashSet();
        ContentIterator contentIterator = fileOrDir -> {
            if (vFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/ide/favoritesTreeView/FavoritesManager", "lambda$contains$3"));
            }
            if (fileOrDir != null && fileOrDir.getPath().equals(vFile.getPath())) {
                find.add(Boolean.TRUE);
            }
            return true;
        };
        List<TreeItem<Pair<AbstractUrl, String>>> urls = this.getFavoritesListRootUrls(name2);
        for (TreeItem treeItem : urls) {
            NamedLibraryElement namedLibraryElement;
            Object[] files;
            VirtualFile virtualFile;
            Object[] path;
            AbstractUrl abstractUrl = (AbstractUrl)((Pair)treeItem.getData()).getFirst();
            if (abstractUrl == null || (path = abstractUrl.createPath(this.myProject)) == null || path.length < 1 || path[0] == null) continue;
            Object element = path[path.length - 1];
            if (element instanceof SmartPsiElementPointer) {
                virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((SmartPsiElementPointer)element).getElement());
                if (virtualFile == null) continue;
                if (vFile.getPath().equals(virtualFile.getPath())) {
                    return true;
                }
                if (!virtualFile.isDirectory()) continue;
                projectFileIndex.iterateContentUnderDirectory(virtualFile, contentIterator);
            }
            if (element instanceof PsiElement) {
                virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)element));
                if (virtualFile == null) continue;
                if (vFile.getPath().equals(virtualFile.getPath())) {
                    return true;
                }
                if (!virtualFile.isDirectory()) continue;
                projectFileIndex.iterateContentUnderDirectory(virtualFile, contentIterator);
            }
            if (element instanceof Module) {
                ModuleRootManager.getInstance((Module)((Module)element)).getFileIndex().iterateContent(contentIterator);
            }
            if (element instanceof LibraryGroupElement) {
                boolean inLibrary;
                boolean bl = inLibrary = ModuleRootManager.getInstance((Module)((LibraryGroupElement)element).getModule()).getFileIndex().isInContent(vFile) && projectFileIndex.isInLibraryClasses(vFile);
                if (inLibrary) {
                    return true;
                }
            }
            if (element instanceof NamedLibraryElement && ArrayUtil.find((Object[])(files = (namedLibraryElement = (NamedLibraryElement)element).getOrderEntry().getRootFiles(OrderRootType.CLASSES)), (Object)vFile) > -1) {
                return true;
            }
            if (element instanceof ModuleGroup) {
                ModuleGroup group = (ModuleGroup)element;
                Collection<Module> modules = group.modulesInGroup(this.myProject, true);
                for (Module module2 : modules) {
                    ModuleRootManager.getInstance((Module)module2).getFileIndex().iterateContent(contentIterator);
                }
            }
            for (FavoriteNodeProvider provider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)this.myProject)) {
                if (!provider.elementContainsFile(element, vFile)) continue;
                return true;
            }
            if (find.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static void iterateTreeItems(Collection<TreeItem<Pair<AbstractUrl, String>>> coll, Consumer<TreeItem<Pair<AbstractUrl, String>>> consumer) {
        ArrayDeque<TreeItem<Pair<AbstractUrl, String>>> queue = new ArrayDeque<TreeItem<Pair<AbstractUrl, String>>>();
        queue.addAll(coll);
        while (!queue.isEmpty()) {
            TreeItem item = (TreeItem)queue.removeFirst();
            consumer.consume((Object)item);
            List children2 = item.getChildren();
            if (children2 == null || children2.isEmpty()) continue;
            queue.addAll(children2);
        }
    }

    static {
        ourAbstractUrlProviders.add(new ModuleUrl(null, null));
        ourAbstractUrlProviders.add(new DirectoryUrl(null, null));
        ourAbstractUrlProviders.add(new ModuleGroupUrl(null));
        ourAbstractUrlProviders.add(new PsiFileUrl(null));
        ourAbstractUrlProviders.add(new LibraryModuleGroupUrl(null));
        ourAbstractUrlProviders.add(new NamedLibraryUrl(null, null));
    }

    private class MyRootsChangeAdapter
    extends PsiTreeChangeAdapter {
        private MyRootsChangeAdapter() {
        }

        public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/favoritesTreeView/FavoritesManager$MyRootsChangeAdapter", "beforeChildMovement"));
            }
            PsiElement oldParent = event.getOldParent();
            PsiElement newParent = event.getNewParent();
            PsiElement child = event.getChild();
            if (newParent instanceof PsiDirectory) {
                Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)newParent);
                if (module2 == null) {
                    return;
                }
                AbstractUrl childUrl = null;
                if (child instanceof PsiFile) {
                    childUrl = new PsiFileUrl(((PsiDirectory)newParent).getVirtualFile().getUrl() + "/" + ((PsiFile)child).getName());
                } else if (child instanceof PsiDirectory) {
                    childUrl = new DirectoryUrl(((PsiDirectory)newParent).getVirtualFile().getUrl() + "/" + ((PsiDirectory)child).getName(), module2.getName());
                }
                for (String listName : FavoritesManager.this.myFavoritesRootsOrder) {
                    List roots = (List)FavoritesManager.this.myName2FavoritesRoots.get(listName);
                    PsiFileUrl finalChildUrl = childUrl;
                    FavoritesManager.iterateTreeItems(roots, (Consumer<TreeItem<Pair<AbstractUrl, String>>>)item -> {
                        Pair root = (Pair)item.getData();
                        Object[] path = ((AbstractUrl)root.first).createPath(FavoritesManager.this.myProject);
                        if (path == null || path.length < 1 || path[0] == null) {
                            return;
                        }
                        Object element = path[path.length - 1];
                        if (element == child && finalChildUrl != null) {
                            item.setData((Object)Pair.create((Object)finalChildUrl, (Object)root.second));
                        } else if (element == oldParent) {
                            item.setData((Object)Pair.create((Object)((AbstractUrl)root.first).createUrlByElement(newParent), (Object)root.second));
                        }
                    });
                }
            }
        }

        public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
            PsiElement psiElement;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/favoritesTreeView/FavoritesManager$MyRootsChangeAdapter", "beforePropertyChange"));
            }
            if ((event.getPropertyName().equals("fileName") || event.getPropertyName().equals("directoryName")) && ((psiElement = event.getChild()) instanceof PsiFile || psiElement instanceof PsiDirectory)) {
                Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
                if (module2 == null) {
                    return;
                }
                String url = ((PsiDirectory)psiElement.getParent()).getVirtualFile().getUrl() + "/" + event.getNewValue();
                AbstractUrl childUrl = psiElement instanceof PsiFile ? new PsiFileUrl(url) : new DirectoryUrl(url, module2.getName());
                for (String listName : FavoritesManager.this.myFavoritesRootsOrder) {
                    List roots = (List)FavoritesManager.this.myName2FavoritesRoots.get(listName);
                    FavoritesManager.iterateTreeItems(roots, (Consumer<TreeItem<Pair<AbstractUrl, String>>>)item -> {
                        Pair root = (Pair)item.getData();
                        Object[] path = ((AbstractUrl)root.first).createPath(FavoritesManager.this.myProject);
                        if (path == null || path.length < 1 || path[0] == null) {
                            return;
                        }
                        Object element = path[path.length - 1];
                        if (element == psiElement && psiElement instanceof PsiFile) {
                            item.setData((Object)Pair.create((Object)childUrl, (Object)root.second));
                        } else {
                            item.setData((Object)root);
                        }
                    });
                }
            }
        }
    }
}

