/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.SelectInManager;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.impl.SelectInTargetPsiWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FavoritesViewSelectInTarget
extends SelectInTargetPsiWrapper {
    public FavoritesViewSelectInTarget(Project project2) {
        super(project2);
    }

    @Override
    public String toString() {
        return SelectInManager.FAVORITES;
    }

    public String getToolWindowId() {
        return SelectInManager.FAVORITES;
    }

    @Override
    protected void select(Object selector2, VirtualFile virtualFile, boolean requestFocus) {
        FavoritesViewSelectInTarget.select(this.myProject, selector2, virtualFile, requestFocus);
    }

    @Override
    protected void select(PsiElement element, boolean requestFocus) {
        PsiElement toSelect2 = FavoritesViewSelectInTarget.findElementToSelect(element, null);
        if (toSelect2 != null) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)toSelect2);
            this.select(toSelect2, virtualFile, requestFocus);
        }
    }

    private static ActionCallback select(@NotNull Project project2, Object toSelect2, VirtualFile virtualFile, boolean requestFocus) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/favoritesTreeView/FavoritesViewSelectInTarget", "select"));
        }
        ActionCallback result2 = new ActionCallback();
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project2);
        ToolWindow favoritesToolWindow = windowManager.getToolWindow(ToolWindowId.FAVORITES_VIEW);
        if (favoritesToolWindow != null) {
            Runnable runnable2 = () -> {
                FavoritesTreeViewPanel panel2 = (FavoritesTreeViewPanel)UIUtil.findComponentOfType((JComponent)favoritesToolWindow.getComponent(), FavoritesTreeViewPanel.class);
                if (panel2 != null) {
                    panel2.selectElement(toSelect2, virtualFile, requestFocus);
                    result2.setDone();
                }
            };
            if (requestFocus) {
                favoritesToolWindow.activate(runnable2, false);
            } else {
                favoritesToolWindow.show(runnable2);
            }
        }
        return result2;
    }

    @Override
    protected boolean canSelect(PsiFileSystemItem file2) {
        return FavoritesViewSelectInTarget.findSuitableFavoritesList(file2.getVirtualFile(), this.myProject, null) != null;
    }

    public static String findSuitableFavoritesList(VirtualFile file2, Project project2, String currentSubId) {
        return FavoritesManager.getInstance(project2).getFavoriteListName(currentSubId, file2);
    }

    public String getMinorViewId() {
        return "Favorites";
    }

    public float getWeight() {
        return 1.01f;
    }

    @Override
    protected boolean canWorkWithCustomObjects() {
        return false;
    }
}

