/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.CustomFileTemplate;
import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FTManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.FTManager");
    private static final String DEFAULT_TEMPLATE_EXTENSION = "ft";
    static final String TEMPLATE_EXTENSION_SUFFIX = ".ft";
    private static final String ENCODED_NAME_EXT_DELIMITER = "\u0f0fext\u0f0f.";
    private final String myName;
    private final boolean myInternal;
    private final File myTemplatesDir;
    @Nullable
    private final FTManager myOriginal;
    private final Map<String, FileTemplateBase> myTemplates;
    private volatile List<FileTemplateBase> mySortedTemplates;
    private final List<DefaultTemplate> myDefaultTemplates;

    FTManager(@NotNull @NonNls String name2, @NotNull @NonNls File defaultTemplatesDirName) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/fileTemplates/impl/FTManager", "<init>"));
        }
        if (defaultTemplatesDirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultTemplatesDirName", "com/intellij/ide/fileTemplates/impl/FTManager", "<init>"));
        }
        this(name2, defaultTemplatesDirName, false);
    }

    FTManager(@NotNull @NonNls String name2, @NotNull @NonNls File defaultTemplatesDirName, boolean internal) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/fileTemplates/impl/FTManager", "<init>"));
        }
        if (defaultTemplatesDirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultTemplatesDirName", "com/intellij/ide/fileTemplates/impl/FTManager", "<init>"));
        }
        this.myTemplates = new HashMap<String, FileTemplateBase>();
        this.myDefaultTemplates = new ArrayList<DefaultTemplate>();
        this.myName = name2;
        this.myInternal = internal;
        this.myTemplatesDir = defaultTemplatesDirName;
        this.myOriginal = null;
    }

    FTManager(@NotNull FTManager original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/ide/fileTemplates/impl/FTManager", "<init>"));
        }
        this.myTemplates = new HashMap<String, FileTemplateBase>();
        this.myDefaultTemplates = new ArrayList<DefaultTemplate>();
        this.myOriginal = original;
        this.myName = original.getName();
        this.myTemplatesDir = original.myTemplatesDir;
        this.myInternal = original.myInternal;
        this.myTemplates.putAll(original.myTemplates);
        this.myDefaultTemplates.addAll(original.myDefaultTemplates);
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    Collection<FileTemplateBase> getAllTemplates(boolean includeDisabled) {
        List<FileTemplateBase> sorted = this.mySortedTemplates;
        if (sorted == null) {
            sorted = new ArrayList<FileTemplateBase>(this.getTemplates().values());
            Collections.sort(sorted, (t1, t2) -> t1.getName().compareToIgnoreCase(t2.getName()));
            this.mySortedTemplates = sorted;
        }
        if (includeDisabled) {
            Collection<FileTemplateBase> collection = Collections.unmodifiableCollection(sorted);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FTManager", "getAllTemplates"));
            }
            return collection;
        }
        ArrayList<FileTemplateBase> list2 = new ArrayList<FileTemplateBase>(sorted.size());
        for (FileTemplateBase template : sorted) {
            if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isEnabled()) continue;
            list2.add(template);
        }
        ArrayList<FileTemplateBase> arrayList = list2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FTManager", "getAllTemplates"));
        }
        return arrayList;
    }

    @Nullable
    FileTemplateBase getTemplate(@NotNull String templateQname) {
        if (templateQname == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateQname", "com/intellij/ide/fileTemplates/impl/FTManager", "getTemplate"));
        }
        return this.getTemplates().get(templateQname);
    }

    @Nullable
    public FileTemplateBase findTemplateByName(@NotNull String templateName) {
        if (templateName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateName", "com/intellij/ide/fileTemplates/impl/FTManager", "findTemplateByName"));
        }
        FileTemplateBase template = this.getTemplates().get(templateName);
        if (template != null) {
            boolean isEnabled;
            boolean bl = isEnabled = !(template instanceof BundledFileTemplate) || ((BundledFileTemplate)template).isEnabled();
            if (isEnabled) {
                return template;
            }
        }
        for (FileTemplateBase t : this.getAllTemplates(false)) {
            String remainder;
            String qName = t.getQualifiedName();
            if (!qName.startsWith(templateName) || qName.length() <= templateName.length() || !(remainder = qName.substring(templateName.length())).startsWith(ENCODED_NAME_EXT_DELIMITER) && remainder.charAt(0) != '.') continue;
            return t;
        }
        return null;
    }

    @NotNull
    public FileTemplateBase addTemplate(String name2, String extension) {
        String qName = FileTemplateBase.getQualifiedName(name2, extension);
        FileTemplateBase template = this.getTemplate(qName);
        if (template == null) {
            template = new CustomFileTemplate(name2, extension);
            this.getTemplates().put(qName, template);
            this.mySortedTemplates = null;
        } else if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isEnabled()) {
            ((BundledFileTemplate)template).setEnabled(true);
        }
        FileTemplateBase fileTemplateBase = template;
        if (fileTemplateBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FTManager", "addTemplate"));
        }
        return fileTemplateBase;
    }

    public void removeTemplate(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/ide/fileTemplates/impl/FTManager", "removeTemplate"));
        }
        FileTemplateBase template = this.getTemplates().get(qName);
        if (template instanceof CustomFileTemplate) {
            this.getTemplates().remove(qName);
            this.mySortedTemplates = null;
        } else if (template instanceof BundledFileTemplate) {
            ((BundledFileTemplate)template).setEnabled(false);
        }
    }

    void updateTemplates(@NotNull Collection<FileTemplate> newTemplates) {
        if (newTemplates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTemplates", "com/intellij/ide/fileTemplates/impl/FTManager", "updateTemplates"));
        }
        HashSet<String> toDisable = new HashSet<String>();
        for (DefaultTemplate defaultTemplate : this.myDefaultTemplates) {
            toDisable.add(defaultTemplate.getQualifiedName());
        }
        for (FileTemplate fileTemplate : newTemplates) {
            toDisable.remove(((FileTemplateBase)fileTemplate).getQualifiedName());
        }
        this.restoreDefaults(toDisable);
        for (FileTemplate fileTemplate : newTemplates) {
            FileTemplateBase _template = this.addTemplate(fileTemplate.getName(), fileTemplate.getExtension());
            _template.setText(fileTemplate.getText());
            _template.setReformatCode(fileTemplate.isReformatCode());
            _template.setLiveTemplateEnabled(fileTemplate.isLiveTemplateEnabled());
        }
        this.saveTemplates(true);
    }

    private void restoreDefaults(Set<String> toDisable) {
        this.getTemplates().clear();
        this.mySortedTemplates = null;
        for (DefaultTemplate template : this.myDefaultTemplates) {
            BundledFileTemplate bundled = this.createAndStoreBundledTemplate(template);
            if (!toDisable.contains(bundled.getQualifiedName())) continue;
            bundled.setEnabled(false);
        }
    }

    void addDefaultTemplate(DefaultTemplate template) {
        this.myDefaultTemplates.add(template);
        this.createAndStoreBundledTemplate(template);
    }

    private BundledFileTemplate createAndStoreBundledTemplate(DefaultTemplate template) {
        BundledFileTemplate bundled = new BundledFileTemplate(template, this.myInternal);
        String qName = bundled.getQualifiedName();
        FileTemplateBase previous = this.getTemplates().put(qName, bundled);
        this.mySortedTemplates = null;
        LOG.assertTrue(previous == null, (Object)("Duplicate bundled template " + qName + " [" + template.getTemplateURL() + ", " + previous + ']'));
        return bundled;
    }

    void loadCustomizedContent() {
        File configRoot = this.getConfigRoot(false);
        File[] configFiles = configRoot.listFiles();
        if (configFiles == null) {
            return;
        }
        ArrayList<File> templateWithDefaultExtension = new ArrayList<File>();
        HashSet<String> processedNames = new HashSet<String>();
        for (File file2 : configFiles) {
            if (file2.isDirectory() || FileTypeManager.getInstance().isFileIgnored(file2.getName()) || file2.isHidden()) continue;
            String name2 = file2.getName();
            if (name2.endsWith(TEMPLATE_EXTENSION_SUFFIX)) {
                templateWithDefaultExtension.add(file2);
                continue;
            }
            processedNames.add(name2);
            this.addTemplateFromFile(name2, file2);
        }
        for (File file3 : templateWithDefaultExtension) {
            String name3 = file3.getName();
            if (!processedNames.contains(name3 = name3.substring(0, name3.length() - TEMPLATE_EXTENSION_SUFFIX.length()))) {
                this.addTemplateFromFile(name3, file3);
            }
            FileUtil.delete((File)file3);
        }
    }

    private void addTemplateFromFile(String fileName, File file2) {
        Pair<String, String> nameExt = FTManager.decodeFileName(fileName);
        String extension = (String)nameExt.second;
        String templateQName = (String)nameExt.first;
        if (templateQName.isEmpty()) {
            return;
        }
        try {
            String text2 = FileUtil.loadFile((File)file2, (Charset)CharsetToolkit.UTF8_CHARSET);
            this.addTemplate(templateQName, extension).setText(text2);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void saveTemplates() {
        this.saveTemplates(false);
    }

    private void saveTemplates(boolean removeDeleted) {
        HashMap<String, File> templatesOnDisk;
        File configRoot = this.getConfigRoot(true);
        File[] files = configRoot.listFiles();
        HashSet<String> allNames = new HashSet<String>();
        HashMap<String, File> hashMap = templatesOnDisk = files != null && files.length > 0 ? new HashMap<String, File>() : Collections.emptyMap();
        if (files != null) {
            for (File file2 : files) {
                if (file2.isDirectory()) continue;
                String name2 = file2.getName();
                templatesOnDisk.put(name2, file2);
                allNames.add(name2);
            }
        }
        HashMap<String, FileTemplateBase> templatesToSave = new HashMap<String, FileTemplateBase>();
        for (FileTemplateBase template : this.getAllTemplates(true)) {
            if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isTextModified()) continue;
            String name3 = template.getQualifiedName();
            templatesToSave.put(name3, template);
            allNames.add(name3);
        }
        if (!allNames.isEmpty()) {
            String lineSeparator = CodeStyleSettingsManager.getSettings((Project)ProjectManagerEx.getInstanceEx().getDefaultProject()).getLineSeparator();
            for (String name3 : allNames) {
                File customizedTemplateFile = (File)templatesOnDisk.get(name3);
                FileTemplateBase templateToSave = (FileTemplateBase)templatesToSave.get(name3);
                if (customizedTemplateFile == null) {
                    try {
                        FTManager.saveTemplate(configRoot, templateToSave, lineSeparator);
                    }
                    catch (IOException e) {
                        LOG.error("Unable to save template " + name3, (Throwable)e);
                    }
                    continue;
                }
                if (templateToSave == null) {
                    if (!removeDeleted) continue;
                    FileUtil.delete((File)customizedTemplateFile);
                    continue;
                }
                try {
                    String templateText;
                    String diskText = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)customizedTemplateFile, (Charset)CharsetToolkit.UTF8_CHARSET));
                    if (diskText.equals(templateText = templateToSave.getText())) continue;
                    FTManager.saveTemplate(configRoot, templateToSave, lineSeparator);
                }
                catch (IOException e) {
                    LOG.error("Unable to save template " + name3, (Throwable)e);
                }
            }
        }
    }

    private static void saveTemplate(File parentDir, FileTemplateBase template, String lineSeparator) throws IOException {
        FileOutputStream fileOutputStream;
        File templateFile = new File(parentDir, FTManager.encodeFileName(template.getName(), template.getExtension()));
        try {
            fileOutputStream = new FileOutputStream(templateFile);
        }
        catch (FileNotFoundException e) {
            FileUtil.delete((File)templateFile);
            fileOutputStream = new FileOutputStream(templateFile);
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, CharsetToolkit.UTF8_CHARSET);
        String content = template.getText();
        if (!lineSeparator.equals("\n")) {
            content = StringUtil.convertLineSeparators((String)content, (String)lineSeparator);
        }
        outputStreamWriter.write(content);
        outputStreamWriter.close();
        fileOutputStream.close();
    }

    @NotNull
    File getConfigRoot(boolean create2) {
        if (create2 && !this.myTemplatesDir.mkdirs() && !this.myTemplatesDir.exists()) {
            LOG.info("Cannot create directory: " + this.myTemplatesDir.getAbsolutePath());
        }
        File file2 = this.myTemplatesDir;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FTManager", "getConfigRoot"));
        }
        return file2;
    }

    public String toString() {
        return this.myName + " file template manager";
    }

    static String encodeFileName(String templateName, String extension) {
        String nameExtDelimiter = extension.contains(".") ? ENCODED_NAME_EXT_DELIMITER : ".";
        return templateName + nameExtDelimiter + extension;
    }

    @NotNull
    private static Pair<String, String> decodeFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/fileTemplates/impl/FTManager", "decodeFileName"));
        }
        String name2 = fileName;
        String ext = "";
        String nameExtDelimiter = fileName.contains(ENCODED_NAME_EXT_DELIMITER) ? ENCODED_NAME_EXT_DELIMITER : ".";
        int extIndex = fileName.lastIndexOf(nameExtDelimiter);
        if (extIndex >= 0) {
            name2 = fileName.substring(0, extIndex);
            ext = fileName.substring(extIndex + nameExtDelimiter.length());
        }
        Pair pair2 = Pair.create((Object)name2, (Object)ext);
        if (pair2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FTManager", "decodeFileName"));
        }
        return pair2;
    }

    public Map<String, FileTemplateBase> getTemplates() {
        return this.myOriginal != null ? this.myOriginal.myTemplates : this.myTemplates;
    }
}

