/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.TypeHierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class SubtypesHierarchyTreeStructure
extends HierarchyTreeStructure {
    private final String myCurrentScopeType;

    protected SubtypesHierarchyTreeStructure(Project project2, HierarchyNodeDescriptor descriptor, String currentScopeType) {
        super(project2, descriptor);
        this.myCurrentScopeType = currentScopeType;
    }

    public SubtypesHierarchyTreeStructure(Project project2, PsiClass psiClass, String currentScopeType) {
        super(project2, new TypeHierarchyNodeDescriptor(project2, null, (PsiElement)psiClass, true));
        this.myCurrentScopeType = currentScopeType;
    }

    @Override
    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/hierarchy/type/SubtypesHierarchyTreeStructure", "buildChildren"));
        }
        PsiElement element = ((TypeHierarchyNodeDescriptor)descriptor).getPsiClass();
        if (!(element instanceof PsiClass)) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/type/SubtypesHierarchyTreeStructure", "buildChildren"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        PsiClass psiClass = (PsiClass)element;
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            Object[] objectArray = new Object[]{IdeBundle.message((String)"node.hierarchy.java.lang.object", (Object[])new Object[0])};
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/type/SubtypesHierarchyTreeStructure", "buildChildren"));
            }
            return objectArray;
        }
        if (psiClass instanceof PsiAnonymousClass) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/type/SubtypesHierarchyTreeStructure", "buildChildren"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        if (psiClass.hasModifierProperty("final")) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/type/SubtypesHierarchyTreeStructure", "buildChildren"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        SearchScope searchScope = psiClass.getUseScope().intersectWith(this.getSearchScope(this.myCurrentScopeType, (PsiElement)psiClass));
        ArrayList<PsiClass> classes2 = new ArrayList<PsiClass>(SubtypesHierarchyTreeStructure.searchInheritors(psiClass, searchScope));
        ArrayList<TypeHierarchyNodeDescriptor> descriptors = new ArrayList<TypeHierarchyNodeDescriptor>(classes2.size());
        for (PsiClass aClass : classes2) {
            descriptors.add(new TypeHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)aClass, false));
        }
        FunctionalExpressionSearch.search((PsiClass)psiClass, (SearchScope)searchScope).forEach(expression2 -> {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/hierarchy/type/SubtypesHierarchyTreeStructure", "lambda$buildChildren$0"));
            }
            descriptors.add(new TypeHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)expression2, false));
            return true;
        });
        HierarchyNodeDescriptor[] hierarchyNodeDescriptorArray = descriptors.toArray(new HierarchyNodeDescriptor[descriptors.size()]);
        if (hierarchyNodeDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/type/SubtypesHierarchyTreeStructure", "buildChildren"));
        }
        return hierarchyNodeDescriptorArray;
    }

    @NotNull
    private static Collection<PsiClass> searchInheritors(@NotNull PsiClass psiClass, @NotNull SearchScope searchScope) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/ide/hierarchy/type/SubtypesHierarchyTreeStructure", "searchInheritors"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/ide/hierarchy/type/SubtypesHierarchyTreeStructure", "searchInheritors"));
        }
        if (psiClass.isAnnotationType()) {
            HashSet result2 = ContainerUtil.newHashSet();
            AnnotatedElementsSearch.searchPsiClasses((PsiClass)psiClass, (SearchScope)searchScope).forEach(processorResult -> {
                if (processorResult.isAnnotationType()) {
                    result2.add(processorResult);
                }
                return true;
            });
            HashSet hashSet = result2;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/type/SubtypesHierarchyTreeStructure", "searchInheritors"));
            }
            return hashSet;
        }
        Collection collection = ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)searchScope, (boolean)false).findAll();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/hierarchy/type/SubtypesHierarchyTreeStructure", "searchInheritors"));
        }
        return collection;
    }
}

