/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectInTargetPsiWrapper
implements SelectInTarget {
    protected final Project myProject;

    protected SelectInTargetPsiWrapper(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/impl/SelectInTargetPsiWrapper", "<init>"));
        }
        this.myProject = project2;
    }

    public abstract String toString();

    protected abstract boolean canSelect(PsiFileSystemItem var1);

    public final boolean canSelect(@NotNull SelectInContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/impl/SelectInTargetPsiWrapper", "canSelect"));
        }
        if (!this.isContextValid(context)) {
            return false;
        }
        return this.canWorkWithCustomObjects() || this.canSelectInner(context);
    }

    protected boolean canSelectInner(@NotNull SelectInContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/impl/SelectInTargetPsiWrapper", "canSelectInner"));
        }
        PsiFileSystemItem psiFile = this.getContextPsiFile(context);
        return psiFile != null && this.canSelect(psiFile);
    }

    private boolean isContextValid(SelectInContext context) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        VirtualFile virtualFile = context.getVirtualFile();
        return virtualFile.isValid();
    }

    @Nullable
    protected PsiFileSystemItem getContextPsiFile(@NotNull SelectInContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/impl/SelectInTargetPsiWrapper", "getContextPsiFile"));
        }
        VirtualFile virtualFile = context.getVirtualFile();
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
        if (psiFile != null) {
            return psiFile;
        }
        if (context.getSelectorInFile() instanceof PsiFile) {
            return (PsiFile)context.getSelectorInFile();
        }
        if (virtualFile.isDirectory()) {
            return PsiManager.getInstance((Project)this.myProject).findDirectory(virtualFile);
        }
        return null;
    }

    public final void selectIn(@NotNull SelectInContext context, boolean requestFocus) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/impl/SelectInTargetPsiWrapper", "selectIn"));
        }
        VirtualFile file2 = context.getVirtualFile();
        Object selector2 = context.getSelectorInFile();
        if (selector2 == null) {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            Object object = selector2 = file2.isDirectory() ? psiManager.findDirectory(file2) : psiManager.findFile(file2);
        }
        if (selector2 instanceof PsiElement) {
            this.select(((PsiElement)selector2).getOriginalElement(), requestFocus);
        } else {
            this.select(selector2, file2, requestFocus);
        }
    }

    protected abstract void select(Object var1, VirtualFile var2, boolean var3);

    protected abstract boolean canWorkWithCustomObjects();

    protected abstract void select(PsiElement var1, boolean var2);

    @Nullable
    protected static PsiElement findElementToSelect(PsiElement element, PsiElement candidate) {
        PsiElement toSelect2 = candidate;
        if (toSelect2 == null) {
            if (element instanceof PsiFile || element instanceof PsiDirectory) {
                toSelect2 = element;
            } else {
                PsiFile containingFile = element.getContainingFile();
                if (containingFile != null) {
                    FileViewProvider viewProvider = containingFile.getViewProvider();
                    toSelect2 = viewProvider.getPsi(viewProvider.getBaseLanguage());
                }
            }
        }
        if (toSelect2 != null) {
            PsiElement originalElement = null;
            try {
                originalElement = toSelect2.getOriginalElement();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (originalElement != null) {
                toSelect2 = originalElement;
            }
        }
        return toSelect2;
    }
}

