/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;

public class EncryptionUtil {
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final String SECRET_KEY_ALGORITHM = "AES";
    private static final String ENCRYPT_KEY_ALGORITHM = "AES/CBC/NoPadding";
    private static final String ENCRYPT_DATA_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final int SECRET_KEY_SIZE = 128;
    public static final int SECRET_KEY_SIZE_BYTES = 16;
    private static final IvParameterSpec CBC_SALT_DATA = new IvParameterSpec(new byte[]{119, 111, -93, 2, -43, -12, 117, 82, 12, 40, 69, -34, 78, 86, -97, 95});
    private static final IvParameterSpec CBC_SALT_KEY = new IvParameterSpec(new byte[]{-84, 125, 61, 61, 95, -34, -112, -9, 7, 25, -42, 96, 11, 89, -101, -70});

    private EncryptionUtil() {
    }

    static byte[] rawKey(@NotNull CredentialAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/ide/passwordSafe/impl/providers/EncryptionUtil", "rawKey"));
        }
        return EncryptionUtil.hash(new byte[][]{EncryptionUtil.getUTF8Bytes(attributes.getServiceName() + "/" + attributes.getUserName())});
    }

    public static byte[] genKey(byte[] keyBytes) {
        byte[] key2 = new byte[16];
        for (int i2 = 0; i2 < keyBytes.length; ++i2) {
            int n = i2 % 16;
            key2[n] = (byte)(key2[n] ^ keyBytes[i2]);
        }
        return key2;
    }

    public static byte[] genPasswordKey(@NotNull String password) {
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "com/intellij/ide/passwordSafe/impl/providers/EncryptionUtil", "genPasswordKey"));
        }
        return EncryptionUtil.genKey(EncryptionUtil.hash(new byte[][]{EncryptionUtil.getUTF8Bytes(password)}));
    }

    @NotNull
    public static byte[] encryptKey(@NotNull byte[] password, byte[] rawKey) {
        byte[] byArray;
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "com/intellij/ide/passwordSafe/impl/providers/EncryptionUtil", "encryptKey"));
        }
        try {
            Cipher c = Cipher.getInstance(ENCRYPT_KEY_ALGORITHM);
            c.init(1, (Key)new SecretKeySpec(password, SECRET_KEY_ALGORITHM), CBC_SALT_KEY);
            byArray = c.doFinal(rawKey);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/passwordSafe/impl/providers/EncryptionUtil", "encryptKey"));
        }
        return byArray;
    }

    public static byte[] decryptKey(byte[] password, byte[] encryptedKey) {
        try {
            Cipher c = Cipher.getInstance(ENCRYPT_KEY_ALGORITHM);
            c.init(2, (Key)new SecretKeySpec(password, SECRET_KEY_ALGORITHM), CBC_SALT_KEY);
            return c.doFinal(encryptedKey);
        }
        catch (Exception e) {
            throw new IllegalStateException("AES/CBC/NoPadding is not available", e);
        }
    }

    static byte[] encryptData(byte[] password, int size, byte[] data) {
        try {
            Cipher c = Cipher.getInstance(ENCRYPT_DATA_ALGORITHM);
            c.init(1, (Key)new SecretKeySpec(password, SECRET_KEY_ALGORITHM), CBC_SALT_DATA);
            c.update(new byte[]{(byte)(size >> 24), (byte)(size >> 16), (byte)(size >> 8), (byte)size});
            return c.doFinal(data);
        }
        catch (Exception e) {
            throw new IllegalStateException("AES/CBC/PKCS5Padding is not available", e);
        }
    }

    public static byte[] encryptText(byte[] password, @NotNull OneTimeString value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/passwordSafe/impl/providers/EncryptionUtil", "encryptText"));
        }
        byte[] data = value2.toByteArray(false);
        return EncryptionUtil.encryptData(password, data.length, data);
    }

    static byte[] decryptData(byte[] password, byte[] encryptedData) {
        try {
            Cipher c = Cipher.getInstance(ENCRYPT_DATA_ALGORITHM);
            c.init(2, (Key)new SecretKeySpec(password, SECRET_KEY_ALGORITHM), CBC_SALT_DATA);
            return c.doFinal(encryptedData);
        }
        catch (Exception e) {
            throw new IllegalStateException("AES/CBC/PKCS5Padding is not available", e);
        }
    }

    @NotNull
    public static OneTimeString decryptText(byte[] password, byte[] data) {
        byte[] plain = EncryptionUtil.decryptData(password, data);
        int len = ((plain[0] & 0xFF) << 24) + ((plain[1] & 0xFF) << 16) + ((plain[2] & 0xFF) << 8) + (plain[3] & 0xFF);
        if (len < 0 || len > plain.length - 4) {
            throw new IllegalStateException("Unmatched password is used");
        }
        OneTimeString oneTimeString = CredentialAttributesKt.OneTimeString((byte[])plain, (int)4, (int)len);
        if (oneTimeString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/passwordSafe/impl/providers/EncryptionUtil", "decryptText"));
        }
        return oneTimeString;
    }

    public static byte[] getUTF8Bytes(String string) {
        return string.getBytes(CharsetToolkit.UTF8_CHARSET);
    }

    public static byte[] hash(byte[] ... data) {
        try {
            MessageDigest h = MessageDigest.getInstance(HASH_ALGORITHM);
            for (byte[] d : data) {
                h.update(d);
            }
            return h.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("The hash algorithm SHA-256 is not available", e);
        }
    }
}

