/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsManagerMain;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.RowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManagerConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    public static final String ID = "preferences.pluginManager";
    public static final String DISPLAY_NAME = IdeBundle.message((String)"title.plugins", (Object[])new Object[0]);
    protected final PluginManagerUISettings myUISettings;
    private PluginManagerMain myPluginManagerMain;
    private boolean myAvailable;
    private boolean myShutdownRequired;

    public PluginManagerConfigurable(PluginManagerUISettings UISettings2) {
        this.myUISettings = UISettings2;
    }

    public PluginManagerConfigurable(PluginManagerUISettings UISettings2, boolean available) {
        this.myUISettings = UISettings2;
        this.myAvailable = available;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPluginManagerMain == null ? null : this.myPluginManagerMain.getPluginTable();
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public void reset() {
        this.myPluginManagerMain.reset();
        this.myPluginManagerMain.pluginsModel.sort();
        this.getSplitterProportions().restoreSplitterProportions((Component)this.myPluginManagerMain.getMainPanel());
    }

    @NotNull
    public String getHelpTopic() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerConfigurable", "getHelpTopic"));
        }
        return ID;
    }

    public void disposeUIResources() {
        if (this.myPluginManagerMain != null) {
            this.getSplitterProportions().saveSplitterProportions((Component)this.myPluginManagerMain.getMainPanel());
            if (this.myAvailable) {
                List<RowSorter.SortKey> sortKeys;
                RowSorter rowSorter = this.myPluginManagerMain.pluginTable.getRowSorter();
                if (rowSorter != null && (sortKeys = rowSorter.getSortKeys()).size() > 0) {
                    RowSorter.SortKey sortKey = sortKeys.get(0);
                    this.myUISettings.AVAILABLE_SORT_COLUMN_ORDER = sortKey.getSortOrder().ordinal();
                }
                this.myUISettings.availableSortByStatus = this.myPluginManagerMain.pluginsModel.isSortByStatus();
            } else {
                this.myUISettings.installedSortByStatus = this.myPluginManagerMain.pluginsModel.isSortByStatus();
            }
            Disposer.dispose((Disposable)this.myPluginManagerMain);
            this.myPluginManagerMain = null;
        }
    }

    private SplitterProportionsData getSplitterProportions() {
        return this.myAvailable ? this.myUISettings.availableProportions : this.myUISettings.installedProportions;
    }

    public JComponent createComponent() {
        return this.getOrCreatePanel().getMainPanel();
    }

    protected PluginManagerMain createPanel() {
        return new InstalledPluginsManagerMain(this.myUISettings);
    }

    public void apply() throws ConfigurationException {
        String applyMessage = this.myPluginManagerMain.apply();
        if (applyMessage != null) {
            throw new ConfigurationException(applyMessage);
        }
        boolean prev = this.myShutdownRequired;
        this.myShutdownRequired |= this.myPluginManagerMain.isRequireShutdown();
        this.myPluginManagerMain.ignoreChanges();
        if (prev) {
            return;
        }
        Disposable d = (Disposable)UIUtil.uiParents((Component)this.myPluginManagerMain.getMainPanel(), (boolean)false).filter(Disposable.class).first();
        if (d == null) {
            return;
        }
        Disposer.register((Disposable)d, (Disposable)new Disposable(){

            public void dispose() {
                ApplicationManager.getApplication().invokeLater(() -> PluginManagerConfigurable.this.showShutdownDialogIfNeeded(), ApplicationManager.getApplication().getDisposed());
            }
        });
    }

    private void showShutdownDialogIfNeeded() {
        if (!this.myShutdownRequired) {
            return;
        }
        if (PluginManagerConfigurable.showRestartDialog() == 0) {
            ApplicationManagerEx.getApplicationEx().restart(true);
        }
    }

    public PluginManagerMain getOrCreatePanel() {
        if (this.myPluginManagerMain == null) {
            this.myPluginManagerMain = this.createPanel();
        }
        return this.myPluginManagerMain;
    }

    @Messages.YesNoResult
    public static int showRestartDialog() {
        return PluginManagerConfigurable.showRestartDialog(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]));
    }

    @Messages.YesNoResult
    public static int showRestartDialog(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ide/plugins/PluginManagerConfigurable", "showRestartDialog"));
        }
        String action = IdeBundle.message((String)(ApplicationManagerEx.getApplicationEx().isRestartCapable() ? "ide.restart.action" : "ide.shutdown.action"), (Object[])new Object[0]);
        String message2 = IdeBundle.message((String)"ide.restart.required.message", (Object[])new Object[]{action, ApplicationNamesInfo.getInstance().getFullProductName()});
        return Messages.showYesNoDialog((String)message2, (String)title, (String)action, (String)IdeBundle.message((String)"ide.postpone.action", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
    }

    public static void shutdownOrRestartApp() {
        PluginManagerConfigurable.shutdownOrRestartApp(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]));
    }

    public static void shutdownOrRestartApp(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ide/plugins/PluginManagerConfigurable", "shutdownOrRestartApp"));
        }
        if (PluginManagerConfigurable.showRestartDialog(title) == 0) {
            ApplicationManagerEx.getApplicationEx().restart(true);
        }
    }

    public boolean isModified() {
        return this.myPluginManagerMain != null && this.myPluginManagerMain.isModified();
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerConfigurable", "getId"));
        }
        return string;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return () -> {
            if (this.myPluginManagerMain != null) {
                this.myPluginManagerMain.filter(option);
            }
        };
    }

    public void select(IdeaPluginDescriptor ... descriptors) {
        this.myPluginManagerMain.select(descriptors);
    }
}

