/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginHeaderPanel;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.sorters.SortByStatusAction;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PluginManagerMain
implements Disposable {
    public static final String JETBRAINS_VENDOR = "JetBrains";
    public static final Logger LOG = Logger.getInstance(PluginManagerMain.class);
    @NonNls
    private static final String TEXT_SUFFIX = "</body></html>";
    @NonNls
    private static final String HTML_PREFIX = "<a href=\"";
    @NonNls
    private static final String HTML_SUFFIX = "</a>";
    private boolean requireShutdown = false;
    private JPanel myToolbarPanel;
    private JPanel main;
    private JEditorPane myDescriptionTextArea;
    private JPanel myTablePanel;
    protected JPanel myActionsPanel;
    private JPanel myHeader;
    private PluginHeaderPanel myPluginHeaderPanel;
    private JPanel myInfoPanel;
    protected JBLabel myPanelDescription;
    private JBScrollPane myDescriptionScrollPane;
    protected PluginTableModel pluginsModel;
    protected PluginTable pluginTable;
    private ActionToolbar myActionToolbar;
    protected final MyPluginsFilter myFilter;
    protected PluginManagerUISettings myUISettings;
    private boolean myDisposed;
    private boolean myBusy;

    public PluginManagerMain(PluginManagerUISettings uiSettings) {
        this.$$$setupUI$$$();
        this.myFilter = new MyPluginsFilter();
        this.myDisposed = false;
        this.myBusy = false;
        this.myUISettings = uiSettings;
    }

    public static boolean isDevelopedByJetBrains(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/intellij/ide/plugins/PluginManagerMain", "isDevelopedByJetBrains"));
        }
        return PluginManagerMain.isDevelopedByJetBrains(plugin.getVendor());
    }

    public static boolean isDevelopedByJetBrains(@Nullable String vendorString) {
        if (vendorString == null) {
            return false;
        }
        for (String vendor : StringUtil.split((String)vendorString, (String)",")) {
            if (!vendor.trim().equals(JETBRAINS_VENDOR)) continue;
            return true;
        }
        return false;
    }

    protected void init() {
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.main, (boolean)true);
        HTMLEditorKit kit = UIUtil.getHTMLEditorKit();
        StyleSheet sheet = kit.getStyleSheet();
        sheet.addRule("ul {margin-left: 16px}");
        this.myDescriptionTextArea.setEditorKit(kit);
        this.myDescriptionTextArea.setEditable(false);
        this.myDescriptionTextArea.addHyperlinkListener(new MyHyperlinkListener());
        JScrollPane installedScrollPane = this.createTable();
        installedScrollPane.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)1, (int)1, (int)0));
        this.myPluginHeaderPanel = new PluginHeaderPanel(this);
        this.myHeader.setBackground(UIUtil.getTextFieldBackground());
        this.myPluginHeaderPanel.getPanel().setBackground(UIUtil.getTextFieldBackground());
        this.myPluginHeaderPanel.getPanel().setOpaque(true);
        this.myHeader.add((Component)this.myPluginHeaderPanel.getPanel(), "Center");
        this.installTableActions();
        this.myTablePanel.add((Component)installedScrollPane, "Center");
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myPanelDescription);
        this.myPanelDescription.setBorder((Border)JBUI.Borders.emptyLeft((int)7));
        JPanel header = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Color bg = UIUtil.getTableBackground((boolean)false);
                ((Graphics2D)g).setPaint(new GradientPaint(0.0f, 0.0f, ColorUtil.shift((Color)bg, (double)1.4), 0.0f, this.getHeight(), ColorUtil.shift((Color)bg, (double)0.9)));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        header.setBorder((Border)new CustomLineBorder(1, 1, 0, 0));
        final JLabel mySortLabel = new JLabel();
        mySortLabel.setForeground(UIUtil.getLabelDisabledForeground());
        mySortLabel.setBorder((Border)JBUI.Borders.empty((int)1, (int)1, (int)1, (int)5));
        mySortLabel.setIcon(AllIcons.General.SplitDown);
        mySortLabel.setHorizontalTextPosition(10);
        header.add((Component)mySortLabel, "East");
        this.myTablePanel.add((Component)header, "North");
        this.myToolbarPanel.setLayout(new BorderLayout());
        this.myActionToolbar = ActionManager.getInstance().createActionToolbar("PluginManager", this.getActionGroup(true), true);
        JComponent component = this.myActionToolbar.getComponent();
        this.myToolbarPanel.add((Component)component, "Center");
        this.myToolbarPanel.add((Component)((Object)this.myFilter), "West");
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/plugins/PluginManagerMain$2", "onClick"));
                }
                JBPopupFactory.getInstance().createActionGroupPopup("Sort by:", (ActionGroup)PluginManagerMain.this.createSortersGroup(), DataManager.getInstance().getDataContext((Component)((Object)PluginManagerMain.this.pluginTable)), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).showUnderneathOf((Component)mySortLabel);
                return true;
            }
        }.installOn((Component)mySortLabel);
        TableModelListener modelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                String text2 = "Sort by:";
                if (PluginManagerMain.this.pluginsModel.isSortByStatus()) {
                    text2 = text2 + " status,";
                }
                if (PluginManagerMain.this.pluginsModel.isSortByRating()) {
                    text2 = text2 + " rating,";
                }
                if (PluginManagerMain.this.pluginsModel.isSortByDownloads()) {
                    text2 = text2 + " downloads,";
                }
                if (PluginManagerMain.this.pluginsModel.isSortByUpdated()) {
                    text2 = text2 + " updated,";
                }
                text2 = text2 + " name";
                mySortLabel.setText(text2);
            }
        };
        this.pluginTable.getModel().addTableModelListener(modelListener);
        modelListener.tableChanged(null);
        this.myDescriptionScrollPane.setBackground(UIUtil.getTextFieldBackground());
        Border border = JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)0, (int)1, (int)1);
        this.myInfoPanel.setBorder(border);
    }

    protected abstract JScrollPane createTable();

    public void dispose() {
        this.myDisposed = true;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void filter(String filter) {
        this.myFilter.setSelectedItem(filter);
    }

    public void reset() {
        UiNotifyConnector.doWhenFirstShown((JComponent)((Object)this.getPluginTable()), () -> {
            this.requireShutdown = false;
            TableUtil.ensureSelectionExists((JTable)((Object)this.getPluginTable()));
        });
    }

    public PluginTable getPluginTable() {
        return this.pluginTable;
    }

    private static String getTextPrefix() {
        int fontSize = JBUI.scale((int)12);
        int m1 = JBUI.scale((int)2);
        int m2 = JBUI.scale((int)5);
        return String.format("<html><head>    <style type=\"text/css\">        p {            font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx        }    </style></head><body style=\"font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx;\">", fontSize, m1, m1, fontSize, m2, m2);
    }

    public PluginTableModel getPluginsModel() {
        return this.pluginsModel;
    }

    protected void installTableActions() {
        this.pluginTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PluginManagerMain.this.refresh();
            }
        });
        PopupHandler.installUnknownPopupHandler((JComponent)((Object)this.pluginTable), (ActionGroup)this.getActionGroup(false), (ActionManager)ActionManager.getInstance());
        new MySpeedSearchBar(this.pluginTable);
    }

    public void refresh() {
        IdeaPluginDescriptor[] descriptors = this.pluginTable.getSelectedObjects();
        IdeaPluginDescriptor plugin = descriptors != null && descriptors.length == 1 ? descriptors[0] : null;
        PluginManagerMain.pluginInfoUpdate(plugin, this.myFilter.getFilter(), this.myDescriptionTextArea, this.myPluginHeaderPanel);
        this.myActionToolbar.updateActionsImmediately();
        JComponent parent = (JComponent)this.myHeader.getParent();
        parent.revalidate();
        parent.repaint();
    }

    public void setRequireShutdown(boolean val) {
        this.requireShutdown |= val;
    }

    public List<IdeaPluginDescriptorImpl> getDependentList(IdeaPluginDescriptorImpl pluginDescriptor) {
        return this.pluginsModel.dependent(pluginDescriptor);
    }

    protected void modifyPluginsList(List<IdeaPluginDescriptor> list2) {
        IdeaPluginDescriptor[] selected = this.pluginTable.getSelectedObjects();
        this.pluginsModel.updatePluginsList(list2);
        this.pluginsModel.filter(this.myFilter.getFilter().toLowerCase());
        if (selected != null) {
            this.select(selected);
        }
    }

    protected abstract ActionGroup getActionGroup(boolean var1);

    protected abstract PluginManagerMain getAvailable();

    protected abstract PluginManagerMain getInstalled();

    public JPanel getMainPanel() {
        return this.main;
    }

    protected boolean acceptHost(String host) {
        return true;
    }

    protected void loadPluginsFromHostInBackground() {
        this.setDownloadStatus(true);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ArrayList list2 = ContainerUtil.newArrayList();
            LinkedHashMap errors = ContainerUtil.newLinkedHashMap();
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            List<String> hosts = RepositoryHelper.getPluginHosts();
            HashSet unique = ContainerUtil.newHashSet();
            for (String host : hosts) {
                try {
                    if (host != null && !this.acceptHost(host)) continue;
                    List<IdeaPluginDescriptor> plugins2 = RepositoryHelper.loadPlugins(host, (ProgressIndicator)indicator);
                    for (IdeaPluginDescriptor plugin : plugins2) {
                        if (!unique.add(plugin.getPluginId())) continue;
                        list2.add(plugin);
                    }
                }
                catch (FileNotFoundException e) {
                    LOG.info(host, (Throwable)e);
                }
                catch (IOException e) {
                    LOG.info(host, (Throwable)e);
                    if (host == ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl()) continue;
                    errors.put(host, String.format("'%s' for '%s'", e.getMessage(), host));
                }
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                String cancel;
                String ok;
                String title;
                String message2;
                this.setDownloadStatus(false);
                if (!list2.isEmpty()) {
                    InstalledPluginsState state = InstalledPluginsState.getInstance();
                    for (IdeaPluginDescriptor descriptor : list2) {
                        state.onDescriptorDownload(descriptor);
                    }
                    this.modifyPluginsList(list2);
                    this.propagateUpdates(list2);
                }
                if (!errors.isEmpty() && Messages.showOkCancelDialog((String)(message2 = IdeBundle.message((String)"error.list.of.plugins.was.not.loaded", (Object[])new Object[]{StringUtil.join(errors.keySet(), (String)", "), StringUtil.join(errors.values(), (String)",\n")})), (String)(title = IdeBundle.message((String)"title.plugins", (Object[])new Object[0])), (String)(ok = CommonBundle.message((String)"button.retry", (Object[])new Object[0])), (String)(cancel = CommonBundle.getCancelButtonText()), (Icon)Messages.getErrorIcon()) == 0) {
                    this.loadPluginsFromHostInBackground();
                }
            });
        });
    }

    protected abstract void propagateUpdates(List<IdeaPluginDescriptor> var1);

    protected void setDownloadStatus(boolean status) {
        this.pluginTable.setPaintBusy(status);
        this.myBusy = status;
    }

    protected void loadAvailablePlugins() {
        try {
            List<IdeaPluginDescriptor> list2 = RepositoryHelper.loadCachedPlugins();
            if (list2 != null) {
                this.modifyPluginsList(list2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadPluginsFromHostInBackground();
    }

    public static boolean downloadPlugins(List<PluginNode> plugins2, List<PluginId> allPlugins, Runnable onSuccess, @Nullable Runnable cleanup) throws IOException {
        return PluginManagerMain.downloadPlugins(plugins2, allPlugins.stream().map(p -> new PluginNode((PluginId)p, p.getIdString(), "-1")).collect(Collectors.toList()), onSuccess, new PluginEnabler.HEADLESS(), cleanup);
    }

    public static boolean downloadPlugins(final List<PluginNode> plugins2, final List<IdeaPluginDescriptor> allPlugins, final Runnable onSuccess, final PluginEnabler pluginEnabler, final @Nullable Runnable cleanup) throws IOException {
        final boolean[] result2 = new boolean[1];
        try {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, IdeBundle.message((String)"progress.download.plugins", (Object[])new Object[0]), true, PluginManagerUISettings.getInstance()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginManagerMain$5", "run"));
                    }
                    try {
                        if (PluginInstaller.prepareToInstall(plugins2, allPlugins, pluginEnabler, indicator)) {
                            ApplicationManager.getApplication().invokeLater(onSuccess);
                            result2[0] = true;
                        }
                    }
                    finally {
                        if (cleanup != null) {
                            ApplicationManager.getApplication().invokeLater(cleanup);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        return result2[0];
    }

    public boolean isRequireShutdown() {
        return this.requireShutdown;
    }

    public void ignoreChanges() {
        this.requireShutdown = false;
    }

    public static void pluginInfoUpdate(IdeaPluginDescriptor plugin, @Nullable String filter, @NotNull JEditorPane descriptionTextArea, @NotNull PluginHeaderPanel header) {
        String changeNotes;
        if (descriptionTextArea == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionTextArea", "com/intellij/ide/plugins/PluginManagerMain", "pluginInfoUpdate"));
        }
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/intellij/ide/plugins/PluginManagerMain", "pluginInfoUpdate"));
        }
        if (plugin == null) {
            PluginManagerMain.setTextValue(null, filter, descriptionTextArea);
            header.getPanel().setVisible(false);
            return;
        }
        StringBuilder sb = new StringBuilder();
        header.setPlugin(plugin);
        String description = plugin.getDescription();
        if (!StringUtil.isEmptyOrSpaces((String)description)) {
            sb.append(description);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(changeNotes = plugin.getChangeNotes()))) {
            sb.append("<h4>Change Notes</h4>");
            sb.append(changeNotes);
        }
        if (!plugin.isBundled()) {
            String size;
            String pluginDescriptorUrl;
            String vendor = plugin.getVendor();
            String vendorEmail = plugin.getVendorEmail();
            String vendorUrl = plugin.getVendorUrl();
            if (!(StringUtil.isEmptyOrSpaces((String)vendor) && StringUtil.isEmptyOrSpaces((String)vendorEmail) && StringUtil.isEmptyOrSpaces((String)vendorUrl))) {
                sb.append("<h4>Vendor</h4>");
                if (!StringUtil.isEmptyOrSpaces((String)vendor)) {
                    sb.append(vendor);
                }
                if (!StringUtil.isEmptyOrSpaces((String)vendorUrl)) {
                    sb.append("<br>").append(PluginManagerMain.composeHref(vendorUrl));
                }
                if (!StringUtil.isEmptyOrSpaces((String)vendorEmail)) {
                    sb.append("<br>").append(HTML_PREFIX).append("mailto:").append(vendorEmail).append("\">").append(vendorEmail).append(HTML_SUFFIX);
                }
            }
            if (!StringUtil.isEmptyOrSpaces((String)(pluginDescriptorUrl = plugin.getUrl()))) {
                sb.append("<h4>Plugin homepage</h4>").append(PluginManagerMain.composeHref(pluginDescriptorUrl));
            }
            String string = size = plugin instanceof PluginNode ? ((PluginNode)plugin).getSize() : null;
            if (!StringUtil.isEmptyOrSpaces((String)size)) {
                sb.append("<h4>Size</h4>").append(PluginManagerColumnInfo.getFormattedSize(size));
            }
        }
        PluginManagerMain.setTextValue(sb, filter, descriptionTextArea);
    }

    private static void setTextValue(@Nullable StringBuilder text2, @Nullable String filter, JEditorPane pane) {
        if (text2 != null) {
            text2.insert(0, PluginManagerMain.getTextPrefix());
            text2.append(TEXT_SUFFIX);
            pane.setText(SearchUtil.markup(text2.toString(), filter).trim());
            pane.setCaretPosition(0);
        } else {
            pane.setText(PluginManagerMain.getTextPrefix() + TEXT_SUFFIX);
        }
    }

    private static String composeHref(String vendorUrl) {
        return HTML_PREFIX + vendorUrl + "\">" + vendorUrl + HTML_SUFFIX;
    }

    public boolean isModified() {
        return this.requireShutdown;
    }

    public String apply() {
        String applyMessage = this.canApply();
        if (applyMessage != null) {
            return applyMessage;
        }
        this.setRequireShutdown(true);
        return null;
    }

    @Nullable
    protected String canApply() {
        return null;
    }

    private void createUIComponents() {
        this.myHeader = new JPanel(new BorderLayout()){

            @Override
            public Color getBackground() {
                return UIUtil.getTextFieldBackground();
            }
        };
    }

    public void select(IdeaPluginDescriptor ... descriptors) {
        this.pluginTable.select(descriptors);
    }

    protected static boolean isAccepted(@Nullable String filter, @NotNull Set<String> search, @NotNull IdeaPluginDescriptor descriptor) {
        if (search == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "search", "com/intellij/ide/plugins/PluginManagerMain", "isAccepted"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/plugins/PluginManagerMain", "isAccepted"));
        }
        if (StringUtil.isEmpty((String)filter)) {
            return true;
        }
        if (StringUtil.containsIgnoreCase((String)descriptor.getName(), (String)filter) || PluginManagerMain.isAccepted(search, filter, descriptor.getName())) {
            return true;
        }
        if (PluginManagerMain.isAccepted(search, filter, descriptor.getDescription())) {
            return true;
        }
        String category = descriptor.getCategory();
        return category != null && (StringUtil.containsIgnoreCase((String)category, (String)filter) || PluginManagerMain.isAccepted(search, filter, category));
    }

    private static boolean isAccepted(@NotNull Set<String> search, @NotNull String filter, @Nullable String description) {
        if (search == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "search", "com/intellij/ide/plugins/PluginManagerMain", "isAccepted"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/ide/plugins/PluginManagerMain", "isAccepted"));
        }
        if (StringUtil.isEmpty((String)description)) {
            return false;
        }
        if (filter.length() <= 2) {
            return false;
        }
        Set words = SearchableOptionsRegistrar.getInstance().getProcessedWords(description);
        if (words.contains(filter)) {
            return true;
        }
        if (search.isEmpty()) {
            return false;
        }
        HashSet<String> descriptionSet = new HashSet<String>(search);
        descriptionSet.removeAll(words);
        return descriptionSet.isEmpty();
    }

    public static boolean suggestToEnableInstalledDependantPlugins(PluginEnabler pluginEnabler, List<PluginNode> list2) {
        HashSet<IdeaPluginDescriptor> disabled = new HashSet<IdeaPluginDescriptor>();
        HashSet<IdeaPluginDescriptor> disabledDependants = new HashSet<IdeaPluginDescriptor>();
        for (PluginNode node : list2) {
            List<PluginId> depends;
            PluginId pluginId = node.getPluginId();
            if (pluginEnabler.isDisabled(pluginId)) {
                disabled.add(node);
            }
            if ((depends = node.getDepends()) == null) continue;
            HashSet<PluginId> optionalDeps = new HashSet<PluginId>(Arrays.asList(node.getOptionalDependentPluginIds()));
            for (PluginId dependantId : depends) {
                IdeaPluginDescriptor pluginDescriptor2;
                if (optionalDeps.contains(dependantId) || (pluginDescriptor2 = PluginManager.getPlugin(dependantId)) == null || !pluginEnabler.isDisabled(dependantId)) continue;
                disabledDependants.add(pluginDescriptor2);
            }
        }
        if (!disabled.isEmpty() || !disabledDependants.isEmpty()) {
            int result2;
            String message2 = "";
            if (disabled.size() == 1) {
                message2 = message2 + "Updated plugin '" + ((IdeaPluginDescriptor)disabled.iterator().next()).getName() + "' is disabled.";
            } else if (!disabled.isEmpty()) {
                message2 = message2 + "Updated plugins " + StringUtil.join(disabled, pluginDescriptor -> pluginDescriptor.getName(), (String)", ") + " are disabled.";
            }
            if (!disabledDependants.isEmpty()) {
                message2 = message2 + "<br>";
                message2 = message2 + "Updated plugin" + (list2.size() > 1 ? "s depend " : " depends ") + "on disabled";
                message2 = disabledDependants.size() == 1 ? message2 + " plugin '" + ((IdeaPluginDescriptor)disabledDependants.iterator().next()).getName() + "'." : message2 + " plugins " + StringUtil.join(disabledDependants, pluginDescriptor -> pluginDescriptor.getName(), (String)", ") + ".";
            }
            message2 = message2 + " Disabled plugins " + (disabled.isEmpty() ? "and plugins which depend on disabled " : "") + "won't be activated after restart.";
            if (!disabled.isEmpty() && !disabledDependants.isEmpty()) {
                result2 = Messages.showYesNoCancelDialog((String)XmlStringUtil.wrapInHtml((CharSequence)message2), (String)CommonBundle.getWarningTitle(), (String)"Enable all", (String)("Enable updated plugin" + (disabled.size() > 1 ? "s" : "")), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
                if (result2 == 2) {
                    return false;
                }
            } else {
                message2 = message2 + "<br>Would you like to enable ";
                message2 = !disabled.isEmpty() ? message2 + "updated plugin" + (disabled.size() > 1 ? "s" : "") : message2 + "plugin dependenc" + (disabledDependants.size() > 1 ? "ies" : "y");
                result2 = Messages.showYesNoDialog((String)XmlStringUtil.wrapInHtml((CharSequence)(message2 = message2 + "?")), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getQuestionIcon());
                if (result2 == 1) {
                    return false;
                }
            }
            if (result2 == 0) {
                disabled.addAll(disabledDependants);
                pluginEnabler.enablePlugins(disabled);
            } else if (result2 == 1 && !disabled.isEmpty()) {
                pluginEnabler.enablePlugins(disabled);
            }
            return true;
        }
        return false;
    }

    public static void notifyPluginsUpdated(@Nullable Project project2) {
        final ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
        String action = IdeBundle.message((String)(app.isRestartCapable() ? "ide.restart.action" : "ide.shutdown.action"), (Object[])new Object[0]);
        String message2 = IdeBundle.message((String)"ide.restart.required.notification", (Object[])new Object[]{action, ApplicationNamesInfo.getInstance().getFullProductName()});
        NotificationListener listener2 = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/ide/plugins/PluginManagerMain$7", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/plugins/PluginManagerMain$7", "hyperlinkUpdate"));
                }
                notification.expire();
                app.restart(true);
            }
        };
        UpdateChecker.NOTIFICATIONS.createNotification(title, XmlStringUtil.wrapInHtml((CharSequence)message2), NotificationType.INFORMATION, listener2).notify(project2);
    }

    protected DefaultActionGroup createSortersGroup() {
        DefaultActionGroup group = new DefaultActionGroup("Sort by", true);
        group.addAction((AnAction)new SortByStatusAction(this.pluginTable, this.pluginsModel));
        return group;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JEditorPane jEditorPane;
        JBScrollPane jBScrollPane;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.main = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setPreferredSize(new Dimension(800, 600));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myActionsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myToolbarPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 1, 1, 2, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setOneTouchExpandable(false);
        jPanel6.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myInfoPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setPreferredSize(new Dimension(300, 200));
        jPanel2.setMinimumSize(new Dimension(50, 50));
        jSplitPane.setRightComponent(jPanel2);
        this.myDescriptionScrollPane = jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, "Center");
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myDescriptionTextArea = jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setContentType("text/html");
        jEditorPane.setMaximumSize(new Dimension(-1, -1));
        jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jBScrollPane.setViewportView(jEditorPane);
        JPanel jPanel7 = this.myHeader;
        jPanel2.add((Component)jPanel7, "North");
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(2, 10, 2, 6), null, 0, 0, null, null));
        this.myTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setPreferredSize(new Dimension(300, 200));
        jPanel.setMinimumSize(new Dimension(50, 50));
        jSplitPane.setLeftComponent(jPanel);
        this.myPanelDescription = jBLabel = new JBLabel();
        jBLabel.setEnabled(false);
        jBLabel.setText("Check or uncheck a plugin to enable or disable it.");
        jPanel5.add((Component)jBLabel, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.main;
    }

    protected class RefreshAction
    extends DumbAwareAction {
        public RefreshAction() {
            super("Reload List of Plugins", "Reload list of plugins", AllIcons.Actions.Refresh);
        }

        public void actionPerformed(AnActionEvent e) {
            PluginManagerMain.this.loadAvailablePlugins();
            PluginManagerMain.this.myFilter.setFilter("");
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(!PluginManagerMain.this.myBusy);
        }
    }

    public class MyPluginsFilter
    extends FilterComponent {
        public MyPluginsFilter() {
            super("PLUGIN_FILTER", 5);
        }

        public void filter() {
            PluginManagerMain.this.getPluginTable().putClientProperty("SEARCH_QUERY", this.getFilter());
            PluginManagerMain.this.pluginsModel.filter(this.getFilter().toLowerCase());
            TableUtil.ensureSelectionExists((JTable)((Object)PluginManagerMain.this.getPluginTable()));
        }
    }

    public static interface PluginEnabler {
        public void enablePlugins(Set<IdeaPluginDescriptor> var1);

        public void disablePlugins(Set<IdeaPluginDescriptor> var1);

        public boolean isDisabled(PluginId var1);

        public static class UI
        implements PluginEnabler {
            @NotNull
            private final InstalledPluginsTableModel pluginsModel;

            public UI(@NotNull InstalledPluginsTableModel model) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/plugins/PluginManagerMain$PluginEnabler$UI", "<init>"));
                }
                this.pluginsModel = model;
            }

            @Override
            public void enablePlugins(Set<IdeaPluginDescriptor> disabled) {
                this.pluginsModel.enableRows(disabled.toArray(new IdeaPluginDescriptor[0]), true);
            }

            @Override
            public void disablePlugins(Set<IdeaPluginDescriptor> disabled) {
                this.pluginsModel.enableRows(disabled.toArray(new IdeaPluginDescriptor[0]), false);
            }

            @Override
            public boolean isDisabled(PluginId pluginId) {
                return this.pluginsModel.isDisabled(pluginId);
            }
        }

        public static class HEADLESS
        implements PluginEnabler {
            @Override
            public void enablePlugins(Set<IdeaPluginDescriptor> disabled) {
                for (IdeaPluginDescriptor descriptor : disabled) {
                    PluginManagerCore.enablePlugin(descriptor.getPluginId().getIdString());
                }
            }

            @Override
            public void disablePlugins(Set<IdeaPluginDescriptor> disabled) {
                for (IdeaPluginDescriptor descriptor : disabled) {
                    PluginManagerCore.disablePlugin(descriptor.getPluginId().getIdString());
                }
            }

            @Override
            public boolean isDisabled(PluginId pluginId) {
                return this.isDisabled(pluginId.getIdString());
            }

            public boolean isDisabled(String pluginId) {
                return PluginManagerCore.getDisabledPlugins().contains(pluginId);
            }
        }
    }

    private static class MySpeedSearchBar
    extends SpeedSearchBase<PluginTable> {
        public MySpeedSearchBar(PluginTable cmp) {
            super(cmp);
        }

        @Override
        protected int convertIndexToModel(int viewIndex) {
            return ((PluginTable)((Object)this.getComponent())).convertRowIndexToModel(viewIndex);
        }

        @Override
        public int getSelectedIndex() {
            return ((PluginTable)((Object)this.myComponent)).getSelectedRow();
        }

        @Override
        public Object[] getAllElements() {
            return ((PluginTable)((Object)this.myComponent)).getElements();
        }

        @Override
        public String getElementText(Object element) {
            return ((IdeaPluginDescriptor)element).getName();
        }

        @Override
        public void selectElement(Object element, String selectedText) {
            for (int i2 = 0; i2 < ((PluginTable)((Object)this.myComponent)).getRowCount(); ++i2) {
                if (!((PluginTable)((Object)this.myComponent)).getObjectAt(i2).getName().equals(((IdeaPluginDescriptor)element).getName())) continue;
                ((PluginTable)((Object)this.myComponent)).setRowSelectionInterval(i2, i2);
                TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
                break;
            }
        }
    }

    public static class MyHyperlinkListener
    implements HyperlinkListener {
        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    URL url = e.getURL();
                    if (url != null) {
                        BrowserUtil.browse((URL)url);
                    }
                }
            }
        }
    }
}

