/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectViewFileNestingService;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.NestingTreeNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestingTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    private static final Logger LOG = Logger.getInstance(NestingTreeStructureProvider.class);
    private long myBaseListModCount = -1L;
    private Set<ProjectViewFileNestingService.NestingRule> myNestingRules;

    @NotNull
    private Collection<ProjectViewFileNestingService.NestingRule> getNestingRules() {
        ProjectViewFileNestingService fileNestingService = ProjectViewFileNestingService.getInstance();
        List<ProjectViewFileNestingService.NestingRule> baseRules = fileNestingService.getRules();
        long modCount = fileNestingService.getModificationCount();
        if (this.myNestingRules == null || this.myBaseListModCount != modCount) {
            this.myNestingRules = new THashSet();
            this.myBaseListModCount = modCount;
            MultiMap childToParentSuffix = new MultiMap();
            MultiMap parentToChildSuffix = new MultiMap();
            for (ProjectViewFileNestingService.NestingRule rule : baseRules) {
                String parentFileSuffix = rule.getParentFileSuffix();
                String childFileSuffix = rule.getChildFileSuffix();
                if (parentFileSuffix.isEmpty() || childFileSuffix.isEmpty() || parentFileSuffix.equals(childFileSuffix)) continue;
                this.myNestingRules.add(rule);
                childToParentSuffix.putValue((Object)childFileSuffix, (Object)parentFileSuffix);
                parentToChildSuffix.putValue((Object)parentFileSuffix, (Object)childFileSuffix);
                for (String s : parentToChildSuffix.get((Object)childFileSuffix)) {
                    this.myNestingRules.add(new ProjectViewFileNestingService.NestingRule(parentFileSuffix, s));
                    parentToChildSuffix.putValue((Object)parentFileSuffix, (Object)s);
                    childToParentSuffix.putValue((Object)s, (Object)parentFileSuffix);
                }
                for (String s : childToParentSuffix.get((Object)parentFileSuffix)) {
                    this.myNestingRules.add(new ProjectViewFileNestingService.NestingRule(s, childFileSuffix));
                    parentToChildSuffix.putValue((Object)s, (Object)childFileSuffix);
                    childToParentSuffix.putValue((Object)childFileSuffix, (Object)s);
                }
            }
        }
        Set<ProjectViewFileNestingService.NestingRule> set2 = this.myNestingRules;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "getNestingRules"));
        }
        return set2;
    }

    @NotNull
    private static Collection<ProjectViewFileNestingService.NestingRule> getNestingRulesStatic(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "getNestingRulesStatic"));
        }
        for (TreeStructureProvider provider : (TreeStructureProvider[])Extensions.getExtensions((ExtensionPointName)TreeStructureProvider.EP_NAME, (AreaInstance)project2)) {
            if (!(provider instanceof NestingTreeStructureProvider)) continue;
            Collection<ProjectViewFileNestingService.NestingRule> collection = ((NestingTreeStructureProvider)provider).getNestingRules();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "getNestingRulesStatic"));
            }
            return collection;
        }
        List<ProjectViewFileNestingService.NestingRule> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "getNestingRulesStatic"));
        }
        return list2;
    }

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children2, ViewSettings settings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "modify"));
        }
        if (children2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "modify"));
        }
        if (!(settings instanceof ProjectViewSettings) || !((ProjectViewSettings)settings).isUseFileNestingRules()) {
            Collection<AbstractTreeNode> collection = children2;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "modify"));
            }
            return collection;
        }
        if (!(parent instanceof PsiDirectoryNode)) {
            Collection<AbstractTreeNode> collection = children2;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "modify"));
            }
            return collection;
        }
        Collection<ProjectViewFileNestingService.NestingRule> rules = this.getNestingRules();
        if (rules.isEmpty()) {
            Collection<AbstractTreeNode> collection = children2;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "modify"));
            }
            return collection;
        }
        MultiMap<PsiFileNode, PsiFileNode> parentToChildren = NestingTreeStructureProvider.calcParentToChildren(children2, rules);
        if (parentToChildren.isEmpty()) {
            Collection<AbstractTreeNode> collection = children2;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "modify"));
            }
            return collection;
        }
        ArrayList<AbstractTreeNode> newChildren = new ArrayList<AbstractTreeNode>(children2.size() - parentToChildren.size());
        THashSet childrenToMoveDown = new THashSet(parentToChildren.values());
        for (AbstractTreeNode node : children2) {
            if (!(node instanceof PsiFileNode)) {
                newChildren.add(node);
                continue;
            }
            if (childrenToMoveDown.contains(node)) continue;
            Collection childrenOfThisFile = parentToChildren.get((Object)((PsiFileNode)node));
            if (childrenOfThisFile.isEmpty()) {
                newChildren.add(node);
                continue;
            }
            newChildren.add((AbstractTreeNode)new NestingTreeNode((PsiFileNode)node, childrenOfThisFile));
        }
        ArrayList<AbstractTreeNode> arrayList = newChildren;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "modify"));
        }
        return arrayList;
    }

    public static Collection<ChildFileInfo> getFilesShownAsChildrenInProjectView(@NotNull Project project2, @NotNull VirtualFile parentFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "getFilesShownAsChildrenInProjectView"));
        }
        if (parentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFile", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "getFilesShownAsChildrenInProjectView"));
        }
        LOG.assertTrue(!parentFile.isDirectory());
        AbstractProjectViewPane pane = ProjectView.getInstance(project2).getProjectViewPaneById("ProjectPane");
        if (pane instanceof ProjectViewPane && !((ProjectViewPane)pane).isUseFileNestingRules()) {
            return Collections.emptyList();
        }
        VirtualFile dir = parentFile.getParent();
        if (dir == null) {
            return Collections.emptyList();
        }
        Collection<ProjectViewFileNestingService.NestingRule> rules = NestingTreeStructureProvider.getNestingRulesStatic(project2);
        if (rules.isEmpty()) {
            return Collections.emptyList();
        }
        VirtualFile[] children2 = dir.getChildren();
        if (children2.length <= 1) {
            return Collections.emptyList();
        }
        Collection<ProjectViewFileNestingService.NestingRule> rulesWhereItCanBeParent = NestingTreeStructureProvider.filterRules(rules, parentFile.getName(), true);
        if (rulesWhereItCanBeParent.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<ProjectViewFileNestingService.NestingRule> rulesWhereItCanBeChild = NestingTreeStructureProvider.filterRules(rules, parentFile.getName(), false);
        SmartList result2 = new SmartList();
        for (VirtualFile child : children2) {
            String baseName;
            Couple<Boolean> c;
            String childName;
            if (child.isDirectory() || child.equals(parentFile)) continue;
            for (ProjectViewFileNestingService.NestingRule rule : rulesWhereItCanBeChild) {
                childName = child.getName();
                c = NestingTreeStructureProvider.checkMatchingAsParentOrChild(rule, childName);
                boolean matchesParent = (Boolean)c.first;
                if (!matchesParent) continue;
                baseName = childName.substring(0, childName.length() - rule.getParentFileSuffix().length());
                if (!parentFile.getName().equals(baseName + rule.getChildFileSuffix())) continue;
                return Collections.emptyList();
            }
            for (ProjectViewFileNestingService.NestingRule rule : rulesWhereItCanBeParent) {
                childName = child.getName();
                c = NestingTreeStructureProvider.checkMatchingAsParentOrChild(rule, childName);
                boolean matchesChild = (Boolean)c.second;
                if (!matchesChild) continue;
                baseName = childName.substring(0, childName.length() - rule.getChildFileSuffix().length());
                if (!parentFile.getName().equals(baseName + rule.getParentFileSuffix())) continue;
                result2.add((Object)new ChildFileInfo(child, baseName));
            }
        }
        return result2;
    }

    @NotNull
    private static Collection<ProjectViewFileNestingService.NestingRule> filterRules(@NotNull Collection<ProjectViewFileNestingService.NestingRule> rules, @NotNull String fileName, boolean parentNotChild) {
        if (rules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rules", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "filterRules"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "filterRules"));
        }
        SmartList result2 = new SmartList();
        for (ProjectViewFileNestingService.NestingRule rule : rules) {
            Couple<Boolean> c = NestingTreeStructureProvider.checkMatchingAsParentOrChild(rule, fileName);
            boolean matchesParent = (Boolean)c.first;
            boolean matchesChild = (Boolean)c.second;
            if (!matchesChild && !matchesParent) continue;
            if (matchesParent && parentNotChild) {
                result2.add((Object)rule);
            }
            if (!matchesChild || parentNotChild) continue;
            result2.add((Object)rule);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "filterRules"));
        }
        return smartList;
    }

    @NotNull
    private static MultiMap<PsiFileNode, PsiFileNode> calcParentToChildren(@NotNull Collection<AbstractTreeNode> nodes, @NotNull Collection<ProjectViewFileNestingService.NestingRule> rules) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "calcParentToChildren"));
        }
        if (rules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rules", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "calcParentToChildren"));
        }
        MultiMap parentToChildren = null;
        THashSet allChildNodes = null;
        THashMap baseNameAndRuleToEdge = null;
        for (AbstractTreeNode node : nodes) {
            PsiFile file2;
            if (!(node instanceof PsiFileNode) || (file2 = (PsiFile)((PsiFileNode)node).getValue()) == null) continue;
            for (ProjectViewFileNestingService.NestingRule rule : rules) {
                Edge<PsiFileNode> edge;
                String baseName;
                String fileName = file2.getName();
                Couple<Boolean> c = NestingTreeStructureProvider.checkMatchingAsParentOrChild(rule, fileName);
                boolean matchesParent = (Boolean)c.first;
                boolean matchesChild = (Boolean)c.second;
                if (!matchesChild && !matchesParent) continue;
                if (baseNameAndRuleToEdge == null) {
                    baseNameAndRuleToEdge = new THashMap();
                    parentToChildren = new MultiMap();
                    allChildNodes = new THashSet();
                }
                if (matchesParent) {
                    baseName = fileName.substring(0, fileName.length() - rule.getParentFileSuffix().length());
                    edge = NestingTreeStructureProvider.getOrCreateEdge((Map<Pair<String, ProjectViewFileNestingService.NestingRule>, Edge<PsiFileNode>>)baseNameAndRuleToEdge, baseName, rule);
                    ((Edge)edge).from = (Object)((PsiFileNode)node);
                    NestingTreeStructureProvider.updateInfoIfEdgeComplete((MultiMap<PsiFileNode, PsiFileNode>)parentToChildren, (Set<PsiFileNode>)allChildNodes, edge);
                }
                if (!matchesChild) continue;
                baseName = fileName.substring(0, fileName.length() - rule.getChildFileSuffix().length());
                edge = NestingTreeStructureProvider.getOrCreateEdge((Map<Pair<String, ProjectViewFileNestingService.NestingRule>, Edge<PsiFileNode>>)baseNameAndRuleToEdge, baseName, rule);
                ((Edge)edge).to = (Object)((PsiFileNode)node);
                NestingTreeStructureProvider.updateInfoIfEdgeComplete((MultiMap<PsiFileNode, PsiFileNode>)parentToChildren, (Set<PsiFileNode>)allChildNodes, edge);
            }
        }
        MultiMap multiMap = parentToChildren == null ? MultiMap.empty() : parentToChildren;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "calcParentToChildren"));
        }
        return multiMap;
    }

    private static Couple<Boolean> checkMatchingAsParentOrChild(@NotNull ProjectViewFileNestingService.NestingRule rule, @NotNull String fileName) {
        boolean matchesChild;
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "checkMatchingAsParentOrChild"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "checkMatchingAsParentOrChild"));
        }
        boolean matchesParent = !fileName.equals(rule.getParentFileSuffix()) && fileName.endsWith(rule.getParentFileSuffix());
        boolean bl = matchesChild = !fileName.equals(rule.getChildFileSuffix()) && fileName.endsWith(rule.getChildFileSuffix());
        if (matchesParent && matchesChild) {
            if (rule.getParentFileSuffix().length() > rule.getChildFileSuffix().length()) {
                matchesChild = false;
            } else {
                matchesParent = false;
            }
        }
        return Couple.of((Object)matchesParent, (Object)matchesChild);
    }

    @NotNull
    private static Edge<PsiFileNode> getOrCreateEdge(@NotNull Map<Pair<String, ProjectViewFileNestingService.NestingRule>, Edge<PsiFileNode>> baseNameAndRuleToEdge, @NotNull String baseName, @NotNull ProjectViewFileNestingService.NestingRule rule) {
        if (baseNameAndRuleToEdge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseNameAndRuleToEdge", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "getOrCreateEdge"));
        }
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "getOrCreateEdge"));
        }
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "getOrCreateEdge"));
        }
        Pair baseNameAndRule = Pair.create((Object)baseName, (Object)rule);
        Edge<PsiFileNode> edge = baseNameAndRuleToEdge.get(baseNameAndRule);
        if (edge == null) {
            edge = new Edge();
            baseNameAndRuleToEdge.put((Pair<String, ProjectViewFileNestingService.NestingRule>)baseNameAndRule, edge);
        }
        Edge<PsiFileNode> edge2 = edge;
        if (edge2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "getOrCreateEdge"));
        }
        return edge2;
    }

    private static void updateInfoIfEdgeComplete(@NotNull MultiMap<PsiFileNode, PsiFileNode> parentToChildren, @NotNull Set<PsiFileNode> allChildNodes, @NotNull Edge<PsiFileNode> edge) {
        if (parentToChildren == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentToChildren", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "updateInfoIfEdgeComplete"));
        }
        if (allChildNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allChildNodes", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "updateInfoIfEdgeComplete"));
        }
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider", "updateInfoIfEdgeComplete"));
        }
        if (((Edge)edge).from != null && ((Edge)edge).to != null) {
            allChildNodes.add((PsiFileNode)((Object)((Edge)edge).to));
            parentToChildren.remove(((Edge)edge).to);
            if (!allChildNodes.contains(((Edge)edge).from)) {
                parentToChildren.putValue(((Edge)edge).from, ((Edge)edge).to);
            }
        }
    }

    public static class ChildFileInfo {
        @NotNull
        public final VirtualFile file;
        @NotNull
        public final String namePartCommonWithParentFile;

        public ChildFileInfo(@NotNull VirtualFile file2, @NotNull String namePartCommonWithParentFile) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider$ChildFileInfo", "<init>"));
            }
            if (namePartCommonWithParentFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namePartCommonWithParentFile", "com/intellij/ide/projectView/impl/NestingTreeStructureProvider$ChildFileInfo", "<init>"));
            }
            this.file = file2;
            this.namePartCommonWithParentFile = namePartCommonWithParentFile;
        }
    }

    private static class Edge<T> {
        @Nullable
        private T from;
        @Nullable
        private T to;

        private Edge() {
        }
    }
}

