/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ProjectViewNestingRulesProvider;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.containers.SortedList;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectViewFileNesting", storages={@Storage(value="ui.lnf.xml")})
public class ProjectViewFileNestingService
implements PersistentStateComponent<MyState>,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance(ProjectViewFileNestingService.class);
    private static final ExtensionPointName<ProjectViewNestingRulesProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.projectViewNestingRulesProvider");
    public static final NestingRule[] DEFAULT_NESTING_RULES = ProjectViewFileNestingService.loadDefaultNestingRules();
    private MyState myState = new MyState();
    private long myModCount = 0L;

    @NotNull
    public static ProjectViewFileNestingService getInstance() {
        ProjectViewFileNestingService projectViewFileNestingService = (ProjectViewFileNestingService)ServiceManager.getService(ProjectViewFileNestingService.class);
        if (projectViewFileNestingService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewFileNestingService", "getInstance"));
        }
        return projectViewFileNestingService;
    }

    @NotNull
    private static NestingRule[] loadDefaultNestingRules() {
        SortedList result2 = new SortedList(Comparator.comparing(o -> o.getParentFileSuffix()));
        ProjectViewNestingRulesProvider.Consumer consumer = new ProjectViewNestingRulesProvider.Consumer((List)result2){
            final /* synthetic */ List val$result;
            {
                this.val$result = list2;
            }

            public void addNestingRule(@NotNull String parentFileSuffix, @NotNull String childFileSuffix) {
                if (parentFileSuffix == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFileSuffix", "com/intellij/ide/projectView/impl/ProjectViewFileNestingService$1", "addNestingRule"));
                }
                if (childFileSuffix == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childFileSuffix", "com/intellij/ide/projectView/impl/ProjectViewFileNestingService$1", "addNestingRule"));
                }
                LOG.assertTrue(!parentFileSuffix.isEmpty() && !childFileSuffix.isEmpty(), (Object)"file suffix must not be empty");
                LOG.assertTrue(!parentFileSuffix.equals(childFileSuffix), (Object)("parent and child suffixes must be different: " + parentFileSuffix));
                this.val$result.add(new NestingRule(parentFileSuffix, childFileSuffix));
            }
        };
        for (ProjectViewNestingRulesProvider provider : (ProjectViewNestingRulesProvider[])EP_NAME.getExtensions()) {
            provider.addFileNestingRules(consumer);
        }
        NestingRule[] nestingRuleArray = result2.toArray(new NestingRule[0]);
        if (nestingRuleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewFileNestingService", "loadDefaultNestingRules"));
        }
        return nestingRuleArray;
    }

    public MyState getState() {
        return this.myState;
    }

    public void loadState(@NotNull MyState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/ide/projectView/impl/ProjectViewFileNestingService", "loadState"));
        }
        this.myState = state;
        ++this.myModCount;
    }

    @NotNull
    public List<NestingRule> getRules() {
        List<NestingRule> list2 = this.myState.myRules;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewFileNestingService", "getRules"));
        }
        return list2;
    }

    public void setRules(@NotNull List<NestingRule> rules) {
        if (rules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rules", "com/intellij/ide/projectView/impl/ProjectViewFileNestingService", "setRules"));
        }
        this.myState.myRules.clear();
        this.myState.myRules.addAll(rules);
        ++this.myModCount;
    }

    public long getModificationCount() {
        return this.myModCount;
    }

    public static class NestingRule {
        @NotNull
        private String myParentFileSuffix;
        @NotNull
        private String myChildFileSuffix;

        public NestingRule() {
            this("", "");
        }

        public NestingRule(@NotNull String parentFileSuffix, @NotNull String childFileSuffix) {
            if (parentFileSuffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFileSuffix", "com/intellij/ide/projectView/impl/ProjectViewFileNestingService$NestingRule", "<init>"));
            }
            if (childFileSuffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childFileSuffix", "com/intellij/ide/projectView/impl/ProjectViewFileNestingService$NestingRule", "<init>"));
            }
            this.myParentFileSuffix = parentFileSuffix;
            this.myChildFileSuffix = childFileSuffix;
        }

        @Attribute(value="parent-file-suffix")
        @NotNull
        public String getParentFileSuffix() {
            String string = this.myParentFileSuffix;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewFileNestingService$NestingRule", "getParentFileSuffix"));
            }
            return string;
        }

        public void setParentFileSuffix(@NotNull String parentFileSuffix) {
            if (parentFileSuffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFileSuffix", "com/intellij/ide/projectView/impl/ProjectViewFileNestingService$NestingRule", "setParentFileSuffix"));
            }
            this.myParentFileSuffix = parentFileSuffix;
        }

        @Attribute(value="child-file-suffix")
        @NotNull
        public String getChildFileSuffix() {
            String string = this.myChildFileSuffix;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/ProjectViewFileNestingService$NestingRule", "getChildFileSuffix"));
            }
            return string;
        }

        public void setChildFileSuffix(@NotNull String childFileSuffix) {
            if (childFileSuffix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childFileSuffix", "com/intellij/ide/projectView/impl/ProjectViewFileNestingService$NestingRule", "setChildFileSuffix"));
            }
            this.myChildFileSuffix = childFileSuffix;
        }

        public String toString() {
            return this.myParentFileSuffix + "->" + this.myChildFileSuffix;
        }

        public boolean equals(Object o) {
            return o instanceof NestingRule && this.myParentFileSuffix.equals(((NestingRule)o).myParentFileSuffix) && this.myChildFileSuffix.equals(((NestingRule)o).myChildFileSuffix);
        }

        public int hashCode() {
            return this.myParentFileSuffix.hashCode() + 239 * this.myChildFileSuffix.hashCode();
        }
    }

    public static class MyState {
        @Tag(value="nesting-rules")
        @AbstractCollection(surroundWithTag=false)
        public List<NestingRule> myRules = new SortedList(Comparator.comparing(o -> o.getParentFileSuffix()));

        public MyState() {
            this.myRules.addAll(Arrays.asList(DEFAULT_NESTING_RULES));
        }
    }
}

