/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractModuleNode
extends ProjectViewNode<Module>
implements NavigatableWithText {
    protected AbstractModuleNode(Project project2, Module module2, ViewSettings viewSettings) {
        super(project2, (Object)module2, viewSettings);
    }

    public void update(PresentationData presentation) {
        Module module2 = (Module)this.getValue();
        if (module2 == null || module2.isDisposed()) {
            this.setValue(null);
            return;
        }
        presentation.setPresentableText(module2.getName());
        if (this.showModuleNameInBold()) {
            presentation.addText(module2.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        presentation.setIcon(ModuleType.get((Module)module2).getIcon());
        presentation.setTooltip(ModuleType.get((Module)module2).getName());
    }

    protected boolean showModuleNameInBold() {
        return true;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        Module module2 = (Module)this.getValue();
        List<VirtualFile> list2 = module2 != null ? Arrays.asList(ModuleRootManager.getInstance((Module)module2).getContentRoots()) : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/AbstractModuleNode", "getRoots"));
        }
        return list2;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/nodes/AbstractModuleNode", "contains"));
        }
        Module module2 = (Module)this.getValue();
        if (module2 == null || module2.isDisposed()) {
            return false;
        }
        if (file2.getFileSystem() instanceof JarFileSystem) {
            VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar(file2);
            if (local == null) {
                return false;
            }
            file2 = local;
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public void navigate(boolean requestFocus) {
        Module module2 = (Module)this.getValue();
        if (module2 != null) {
            ProjectSettingsService.getInstance(this.myProject).openModuleSettings(module2);
        }
    }

    public String getNavigateActionText(boolean focusEditor) {
        return ActionsBundle.message((String)"action.ModuleSettings.navigate", (Object[])new Object[0]);
    }

    public boolean canNavigate() {
        return ProjectSettingsService.getInstance(this.myProject).canOpenModuleSettings() && this.getValue() != null;
    }

    public String getTestPresentation() {
        return "Module";
    }
}

