/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageElementNode
extends ProjectViewNode<PackageElement> {
    public PackageElementNode(@NotNull Project project2, PackageElement value2, ViewSettings viewSettings) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/nodes/PackageElementNode", "<init>"));
        }
        super(project2, (Object)value2, viewSettings);
    }

    public PackageElementNode(@NotNull Project project2, Object value2, ViewSettings viewSettings) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/nodes/PackageElementNode", "<init>"));
        }
        this(project2, (PackageElement)value2, viewSettings);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        PsiDirectory[] directories;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/nodes/PackageElementNode", "contains"));
        }
        if (!this.isUnderContent(file2) || this.getValue() == null) {
            return false;
        }
        for (PsiDirectory directory : directories = ((PackageElement)this.getValue()).getPackage().getDirectories()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)directory.getVirtualFile(), (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private boolean isUnderContent(VirtualFile file2) {
        Module module2;
        PackageElement element = (PackageElement)this.getValue();
        Module module3 = module2 = element == null ? null : element.getModule();
        if (module2 == null) {
            return ModuleUtilCore.projectContainsFile((Project)this.getProject(), (VirtualFile)file2, (boolean)this.isLibraryElement());
        }
        return ModuleUtilCore.moduleContainsFile((Module)module2, (VirtualFile)file2, (boolean)this.isLibraryElement());
    }

    private boolean isLibraryElement() {
        return this.getValue() != null && ((PackageElement)this.getValue()).isLibraryElement();
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        PsiFile[] packageChildren;
        PackageElement value2 = (PackageElement)this.getValue();
        if (value2 == null) {
            List<AbstractTreeNode> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageElementNode", "getChildren"));
            }
            return list2;
        }
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>();
        Module module2 = value2.getModule();
        PsiPackage aPackage = value2.getPackage();
        if (!this.getSettings().isFlattenPackages()) {
            PsiPackage[] subpackages;
            for (PsiPackage subpackage : subpackages = PackageUtil.getSubpackages(aPackage, module2, this.isLibraryElement())) {
                PackageUtil.addPackageAsChild(children2, subpackage, module2, this.getSettings(), this.isLibraryElement());
            }
        }
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(aPackage.getProject(), module2, this.isLibraryElement());
        for (PsiFile file2 : packageChildren = aPackage.getFiles(scopeToShow)) {
            if (file2.getVirtualFile() == null) continue;
            children2.add((AbstractTreeNode)new PsiFileNode(this.getProject(), file2, this.getSettings()));
        }
        ArrayList<AbstractTreeNode> arrayList = children2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageElementNode", "getChildren"));
        }
        return arrayList;
    }

    public boolean validate() {
        PackageElement value2 = (PackageElement)this.getValue();
        return value2 != null && value2.getPackage().isValid() && (value2.getModule() == null || !value2.getModule().isDisposed());
    }

    protected void update(PresentationData presentation) {
        try {
            if (this.validate()) {
                this.updateValidData(presentation, (PackageElement)this.getValue());
                return;
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        this.setValue(null);
    }

    private void updateValidData(PresentationData presentation, PackageElement value2) {
        PsiPackage aPackage = value2.getPackage();
        if (!this.getSettings().isFlattenPackages() && this.getSettings().isHideEmptyMiddlePackages() && PackageUtil.isPackageEmpty(aPackage, value2.getModule(), true, this.isLibraryElement())) {
            this.setValue(null);
            return;
        }
        Object parentValue = this.getParentValue();
        PsiPackage parentPackage = parentValue instanceof PackageElement ? ((PackageElement)parentValue).getPackage() : null;
        String qName = aPackage.getQualifiedName();
        String name2 = PackageUtil.getNodeName(this.getSettings(), aPackage, parentPackage, qName, this.showFQName(aPackage));
        presentation.setPresentableText(name2);
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
        for (ProjectViewNodeDecorator decorator : (ProjectViewNodeDecorator[])Extensions.getExtensions(ProjectViewNodeDecorator.EP_NAME, (AreaInstance)this.myProject)) {
            decorator.decorate(this, presentation);
        }
    }

    private boolean showFQName(PsiPackage aPackage) {
        return this.getSettings().isFlattenPackages() && !aPackage.getQualifiedName().isEmpty();
    }

    public String getTestPresentation() {
        PresentationData presentation = new PresentationData();
        this.update(presentation);
        return "PsiPackage: " + presentation.getPresentableText();
    }

    public boolean valueIsCut() {
        return this.getValue() != null && CopyPasteManager.getInstance().isCutElement((Object)((PackageElement)this.getValue()).getPackage());
    }

    @NotNull
    public VirtualFile[] getVirtualFiles() {
        PackageElement value2 = (PackageElement)this.getValue();
        if (value2 == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageElementNode", "getVirtualFiles"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        PsiDirectory[] directories = PackageUtil.getDirectories(value2.getPackage(), value2.getModule(), this.isLibraryElement());
        VirtualFile[] result2 = new VirtualFile[directories.length];
        for (int i2 = 0; i2 < directories.length; ++i2) {
            PsiDirectory directory = directories[i2];
            result2[i2] = directory.getVirtualFile();
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageElementNode", "getVirtualFiles"));
        }
        return result2;
    }

    public boolean canRepresent(Object element) {
        String aPackage;
        PackageElement packageElement;
        String otherPackage;
        if (super.canRepresent(element)) {
            return true;
        }
        PackageElement value2 = (PackageElement)this.getValue();
        if (value2 == null) {
            return true;
        }
        if (element instanceof PackageElement && (otherPackage = (packageElement = (PackageElement)element).getPackage().getQualifiedName()).equals(aPackage = value2.getPackage().getQualifiedName())) {
            return true;
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element;
            return Arrays.asList(value2.getPackage().getDirectories()).contains(directory);
        }
        return false;
    }

    public int getWeight() {
        return 0;
    }

    public String getTitle() {
        PackageElement packageElement = (PackageElement)this.getValue();
        if (packageElement == null) {
            return super.getTitle();
        }
        return packageElement.getPackage().getQualifiedName();
    }

    @Nullable
    public String getQualifiedNameSortKey() {
        PackageElement packageElement = (PackageElement)this.getValue();
        if (packageElement != null) {
            return packageElement.getPackage().getQualifiedName();
        }
        return null;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 4;
    }

    public boolean isAlwaysShowPlus() {
        for (VirtualFile dir : this.getVirtualFiles()) {
            if (dir.getChildren().length <= 0) continue;
            return true;
        }
        return false;
    }
}

