/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageElementNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.TreeViewUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageUtil {
    @NotNull
    public static PsiPackage[] getSubpackages(@NotNull PsiPackage aPackage, @Nullable Module module2, boolean searchInLibraries) {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getSubpackages"));
        }
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(aPackage.getProject(), module2, searchInLibraries);
        ArrayList<PsiPackage> result2 = new ArrayList<PsiPackage>();
        for (PsiPackage psiPackage : aPackage.getSubPackages(scopeToShow)) {
            String name2 = psiPackage.getName();
            if (name2 == null || name2.isEmpty()) continue;
            result2.add(psiPackage);
        }
        PsiPackage[] psiPackageArray = result2.toArray(new PsiPackage[result2.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getSubpackages"));
        }
        return psiPackageArray;
    }

    public static void addPackageAsChild(@NotNull Collection<AbstractTreeNode> children2, @NotNull PsiPackage aPackage, @Nullable Module module2, @NotNull ViewSettings settings, boolean inLibrary) {
        if (children2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "addPackageAsChild"));
        }
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "addPackageAsChild"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "addPackageAsChild"));
        }
        boolean shouldSkipPackage = settings.isHideEmptyMiddlePackages() && PackageUtil.isPackageEmpty(aPackage, module2, !settings.isFlattenPackages(), inLibrary);
        Project project2 = aPackage.getProject();
        if (!shouldSkipPackage) {
            children2.add((AbstractTreeNode)new PackageElementNode(project2, new PackageElement(module2, aPackage, inLibrary), settings));
        }
        if (settings.isFlattenPackages() || shouldSkipPackage) {
            PsiPackage[] subpackages;
            for (PsiPackage subpackage : subpackages = PackageUtil.getSubpackages(aPackage, module2, inLibrary)) {
                PackageUtil.addPackageAsChild(children2, subpackage, module2, settings, inLibrary);
            }
        }
    }

    public static boolean isPackageEmpty(@NotNull PsiPackage aPackage, @Nullable Module module2, boolean strictlyEmpty, boolean inLibrary) {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "isPackageEmpty"));
        }
        Project project2 = aPackage.getProject();
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(project2, module2, inLibrary);
        PsiFile[] children2 = aPackage.getFiles(scopeToShow);
        if (children2.length > 0) {
            return false;
        }
        PsiPackage[] subPackages = aPackage.getSubPackages(scopeToShow);
        if (strictlyEmpty) {
            return subPackages.length == 1;
        }
        return subPackages.length > 0;
    }

    @NotNull
    public static PsiDirectory[] getDirectories(@NotNull PsiPackage aPackage, @Nullable Module module2, boolean inLibrary) {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getDirectories"));
        }
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(aPackage.getProject(), module2, inLibrary);
        PsiDirectory[] psiDirectoryArray = aPackage.getDirectories(scopeToShow);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getDirectories"));
        }
        return psiDirectoryArray;
    }

    @NotNull
    public static GlobalSearchScope getScopeToShow(@NotNull Project project2, @Nullable Module module2, boolean forLibraries) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getScopeToShow"));
        }
        if (module2 == null) {
            if (forLibraries) {
                ProjectLibrariesSearchScope projectLibrariesSearchScope = new ProjectLibrariesSearchScope(project2);
                if (projectLibrariesSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getScopeToShow"));
                }
                return projectLibrariesSearchScope;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project2);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getScopeToShow"));
            }
            return globalSearchScope;
        }
        if (forLibraries) {
            ModuleLibrariesSearchScope moduleLibrariesSearchScope = new ModuleLibrariesSearchScope(module2);
            if (moduleLibrariesSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getScopeToShow"));
            }
            return moduleLibrariesSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleScope((Module)module2);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getScopeToShow"));
        }
        return globalSearchScope;
    }

    public static boolean isPackageDefault(@NotNull PsiPackage directoryPackage) {
        if (directoryPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryPackage", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "isPackageDefault"));
        }
        String qName = directoryPackage.getQualifiedName();
        return qName.isEmpty();
    }

    @NotNull
    public static Collection<AbstractTreeNode> createPackageViewChildrenOnFiles(@NotNull List<VirtualFile> sourceRoots, @NotNull Project project2, @NotNull ViewSettings settings, @Nullable Module module2, boolean inLibrary) {
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "createPackageViewChildrenOnFiles"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "createPackageViewChildrenOnFiles"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "createPackageViewChildrenOnFiles"));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>();
        HashSet<PsiPackage> topLevelPackages = new HashSet<PsiPackage>();
        for (VirtualFile root : sourceRoots) {
            ProgressManager.checkCanceled();
            PsiDirectory directory = psiManager.findDirectory(root);
            if (directory == null) continue;
            PsiPackage directoryPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (directoryPackage == null || PackageUtil.isPackageDefault(directoryPackage)) {
                PsiDirectory[] subdirectories;
                for (PsiDirectory subdirectory : subdirectories = directory.getSubdirectories()) {
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subdirectory);
                    if (aPackage == null || PackageUtil.isPackageDefault(aPackage)) continue;
                    topLevelPackages.add(aPackage);
                }
                children2.addAll(ProjectViewDirectoryHelper.getInstance(project2).getDirectoryChildren(directory, settings, false));
                continue;
            }
            topLevelPackages.add(directoryPackage);
        }
        for (PsiPackage topLevelPackage : topLevelPackages) {
            PackageUtil.addPackageAsChild(children2, topLevelPackage, module2, settings, inLibrary);
        }
        ArrayList<AbstractTreeNode> arrayList = children2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "createPackageViewChildrenOnFiles"));
        }
        return arrayList;
    }

    @NotNull
    public static String getNodeName(@NotNull ViewSettings settings, PsiPackage aPackage, PsiPackage parentPackageInTree, @NotNull String defaultShortName, boolean isFQNameShown) {
        String name2;
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getNodeName"));
        }
        if (defaultShortName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultShortName", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getNodeName"));
        }
        if (isFQNameShown) {
            name2 = settings.isAbbreviatePackageNames() ? (aPackage == null ? defaultShortName : TreeViewUtil.calcAbbreviatedPackageFQName(aPackage)) : (aPackage == null ? defaultShortName : aPackage.getQualifiedName());
        } else if (parentPackageInTree != null || aPackage != null && aPackage.getParentPackage() != null) {
            String parentPackageName;
            StringBuilder buf = new StringBuilder();
            buf.append(aPackage.getName());
            for (PsiPackage parentPackage = aPackage.getParentPackage(); !(parentPackage == null || parentPackageInTree != null && parentPackage.equals(parentPackageInTree) || (parentPackageName = parentPackage.getName()) == null || parentPackageName.isEmpty()); parentPackage = parentPackage.getParentPackage()) {
                buf.insert(0, ".");
                buf.insert(0, parentPackageName);
            }
            name2 = buf.toString();
        } else {
            name2 = defaultShortName;
        }
        String string = name2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/PackageUtil", "getNodeName"));
        }
        return string;
    }

    private static class ProjectLibrariesSearchScope
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        public ProjectLibrariesSearchScope(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ProjectLibrariesSearchScope", "<init>"));
            }
            super(project2);
            this.myFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ProjectLibrariesSearchScope", "contains"));
            }
            return this.myFileIndex.isInLibraryClasses(file2);
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ProjectLibrariesSearchScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ProjectLibrariesSearchScope", "compare"));
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ProjectLibrariesSearchScope", "isSearchInModuleContent"));
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }

    private static class ModuleLibrariesSearchScope
    extends GlobalSearchScope {
        private final Module myModule;

        public ModuleLibrariesSearchScope(@NotNull Module module2) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ModuleLibrariesSearchScope", "<init>"));
            }
            super(module2.getProject());
            this.myModule = module2;
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ModuleLibrariesSearchScope", "contains"));
            }
            OrderEntry orderEntry = ModuleRootManager.getInstance((Module)this.myModule).getFileIndex().getOrderEntryForFile(file2);
            return orderEntry instanceof JdkOrderEntry || orderEntry instanceof LibraryOrderEntry;
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ModuleLibrariesSearchScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ModuleLibrariesSearchScope", "compare"));
            }
            ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)this.myModule).getFileIndex();
            return Comparing.compare((Comparable)fileIndex.getOrderEntryForFile(file2), (Comparable)fileIndex.getOrderEntryForFile(file1));
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/ide/projectView/impl/nodes/PackageUtil$ModuleLibrariesSearchScope", "isSearchInModuleContent"));
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

