/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.java.ClassInitializerTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElementBase;
import com.intellij.ide.structureView.impl.java.PsiFieldTreeElement;
import com.intellij.ide.structureView.impl.java.PsiMethodTreeElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaClassTreeElement
extends JavaClassTreeElementBase<PsiClass> {
    private final Set<PsiClass> myParents;

    public JavaClassTreeElement(PsiClass cls, boolean inherited, Set<PsiClass> parents) {
        super(inherited, cls);
        this.myParents = parents;
        this.myParents.add(cls);
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        Collection<StructureViewTreeElement> collection = this.getClassChildren();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/java/JavaClassTreeElement", "getChildrenBase"));
        }
        return collection;
    }

    private Collection<StructureViewTreeElement> getClassChildren() {
        PsiClass aClass = (PsiClass)this.getElement();
        if (aClass == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<PsiElement> members = JavaClassTreeElement.getOwnChildren(aClass);
        ArrayList<StructureViewTreeElement> children2 = new ArrayList<StructureViewTreeElement>(members.size());
        for (PsiElement child : members) {
            if (!child.isValid()) continue;
            if (child instanceof PsiClass && !this.myParents.contains((PsiClass)child)) {
                children2.add(new JavaClassTreeElement((PsiClass)child, false, this.myParents));
                continue;
            }
            if (child instanceof PsiField) {
                children2.add(new PsiFieldTreeElement((PsiField)child, false));
                continue;
            }
            if (child instanceof PsiMethod) {
                children2.add(new PsiMethodTreeElement((PsiMethod)child, false));
                continue;
            }
            if (!(child instanceof PsiClassInitializer)) continue;
            children2.add(new ClassInitializerTreeElement((PsiClassInitializer)child));
        }
        return children2;
    }

    static LinkedHashSet<PsiElement> getOwnChildren(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/ide/structureView/impl/java/JavaClassTreeElement", "getOwnChildren"));
        }
        LinkedHashSet<PsiElement> members = new LinkedHashSet<PsiElement>();
        JavaClassTreeElement.addPhysicalElements((PsiMember[])aClass.getFields(), members, aClass);
        JavaClassTreeElement.addPhysicalElements((PsiMember[])aClass.getMethods(), members, aClass);
        JavaClassTreeElement.addPhysicalElements((PsiMember[])aClass.getInnerClasses(), members, aClass);
        JavaClassTreeElement.addPhysicalElements((PsiMember[])aClass.getInitializers(), members, aClass);
        return members;
    }

    private static void addPhysicalElements(@NotNull PsiMember[] elements, @NotNull Collection<PsiElement> to, @NotNull PsiClass aClass) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/ide/structureView/impl/java/JavaClassTreeElement", "addPhysicalElements"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/ide/structureView/impl/java/JavaClassTreeElement", "addPhysicalElements"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/ide/structureView/impl/java/JavaClassTreeElement", "addPhysicalElements"));
        }
        for (PsiMember element : elements) {
            PsiElement mirror = PsiImplUtil.handleMirror((PsiElement)element);
            if (mirror instanceof LightElement || !(mirror instanceof PsiMember) || !aClass.equals(((PsiMember)mirror).getContainingClass())) continue;
            to.add(mirror);
        }
    }

    public Set<PsiClass> getParents() {
        return this.myParents;
    }

    public String getPresentableText() {
        return ((PsiClass)this.getElement()).getName();
    }

    @Override
    public boolean isPublic() {
        return ((PsiClass)this.getElement()).getParent() instanceof PsiFile || super.isPublic();
    }
}

