/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ConfigurableFactory;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.Consumer;
import javax.swing.JComponent;

public class SetTodoFilterAction
extends AnAction
implements CustomComponentAction {
    private final Project myProject;
    private final TodoPanelSettings myToDoSettings;
    private final Consumer<TodoFilter> myTodoFilterConsumer;

    public SetTodoFilterAction(Project project2, TodoPanelSettings toDoSettings, Consumer<TodoFilter> todoFilterConsumer) {
        super(IdeBundle.message((String)"action.filter.todo.items", (Object[])new Object[0]), null, AllIcons.General.Filter);
        this.myProject = project2;
        this.myToDoSettings = toDoSettings;
        this.myTodoFilterConsumer = todoFilterConsumer;
    }

    public void actionPerformed(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        JComponent button = (JComponent)presentation.getClientProperty("button");
        DefaultActionGroup group = SetTodoFilterAction.createPopupActionGroup(this.myProject, this.myToDoSettings, this.myTodoFilterConsumer);
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("TodoViewToolbar", (ActionGroup)group);
        popupMenu.getComponent().show(button, button.getWidth(), 0);
    }

    public JComponent createCustomComponent(Presentation presentation) {
        ActionButton button = new ActionButton(this, presentation, "TodoViewToolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        presentation.putClientProperty("button", (Object)button);
        return button;
    }

    public static DefaultActionGroup createPopupActionGroup(final Project project2, TodoPanelSettings settings, Consumer<TodoFilter> todoFilterConsumer) {
        TodoFilter[] filters = TodoConfiguration.getInstance().getTodoFilters();
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new TodoFilterApplier(IdeBundle.message((String)"action.todo.show.all", (Object[])new Object[0]), IdeBundle.message((String)"action.description.todo.show.all", (Object[])new Object[0]), null, settings, todoFilterConsumer));
        for (TodoFilter filter : filters) {
            group.add((AnAction)new TodoFilterApplier(filter.getName(), null, filter, settings, todoFilterConsumer));
        }
        group.addSeparator();
        group.add(new AnAction(IdeBundle.message((String)"action.todo.edit.filters", (Object[])new Object[0]), IdeBundle.message((String)"action.todo.edit.filters", (Object[])new Object[0]), AllIcons.General.Settings){

            public void actionPerformed(AnActionEvent e) {
                ShowSettingsUtil util = ShowSettingsUtil.getInstance();
                util.editConfigurable(project2, (Configurable)ConfigurableFactory.Companion.getInstance().getTodoConfigurable(project2));
            }
        });
        return group;
    }

    private static class TodoFilterApplier
    extends ToggleAction {
        private final TodoFilter myFilter;
        private final TodoPanelSettings mySettings;
        private final Consumer<TodoFilter> myTodoFilterConsumer;

        TodoFilterApplier(String text2, String description, TodoFilter filter, TodoPanelSettings settings, Consumer<TodoFilter> todoFilterConsumer) {
            super(null, description, null);
            this.mySettings = settings;
            this.myTodoFilterConsumer = todoFilterConsumer;
            this.getTemplatePresentation().setText(text2, false);
            this.myFilter = filter;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            if (this.myFilter != null) {
                e.getPresentation().setEnabled(!this.myFilter.isEmpty());
            }
        }

        public boolean isSelected(AnActionEvent e) {
            return Comparing.equal((String)(this.myFilter != null ? this.myFilter.getName() : null), (String)this.mySettings.todoFilterName);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                this.myTodoFilterConsumer.consume((Object)this.myFilter);
            }
        }
    }
}

