/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurableOptionsTopHitProvider
extends OptionsTopHitProvider {
    private static final Logger LOG = Logger.getInstance(ConfigurableOptionsTopHitProvider.class);
    private final Deque<String> myPrefix = new ArrayDeque<String>();

    protected abstract Configurable getConfigurable(Project var1);

    protected String getName(Configurable configurable) {
        return configurable.getDisplayName();
    }

    protected String getSection(Component component) {
        Border border;
        if (component instanceof JComponent && (border = ((JComponent)component).getBorder()) instanceof TitledBorder) {
            return ((TitledBorder)border).getTitle();
        }
        return null;
    }

    protected String getOptionName(JCheckBox checkbox) {
        String name2 = StringUtil.stripHtml((String)checkbox.getText(), (boolean)false);
        if (StringUtil.isEmpty((String)name2)) {
            return null;
        }
        if (this.myPrefix.isEmpty()) {
            return name2;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = this.myPrefix.descendingIterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next()).append(": ");
        }
        return sb.append(name2).toString();
    }

    protected void init(Collection<BooleanOptionDescription> options, Configurable configurable, Component component) {
        this.initRecursively(options, configurable, component);
    }

    private void initRecursively(Collection<BooleanOptionDescription> options, Configurable configurable, Component component) {
        String section = this.getSection(component);
        if (section != null) {
            this.myPrefix.push(section);
        }
        if (component instanceof JCheckBox) {
            JCheckBox checkbox = (JCheckBox)component;
            String option = this.getOptionName(checkbox);
            if (option != null) {
                options.add(new Option(configurable, checkbox, option));
            }
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
                this.initRecursively(options, configurable, container.getComponent(i2));
            }
        }
        if (section != null) {
            this.myPrefix.pop();
        }
    }

    @Override
    @NotNull
    public Collection<OptionDescription> getOptions(@Nullable Project project2) {
        Collection<BooleanOptionDescription> collection;
        try {
            Configurable configurable = this.getConfigurable(project2);
            JComponent component = configurable.createComponent();
            configurable.reset();
            this.myPrefix.clear();
            String name2 = this.getName(configurable);
            if (name2 != null) {
                this.myPrefix.push(name2);
            }
            ArrayList<BooleanOptionDescription> options = new ArrayList<BooleanOptionDescription>();
            this.init(options, configurable, component);
            collection = Collections.unmodifiableCollection(options);
        }
        catch (Exception exception) {
            LOG.debug((Throwable)exception);
            List<OptionDescription> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/ConfigurableOptionsTopHitProvider", "getOptions"));
            }
            return list2;
        }
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/ConfigurableOptionsTopHitProvider", "getOptions"));
        }
        return collection;
    }

    private static final class Option
    extends BooleanOptionDescription {
        private final Configurable myConfigurable;
        private final JCheckBox myCheckBox;

        private Option(Configurable configurable, JCheckBox checkbox, String option) {
            super(option, ConfigurableVisitor.ByID.getID(configurable));
            this.myConfigurable = configurable;
            this.myCheckBox = checkbox;
        }

        public boolean isOptionEnabled() {
            return this.myCheckBox.isSelected();
        }

        public void setOptionState(boolean selected) {
            if (selected != this.myCheckBox.isSelected()) {
                this.myCheckBox.setSelected(selected);
                try {
                    this.myConfigurable.apply();
                }
                catch (ConfigurationException exception) {
                    LOG.debug((Throwable)exception);
                }
            }
        }
    }
}

